/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.ORB;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] stringArray) {
        Object object;
        ORB oRB = ORB.init(stringArray, null);
        String string = null;
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.err.println("Usage: java PrintIOR [ ior_str | -f filename ]");
            System.exit(1);
        }
        if (stringArray[0].equals("-f")) {
            try {
                object = new BufferedReader(new FileReader(stringArray[1]), 2048);
                String string2 = ((BufferedReader)object).readLine();
                if (string2 != null) {
                    string = string2;
                    while (string2 != null) {
                        string2 = ((BufferedReader)object).readLine();
                        if (string2 == null) continue;
                        string = string + string2;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            string = stringArray[0];
        }
        if (string.startsWith("IOR:")) {
            object = new ParsedIOR(string);
            PrintIOR.printIOR((ParsedIOR)object, oRB);
        } else {
            System.out.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
    }

    public static void printIOR(ParsedIOR parsedIOR, ORB oRB) {
        IOR iOR = parsedIOR.getIOR();
        System.out.println("------IOR components-----");
        System.out.println("TypeId\t:\t" + iOR.type_id);
        ProfileBody_1_1[] profileBody_1_1Array = parsedIOR.getProfileBodies();
        System.out.println("TAG_INTERNET_IOP Profiles:");
        int n = 0;
        while (n < profileBody_1_1Array.length) {
            System.out.print("\tProfile Id   :  ");
            ProfileBody_1_1 profileBody_1_1 = profileBody_1_1Array[n];
            System.out.println("\tIIOP Version :  " + profileBody_1_1.iiop_version.major + "." + profileBody_1_1.iiop_version.minor);
            System.out.println("\tHost\t:\t" + profileBody_1_1.host);
            int n2 = profileBody_1_1.port;
            if (n2 < 0) {
                n2 += 65536;
            }
            System.out.println("\tPort\t:\t" + n2);
            try {
                System.out.println("\tObject key (URL):      " + CorbaLoc.parseKey(parsedIOR.get_object_key()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.print("\tObject key (hex):    0x");
            PrintIOR.dumpHex(parsedIOR.get_object_key());
            System.out.println();
            if (profileBody_1_1.iiop_version.minor >= 1) {
                if (profileBody_1_1.components.length > 0) {
                    System.out.println("\t-- Found " + profileBody_1_1.components.length + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(profileBody_1_1.components);
            }
            System.out.print("\n");
            ++n;
        }
        oRB.shutdown(true);
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponentArray) {
        int n = 0;
        while (n < taggedComponentArray.length) {
            switch (taggedComponentArray[n].tag) {
                case 20: {
                    System.out.println("\t#" + n + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponentArray[n]);
                    break;
                }
                case 33: {
                    System.out.println("\t#" + n + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponentArray[n]);
                    break;
                }
                case 35: {
                    System.out.println("\t#" + n + ": TAG_SECIOP_SEC_TRANS");
                    break;
                }
                case 3: {
                    System.out.println("\t#" + n + ": TAG_ALTERNATIVE_IIOP_ADDRESS");
                    break;
                }
                case 1: {
                    System.out.println("\t#" + n + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponentArray[n]);
                    break;
                }
                case 25: {
                    System.out.println("\t#" + n + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponentArray[n]);
                    break;
                }
                default: {
                    System.out.println("\tUnknown tag : " + taggedComponentArray[n].tag);
                }
            }
            ++n;
        }
    }

    private static void printCSIMechComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.read(cDRInputStream);
        if (compoundSecMechList != null) {
            System.out.println("\t\tis stateful: " + compoundSecMechList.stateful);
            int n = 0;
            while (n < compoundSecMechList.mechanism_list.length) {
                System.out.println("\t\tCompoundSecMech #" + n);
                System.out.println("\t\t\ttarget_requires: " + compoundSecMechList.mechanism_list[n].target_requires);
                System.out.print("\t\t\ttransport mechanism tag: ");
                switch (compoundSecMechList.mechanism_list[n].transport_mech.tag) {
                    case 36: {
                        System.out.println("TAG_TLS_SEC_TRANS");
                        break;
                    }
                    default: {
                        System.out.println("Unknown tag : " + compoundSecMechList.mechanism_list[n].transport_mech.tag);
                    }
                }
                if (compoundSecMechList.mechanism_list[n].as_context_mech.target_supports == 0) {
                    System.out.println("\t\t\tNo AS_ContextSec Mechanism.: ");
                } else {
                    System.out.println("\t\t\tAS_ContextSec mech: " + new String(compoundSecMechList.mechanism_list[n].as_context_mech.client_authentication_mech));
                }
                ++n;
            }
        }
    }

    private static void printCodeSetComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        CodeSetComponentInfo codeSetComponentInfo = CodeSetComponentInfoHelper.read(cDRInputStream);
        if (codeSetComponentInfo != null) {
            System.out.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForCharData.native_code_set));
            System.out.print("\t\tChar Conversion Code Sets: ");
            int n = 0;
            while (n < codeSetComponentInfo.ForCharData.conversion_code_sets.length) {
                System.out.println(CodeSet.csName(codeSetComponentInfo.ForCharData.conversion_code_sets[n]) + ",");
                ++n;
            }
            System.out.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForWcharData.native_code_set));
            System.out.print("\t\tWChar Conversion Code Sets: ");
            int n2 = 0;
            while (n2 < codeSetComponentInfo.ForWcharData.conversion_code_sets.length) {
                System.out.println(CodeSet.csName(codeSetComponentInfo.ForWcharData.conversion_code_sets[n2]) + ",");
                ++n2;
            }
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent) {
        SSL sSL = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
            try {
                cDRInputStream.openEncapsulatedArray();
                sSL = SSLHelper.read(cDRInputStream);
            }
            catch (Exception exception) {
                return;
            }
            int n = sSL.port;
            if (n < 0) {
                n += 65536;
            }
            System.out.print("\t\ttarget_supports\t:\t");
            PrintIOR.dump(sSL.target_supports);
            System.out.println();
            System.out.print("\t\ttarget_requires\t:\t");
            PrintIOR.dump(sSL.target_requires);
            System.out.println();
            System.out.println("\t\tSSL Port\t:\t" + n);
        }
    }

    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent) {
        CDRInputStream cDRInputStream = new CDRInputStream(null, taggedComponent.component_data);
        cDRInputStream.openEncapsulatedArray();
        String string = cDRInputStream.read_string();
        System.out.println("\t\tCodebase: " + string);
    }

    public static void dumpHex(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = (byArray[n] & 0xFF) / 16;
            int n3 = (byArray[n] & 0xFF) % 16;
            char c = n2 > 9 ? (char)(65 + (n2 - 10)) : (char)(48 + n2);
            char c2 = n3 > 9 ? (char)(65 + (n3 - 10)) : (char)(48 + n3);
            System.out.print("" + c + c2 + " ");
            ++n;
        }
    }

    public static void dump(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            PrintIOR.dump(byArray[n]);
            System.out.print(" ");
            ++n;
        }
    }

    public static void dump(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            PrintIOR.dump(nArray[n]);
            System.out.print(" ");
            ++n;
        }
    }

    public static void dump(byte by) {
        System.out.print("" + hexDigit[by >> 4 & 0xF] + hexDigit[by & 0xF]);
    }

    public static void dump(short s) {
        System.out.print("" + hexDigit[s >> 12 & 0xF] + hexDigit[s >> 9 & 0xF] + hexDigit[s >> 4 & 0xF] + hexDigit[s & 0xF]);
    }

    public static void dump(int n) {
        System.out.print("" + hexDigit[n >> 28 & 0xF] + hexDigit[n >> 24 & 0xF] + hexDigit[n >> 20 & 0xF] + hexDigit[n >> 16 & 0xF] + hexDigit[n >> 12 & 0xF] + hexDigit[n >> 8 & 0xF] + hexDigit[n >> 4 & 0xF] + hexDigit[n & 0xF]);
    }

    public static void dump(byte[] byArray, boolean bl) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (0 == n2 % 16) {
                System.out.println();
            }
            char c = byArray[n2] > 31 && byArray[n2] < 127 ? (char)((char)byArray[n2]) : (char)' ';
            System.out.print(":" + hexDigit[byArray[n2] >> 4 & 0xF] + hexDigit[byArray[n2] & 0xF] + " " + c);
            ++n2;
        }
    }
}

