/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.OfferProperty;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.RegisterPackage.OfferInfo;

public class Offer
implements Serializable {
    private String m_id;
    private String m_object;
    private Vector m_props;
    private transient OfferInfo m_description;
    static final long serialVersionUID = 4241426996695613295L;

    private Offer() {
    }

    public Offer(String string, Object object, Property[] propertyArray) {
        this.m_id = string;
        this.m_object = TradingService.getORB().object_to_string(object);
        this.setProperties(propertyArray);
        this.m_description = null;
    }

    public OfferInfo describe() {
        OfferInfo offerInfo = null;
        if (this.m_description == null) {
            offerInfo = new OfferInfo();
            offerInfo.reference = TradingService.getORB().string_to_object(this.m_object);
            offerInfo.properties = new Property[this.m_props.size()];
            int n = 0;
            Enumeration enumeration = this.m_props.elements();
            while (enumeration.hasMoreElements()) {
                OfferProperty offerProperty = (OfferProperty)enumeration.nextElement();
                offerInfo.properties[n] = offerProperty.describe();
                ++n;
            }
            this.m_description = offerInfo;
        } else {
            offerInfo = this.m_description;
        }
        return offerInfo;
    }

    public void modify(Property[] propertyArray) {
        this.setProperties(propertyArray);
        this.m_description = null;
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(java.lang.Object object) {
        Offer offer = (Offer)object;
        return this.m_id.equals(offer.m_id);
    }

    protected void setProperties(Property[] propertyArray) {
        this.m_props = new Vector();
        int n = 0;
        while (n < propertyArray.length) {
            OfferProperty offerProperty = new OfferProperty(propertyArray[n]);
            this.m_props.addElement(offerProperty);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_description = null;
    }
}

