/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.jrmp.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import javax.transaction.SystemException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.tm.TransactionPropagationContextFactory;

public class JRMPInvokerProxy
implements Invoker,
Externalizable {
    protected Invoker remoteInvoker;
    protected static TransactionPropagationContextFactory tpcFactory = null;

    public static void setTPCFactory(TransactionPropagationContextFactory tpcf) {
        tpcFactory = tpcf;
    }

    public JRMPInvokerProxy() {
    }

    public JRMPInvokerProxy(Invoker remoteInvoker) {
        this.remoteInvoker = remoteInvoker;
    }

    public String getServerHostName() throws Exception {
        return this.remoteInvoker.getServerHostName();
    }

    public Object getTransactionPropagationContext() throws SystemException {
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public Object invoke(Invocation invocation) throws Exception {
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setTransactionPropagationContext(this.getTransactionPropagationContext());
        try {
            return ((MarshalledObject)this.remoteInvoker.invoke(mi)).get();
        }
        catch (ServerException ex) {
            if (ex.detail instanceof NoSuchObjectException) {
                throw (NoSuchObjectException)ex.detail;
            }
            throw ex;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.remoteInvoker);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.remoteInvoker = (Invoker)in.readObject();
    }
}

