/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.compiler;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.jboss.proxy.compiler.InvocationHandler;
import org.jboss.proxy.compiler.ProxyCompiler;

public class Runtime
extends ClassLoader {
    public static final String RUNTIME_FN = "runtime";
    Class[] targetTypes;
    Method[] methods;
    ProxyCompiler compiler;

    public Runtime(ClassLoader parent) {
        super(parent);
    }

    public Class[] copyTargetTypes() {
        return (Class[])this.targetTypes.clone();
    }

    public Object invoke(InvocationHandler invocationHandler, int methodNum, Object[] values) throws Throwable {
        return invocationHandler.invoke(null, this.methods[methodNum], values);
    }

    void makeProxyType(ProxyCompiler compiler) throws Exception {
        this.compiler = compiler;
        byte[] code = compiler.getCode();
        compiler.proxyType = super.defineClass(compiler.getProxyClassName(), code, 0, code.length);
        super.resolveClass(compiler.proxyType);
        Field field = compiler.proxyType.getField(RUNTIME_FN);
        field.set(null, this);
        compiler = null;
    }

    ClassLoader getTargetClassLoader() {
        return this.getParent();
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.endsWith("$Proxy") && name.equals(this.compiler.getProxyClassName())) {
            return this.compiler.proxyType;
        }
        ClassLoader cl = this.getTargetClassLoader();
        if (cl == null) {
            return super.findSystemClass(name);
        }
        return cl.loadClass(name);
    }

    public InputStream getResourceAsStream(String name) {
        ClassLoader cl = this.getTargetClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return cl.getResourceAsStream(name);
    }

    public URL getResource(String name) {
        ClassLoader cl = this.getTargetClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(name);
        }
        return cl.getResource(name);
    }
}

