/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyMessage;

public class SpyMapMessage
extends SpyMessage
implements MapMessage,
Cloneable,
Externalizable {
    Hashtable content = new Hashtable();
    private static final long serialVersionUID = -4917633165373197269L;

    public void setBoolean(String name, boolean value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Boolean(value));
    }

    public void setByte(String name, byte value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Byte(value));
    }

    public void setShort(String name, short value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Short(value));
    }

    public void setChar(String name, char value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Character(value));
    }

    public void setInt(String name, int value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Integer(value));
    }

    public void setLong(String name, long value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Long(value));
    }

    public void setFloat(String name, float value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Float(value));
    }

    public void setDouble(String name, double value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, new Double(value));
    }

    public void setString(String name, String value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, value);
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        this.content.put(name, value.clone());
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        if (offset + length > value.length) {
            throw new JMSException("Array is too small");
        }
        byte[] temp = new byte[length];
        int i = 0;
        while (i < length) {
            temp[i] = value[i + offset];
            ++i;
        }
        this.content.put(name, temp);
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.header.msgReadOnly) {
            throw new MessageNotWriteableException("Message is ReadOnly !");
        }
        if (value instanceof Boolean) {
            this.content.put(name, value);
        } else if (value instanceof Byte) {
            this.content.put(name, value);
        } else if (value instanceof Short) {
            this.content.put(name, value);
        } else if (value instanceof Character) {
            this.content.put(name, value);
        } else if (value instanceof Integer) {
            this.content.put(name, value);
        } else if (value instanceof Long) {
            this.content.put(name, value);
        } else if (value instanceof Float) {
            this.content.put(name, value);
        } else if (value instanceof Double) {
            this.content.put(name, value);
        } else if (value instanceof String) {
            this.content.put(name, value);
        } else if (value instanceof byte[]) {
            this.content.put(name, ((byte[])value).clone());
        } else {
            throw new MessageFormatException("Invalid object type");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Boolean.getBoolean(null);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.getBoolean((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte getByte(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Byte.parseByte(null);
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public short getShort(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Short.parseShort(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).shortValue();
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public char getChar(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid conversion");
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public int getInt(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Integer.parseInt(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public long getLong(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Long.parseLong(null);
        }
        if (value instanceof Byte) {
            return ((Byte)value).longValue();
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public float getFloat(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Float.parseFloat(null);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public double getDouble(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return Double.parseDouble(null);
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public String getString(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Byte) {
            return ((Byte)value).toString();
        }
        if (value instanceof Short) {
            return ((Short)value).toString();
        }
        if (value instanceof Character) {
            return ((Character)value).toString();
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString();
        }
        if (value instanceof Long) {
            return ((Long)value).toString();
        }
        if (value instanceof Float) {
            return ((Float)value).toString();
        }
        if (value instanceof Double) {
            return ((Double)value).toString();
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public byte[] getBytes(String name) throws JMSException {
        Object value = this.content.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new MessageFormatException("Invalid conversion");
    }

    public Object getObject(String name) throws JMSException {
        return this.content.get(name);
    }

    public Enumeration getMapNames() throws JMSException {
        return this.content.keys();
    }

    public boolean itemExists(String name) throws JMSException {
        return this.content.containsKey(name);
    }

    public void clearBody() throws JMSException {
        this.content = new Hashtable();
        super.clearBody();
    }

    public SpyMessage myClone() throws JMSException {
        SpyMapMessage result = MessagePool.getMapMessage();
        result.copyProps(this);
        result.content = (Hashtable)this.content.clone();
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.content);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.content = (Hashtable)in.readObject();
    }
}

