/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XATopicSession;
import org.jboss.mq.Connection;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.SpyTopicPublisher;
import org.jboss.mq.SpyTopicSubscriber;

public class SpyTopicSession
extends SpySession
implements TopicSession,
XATopicSession {
    SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode) {
        this(myConnection, transacted, acknowledgeMode, false);
    }

    SpyTopicSession(Connection myConnection, boolean transacted, int acknowledgeMode, boolean xaSession) {
        super(myConnection, transacted, acknowledgeMode, xaSession);
    }

    public TopicSession getTopicSession() throws JMSException {
        return this;
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (topicName == null) {
            throw new InvalidDestinationException("The topic name cannot be null");
        }
        return ((SpyConnection)this.connection).createTopic(topicName);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        return this.createSubscriber(topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, (SpyTopic)topic, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.connection.getClientID(), name, null);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, t, false, null);
        this.addConsumer(sub);
        return sub;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Topic cannot be null");
        }
        SpyTopic t = new SpyTopic((SpyTopic)topic, this.connection.getClientID(), name, messageSelector);
        SpyTopicSubscriber sub = new SpyTopicSubscriber(this, t, noLocal, messageSelector);
        this.addConsumer(sub);
        return sub;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return new SpyTopicPublisher(this, topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The session is closed");
        }
        return ((SpyConnection)this.connection).getTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        DurableSubscriptionID id = new DurableSubscriptionID(this.connection.getClientID(), name, null);
        this.connection.unsubscribe(id);
    }
}

