/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.HashSet;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.TopicSession;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.jboss.mq.GenericConnectionFactory;
import org.jboss.mq.SpyConnection;
import org.jboss.mq.SpyQueueSession;
import org.jboss.mq.SpyTopicSession;

public class SpyXAConnection
extends SpyConnection
implements Serializable,
XATopicConnection,
XAQueueConnection {
    public SpyXAConnection(String userid, String password, GenericConnectionFactory gcf) throws JMSException {
        super(userid, password, gcf);
    }

    public SpyXAConnection(GenericConnectionFactory gcf) throws JMSException {
        super(gcf);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (QueueSession)this.createXAQueueSession();
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyQueueSession session = new SpyQueueSession(this, true, 0, true);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        return (TopicSession)this.createXATopicSession();
    }

    public XATopicSession createXATopicSession() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The connection is closed");
        }
        this.checkClientID();
        SpyTopicSession session = new SpyTopicSession(this, true, 0, true);
        HashSet hashSet = this.createdSessions;
        synchronized (hashSet) {
            this.createdSessions.add(session);
        }
        return session;
    }
}

