/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;

public class TxManager {
    HashMap postCommitTasks = new HashMap();
    HashMap postRollbackTasks = new HashMap();
    HashMap globalToLocal = new HashMap();
    ArrayList listPool = new ArrayList();
    PersistenceManager persistenceManager;
    protected static int MAX_POOL_SIZE = 500;

    public TxManager(PersistenceManager pm) {
        this.persistenceManager = pm;
    }

    public final Tx getPrepared(ConnectionToken dc, Object xid) throws JMSException {
        Tx txid;
        GlobalXID gxid = new GlobalXID(dc, xid);
        HashMap hashMap = this.globalToLocal;
        synchronized (hashMap) {
            txid = (Tx)this.globalToLocal.get(gxid);
        }
        if (txid == null) {
            throw new SpyJMSException("Transaction does not exist from: " + dc.getClientID() + " xid=" + xid);
        }
        return txid;
    }

    public final Tx createTx() throws JMSException {
        Tx txId = this.persistenceManager.createPersistentTx();
        HashMap hashMap = this.postCommitTasks;
        synchronized (hashMap) {
            this.postCommitTasks.put(txId, this.getList());
            this.postRollbackTasks.put(txId, this.getList());
        }
        return txId;
    }

    public final void commitTx(Tx txId) throws JMSException {
        LinkedList tasks;
        HashMap hashMap = this.postCommitTasks;
        synchronized (hashMap) {
            tasks = (LinkedList)this.postCommitTasks.remove(txId);
            this.releaseList((LinkedList)this.postRollbackTasks.remove(txId));
        }
        if (tasks == null) {
            throw new JMSException("Transaction is not active for commit.");
        }
        this.persistenceManager.commitPersistentTx(txId);
        LinkedList linkedList = tasks;
        synchronized (linkedList) {
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Runnable task = (Runnable)iter.next();
                task.run();
            }
        }
        this.releaseList(tasks);
    }

    public final void addPostCommitTask(Tx txId, Runnable task) throws JMSException {
        LinkedList tasks;
        if (txId == null) {
            task.run();
            return;
        }
        HashMap hashMap = this.postCommitTasks;
        synchronized (hashMap) {
            tasks = (LinkedList)this.postCommitTasks.get(txId);
        }
        if (tasks == null) {
            throw new JMSException("Transaction is not active.");
        }
        LinkedList linkedList = tasks;
        synchronized (linkedList) {
            tasks.addLast(task);
        }
    }

    public final void rollbackTx(Tx txId) throws JMSException {
        LinkedList tasks;
        HashMap hashMap = this.postCommitTasks;
        synchronized (hashMap) {
            tasks = (LinkedList)this.postRollbackTasks.remove(txId);
            this.releaseList((LinkedList)this.postCommitTasks.remove(txId));
        }
        if (tasks == null) {
            throw new JMSException("Transaction is not active 3.");
        }
        this.persistenceManager.rollbackPersistentTx(txId);
        LinkedList linkedList = tasks;
        synchronized (linkedList) {
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Runnable task = (Runnable)iter.next();
                task.run();
            }
        }
        this.releaseList(tasks);
    }

    public final void addPostRollbackTask(Tx txId, Runnable task) throws JMSException {
        LinkedList tasks;
        if (txId == null) {
            return;
        }
        HashMap hashMap = this.postCommitTasks;
        synchronized (hashMap) {
            tasks = (LinkedList)this.postRollbackTasks.get(txId);
        }
        if (tasks == null) {
            throw new JMSException("Transaction is not active 4.");
        }
        LinkedList linkedList = tasks;
        synchronized (linkedList) {
            tasks.addLast(task);
        }
    }

    public final Tx createTx(ConnectionToken dc, Object xid) throws JMSException {
        GlobalXID gxid = new GlobalXID(dc, xid);
        HashMap hashMap = this.globalToLocal;
        synchronized (hashMap) {
            if (this.globalToLocal.containsKey(gxid)) {
                throw new SpyJMSException("Duplicate transaction from: " + dc.getClientID() + " xid=" + xid);
            }
        }
        Tx txId = this.createTx();
        HashMap hashMap2 = this.globalToLocal;
        synchronized (hashMap2) {
            this.globalToLocal.put(gxid, txId);
        }
        this.addPostCommitTask(txId, gxid);
        this.addPostRollbackTask(txId, gxid);
        return txId;
    }

    protected LinkedList getList() {
        ArrayList arrayList = this.listPool;
        synchronized (arrayList) {
            if (this.listPool.isEmpty()) {
                LinkedList linkedList = new LinkedList();
                return linkedList;
            }
            LinkedList linkedList = (LinkedList)this.listPool.remove(this.listPool.size() - 1);
            return linkedList;
        }
    }

    protected void releaseList(LinkedList list) {
        ArrayList arrayList = this.listPool;
        synchronized (arrayList) {
            if (this.listPool.size() < MAX_POOL_SIZE) {
                list.clear();
                this.listPool.add(list);
            }
        }
    }

    class GlobalXID
    implements Runnable {
        ConnectionToken dc;
        Object xid;
        static /* synthetic */ Class class$org$jboss$mq$pm$TxManager$GlobalXID;

        GlobalXID(ConnectionToken dc, Object xid) {
            this.dc = dc;
            this.xid = xid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != (class$org$jboss$mq$pm$TxManager$GlobalXID == null ? (class$org$jboss$mq$pm$TxManager$GlobalXID = GlobalXID.class$("org.jboss.mq.pm.TxManager$GlobalXID")) : class$org$jboss$mq$pm$TxManager$GlobalXID)) {
                return false;
            }
            return ((GlobalXID)obj).xid.equals(this.xid) && ((GlobalXID)obj).dc.equals(this.dc);
        }

        public int hashCode() {
            return this.xid.hashCode();
        }

        public void run() {
            HashMap hashMap = TxManager.this.globalToLocal;
            synchronized (hashMap) {
                TxManager.this.globalToLocal.remove(this);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

