/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.file.PersistenceManager;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;

public class MessageLog {
    private File queueName;
    private MessageCache messageCache;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$mq$pm$file$MessageLog == null ? (class$org$jboss$mq$pm$file$MessageLog = MessageLog.class$("org.jboss.mq.pm.file.MessageLog")) : class$org$jboss$mq$pm$file$MessageLog));
    static /* synthetic */ Class class$org$jboss$mq$pm$file$MessageLog;

    public MessageLog(MessageCache messageCache, File file) throws JMSException {
        if (messageCache == null) {
            throw new IllegalArgumentException("Need a MessageCache to construct a MessageLog!");
        }
        this.messageCache = messageCache;
        this.queueName = file;
        if (!this.queueName.exists() && !this.queueName.mkdirs()) {
            throw new JMSException("Could not create the directory: " + this.queueName);
        }
        log.debug((Object)("Message directory created: " + this.queueName));
    }

    public void close() throws JMSException {
    }

    public Map restore(TreeSet rollBackTXs) throws JMSException {
        TreeMap messageIndex = new TreeMap();
        try {
            File[] files = this.queueName.listFiles();
            int i = 0;
            while (i < files.length) {
                String fileName = files[i].getName();
                int extIndex = fileName.indexOf(".");
                if (extIndex < 0) {
                    this.restoreMessageFromFile(messageIndex, files[i]);
                } else {
                    Long tx = new Long(Long.parseLong(fileName.substring(extIndex + 1)));
                    if (rollBackTXs.contains(tx)) {
                        this.delete(files[i]);
                    } else {
                        this.restoreMessageFromFile(messageIndex, files[i]);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.throwJMSException("Could not rebuild the queue from the queue's tranaction log.", e);
        }
        return messageIndex;
    }

    public void add(MessageReference messageRef, Tx transactionId) throws JMSException {
        try {
            SpyMessage message = messageRef.getMessage();
            String fileName = PersistenceManager.encodeFileName(message.getJMSMessageID());
            File f = transactionId == null ? new File(this.queueName, fileName) : new File(this.queueName, fileName + "." + transactionId);
            this.writeMessageToFile(message, f);
            messageRef.persistData = f;
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public void finishAdd(MessageReference message, Tx transactionId) throws JMSException {
    }

    public void finishRemove(MessageReference messageRef, Tx transactionId) throws JMSException {
        try {
            File file = (File)messageRef.persistData;
            this.delete(file);
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public void remove(SpyMessage message, Tx transactionId) throws JMSException {
    }

    public void undoAdd(MessageReference messageRef, Tx transactionId) throws JMSException {
        try {
            File file = (File)messageRef.persistData;
            this.delete(file);
        }
        catch (IOException e) {
            this.throwJMSException("Could not write to the tranaction log.", e);
        }
    }

    public void undoRemove(MessageReference message, Tx transactionId) throws JMSException {
    }

    protected void delete(File file) throws IOException {
        if (!file.delete()) {
            Thread.yield();
            if (file.exists()) {
                if (!file.delete()) {
                    log.warn((Object)("Failed to delete file: " + file.getAbsolutePath()));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("File was deleted, but delete() failed for: " + file.getAbsolutePath()));
            }
        }
    }

    protected void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            Thread.yield();
            if (from.exists()) {
                if (!from.renameTo(to)) {
                    log.warn((Object)("Rename of file " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + " failed."));
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("Rename of file " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + " failed but from no longer exists?"));
            }
        }
    }

    protected void writeMessageToFile(SpyMessage message, File file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeLong(message.header.messageId);
        SpyMessage.writeMessage(message, out);
        out.flush();
        out.close();
    }

    protected void restoreMessageFromFile(TreeMap store, File file) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        long msgId = in.readLong();
        SpyMessage message = SpyMessage.readMessage(in);
        in.close();
        message.header.messageId = msgId;
        MessageReference mr = this.messageCache.add(message);
        mr.persistData = file;
        store.put(new Long(msgId), mr);
    }

    private void throwJMSException(String message, Exception e) throws JMSException {
        SpyJMSException newE = new SpyJMSException(message);
        newE.setLinkedException(e);
        throw newE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

