/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.pm.rollinglogged;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.jms.JMSException;
import javax.management.ObjectName;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.pm.TxManager;
import org.jboss.mq.pm.rollinglogged.PersistenceManagerMBean;
import org.jboss.mq.pm.rollinglogged.SpyMessageLog;
import org.jboss.mq.pm.rollinglogged.SpyTxLog;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSQueue;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.server.MessageCache;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class PersistenceManager
extends ServiceMBeanSupport
implements org.jboss.mq.pm.PersistenceManager,
PersistenceManagerMBean {
    public static final String TRANS_FILE_NAME = "transactions.dat";
    protected static int MAX_POOL_SIZE = 50;
    private ObjectName messageCacheName;
    private MessageCache messageCache;
    protected ArrayList listPool = new ArrayList();
    protected ArrayList txPool = new ArrayList();
    protected int messageCounter = 0;
    int numRollOvers = 0;
    HashMap queues = new HashMap();
    SpyTxLog currentTxLog;
    long nextTxId = Long.MIN_VALUE;
    HashMap messageLogs = new HashMap();
    HashMap transToTxLogs = new HashMap();
    File dataDir;
    TxManager txManager;
    private String dataDirectory;
    private int rollOverSize;
    private HashMap unrestoredMessages = new HashMap();

    public PersistenceManager() throws JMSException {
        this.txManager = new TxManager(this);
    }

    public ObjectName getMessageCache() {
        return this.messageCacheName;
    }

    public void setMessageCache(ObjectName messageCache) {
        this.messageCacheName = messageCache;
    }

    public MessageCache getMessageCacheInstance() {
        return this.messageCache;
    }

    public void setDataDirectory(String newDataDirectory) {
        this.dataDirectory = newDataDirectory;
    }

    public String getDataDirectory() {
        return this.dataDirectory;
    }

    public void setRollOverSize(int rollOverSize) {
        this.rollOverSize = rollOverSize;
    }

    public int getRollOverSize() {
        return this.rollOverSize;
    }

    public Object getInstance() {
        return this;
    }

    public TxManager getTxManager() {
        return this.txManager;
    }

    public void startService() throws Exception {
        this.log.debug((Object)"Using new rolling logged persistence manager.");
        File systemHomeDir = ServerConfigLocator.locate().getServerHomeDir();
        this.dataDir = new File(systemHomeDir, this.dataDirectory);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using data directory: " + this.dataDir));
        }
        this.dataDir.mkdirs();
        if (!this.dataDir.isDirectory()) {
            throw new Exception("The data directory is not valid: " + this.dataDir.getCanonicalPath());
        }
        this.messageCache = (MessageCache)this.getServer().invoke(this.messageCacheName, "getInstance", new Object[0], new String[0]);
        this.restoreTransactions();
    }

    public void add(MessageReference messageRef, Tx txId) throws JMSException {
        LogInfo logInfo;
        HashMap logs;
        SpyMessage message = messageRef.getMessage();
        SpyTxLog txLog = null;
        if (txId == null) {
            txLog = this.currentTxLog;
        } else {
            HashMap hashMap = this.transToTxLogs;
            synchronized (hashMap) {
                txLog = ((TxInfo)this.transToTxLogs.get((Object)txId)).log;
            }
        }
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logs = (HashMap)this.messageLogs.get(txLog);
        }
        HashMap hashMap2 = logs;
        synchronized (hashMap2) {
            logInfo = (LogInfo)logs.get(message.getJMSDestination().toString());
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        LogInfo logInfo2 = logInfo;
        synchronized (logInfo2) {
            ++logInfo.liveMessages;
            messageRef.persistData = logInfo;
            logInfo.log.add(message, txId);
        }
        if (txId != null) {
            HashMap hashMap3 = this.transToTxLogs;
            synchronized (hashMap3) {
                TxInfo txInfo = (TxInfo)this.transToTxLogs.get(txId);
                txInfo.addMessages.add(message);
            }
        }
        this.checkRollOver();
    }

    public void commitPersistentTx(Tx txId) throws JMSException {
        TxInfo info = null;
        LinkedList messagesToDelete = null;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            info = (TxInfo)this.transToTxLogs.remove(txId);
            messagesToDelete = info.ackMessages;
        }
        this.deleteMessages(messagesToDelete);
        info.log.commitTx(txId);
        HashMap hashMap2 = this.transToTxLogs;
        synchronized (hashMap2) {
            this.releaseTx(txId);
            this.releaseTxInfo(info);
        }
        this.checkCleanup();
    }

    public Tx createPersistentTx() throws JMSException {
        Tx txId = null;
        SpyTxLog txLog = this.currentTxLog;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            txId = this.getTx(++this.nextTxId);
            this.transToTxLogs.put(txId, this.getTxInfo(txId, txLog));
        }
        txLog.createTx();
        return txId;
    }

    public void remove(MessageReference messageRef, Tx txId) throws JMSException {
        Object object;
        LogInfo logInfo;
        SpyMessage message = messageRef.getMessage();
        SpyTxLog txLog = ((LogInfo)messageRef.persistData).txLog;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            HashMap logs = (HashMap)this.messageLogs.get(txLog);
            if (logs == null) {
                this.log.error((Object)"keys for messageLogs are:");
                Iterator i = this.messageLogs.keySet().iterator();
                while (i.hasNext()) {
                    this.log.error((Object)i.next().toString());
                }
                throw new JMSException("no logs for this txLog: " + txLog);
            }
            String destName = message.getJMSDestination().toString();
            logInfo = (LogInfo)logs.get(destName);
        }
        if (logInfo == null) {
            throw new JMSException("Destination was not initalized with the PersistenceManager");
        }
        SpyMessageLog spyMessageLog = logInfo.log;
        synchronized (spyMessageLog) {
            logInfo.log.remove(message, txId);
        }
        if (txId != null) {
            object = this.transToTxLogs;
            synchronized (object) {
                TxInfo txInfo = (TxInfo)this.transToTxLogs.get(txId);
                txInfo.ackMessages.add(messageRef);
            }
        }
        if (txId == null) {
            object = logInfo;
            synchronized (object) {
                --logInfo.liveMessages;
            }
        }
    }

    public void restoreTransactions() throws JMSException {
        TreeSet committedTxs = new TreeSet();
        HashMap<Integer, SpyTxLog> txLogs = new HashMap<Integer, SpyTxLog>();
        File dir = this.dataDir;
        File[] dataFiles = dir.listFiles();
        int i = 0;
        while (i < dataFiles.length) {
            int index;
            String name = dataFiles[i].getName();
            if (name.startsWith(TRANS_FILE_NAME) && (index = name.indexOf(".dat")) >= 0) {
                String sRollOver = name.substring(index + 4);
                int rollOver = Integer.parseInt(sRollOver);
                this.numRollOvers = Math.max(this.numRollOvers, rollOver);
                SpyTxLog txLog = new SpyTxLog(dataFiles[i]);
                txLog.restore(committedTxs);
                txLogs.put(new Integer(rollOver), txLog);
                this.messageLogs.put(txLog, new HashMap());
            }
            ++i;
        }
        if (!committedTxs.isEmpty()) {
            this.nextTxId = ((Tx)committedTxs.last()).longValue();
        }
        int i2 = 0;
        while (i2 < dataFiles.length) {
            String name = dataFiles[i2].getName();
            int index = name.indexOf(".dat");
            if (index >= 0) {
                String sRollOver = name.substring(index + 4);
                int rollOver = Integer.parseInt(sRollOver);
                String key = name.substring(0, name.length() - (sRollOver.length() + 4));
                if (!name.startsWith(TRANS_FILE_NAME)) {
                    HashMap messages = (HashMap)this.unrestoredMessages.get(key);
                    if (messages == null) {
                        messages = new HashMap();
                        this.unrestoredMessages.put(key, messages);
                    }
                    SpyMessageLog messageLog = new SpyMessageLog(this.messageCache, dataFiles[i2]);
                    SpyTxLog txLog = (SpyTxLog)txLogs.get(new Integer(rollOver));
                    if (txLog == null) {
                        this.log.warn((Object)("no transaction log for message log " + dataFiles[i2]));
                    } else {
                        LogInfo info = new LogInfo(messageLog, null, txLog);
                        messageLog.restore(committedTxs, info, messages);
                        HashMap logs = (HashMap)this.messageLogs.get(txLog);
                        logs.put(key, info);
                        this.unrestoredMessages.put(key, messages);
                    }
                }
            }
            ++i2;
        }
        this.rollOverLogs();
    }

    public void restoreDestination(JMSDestination jmsDest) throws JMSException {
        if (jmsDest instanceof JMSQueue) {
            SpyDestination spyDest = jmsDest.getSpyDestination();
            this.restoreQueue(jmsDest, spyDest);
        } else if (jmsDest instanceof JMSTopic) {
            ArrayList persistQList = ((JMSTopic)jmsDest).getPersistentQueues();
            Iterator pq = persistQList.iterator();
            while (pq.hasNext()) {
                SpyDestination spyDest = ((PersistentQueue)pq.next()).getSpyDestination();
                this.restoreQueue(jmsDest, spyDest);
            }
        }
        if (this.unrestoredMessages.isEmpty()) {
            this.checkCleanup();
        }
    }

    public void restoreQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
        Object object;
        String queueName = dest.toString();
        this.queues.put(queueName, dest);
        Iterator txLogIt = this.messageLogs.keySet().iterator();
        while (txLogIt.hasNext()) {
            SpyTxLog txLog = (SpyTxLog)txLogIt.next();
            HashMap logs = (HashMap)this.messageLogs.get(txLog);
            LogInfo info = (LogInfo)logs.get(queueName);
            if (info == null) continue;
            info.destination = dest;
        }
        HashMap messages = (HashMap)this.unrestoredMessages.remove(queueName);
        if (messages != null) {
            object = jmsDest;
            synchronized (object) {
                Iterator m = messages.values().iterator();
                while (m.hasNext()) {
                    MessageReference message = (MessageReference)m.next();
                    if (dest instanceof SpyTopic) {
                        SpyMessage sm = message.getMessage();
                        sm.header.durableSubscriberID = ((SpyTopic)dest).getDurableSubscriptionID();
                        message.invalidate();
                    }
                    jmsDest.restoreMessage(message);
                }
            }
        }
        object = this.messageLogs;
        synchronized (object) {
            HashMap logs = (HashMap)this.messageLogs.get(this.currentTxLog);
            logs.put(queueName, this.newQueueInfo(dest, this.currentTxLog));
        }
    }

    public void rollbackPersistentTx(Tx txId) throws JMSException {
        TxInfo info = null;
        LinkedList messagesToDelete = null;
        HashMap hashMap = this.transToTxLogs;
        synchronized (hashMap) {
            info = (TxInfo)this.transToTxLogs.remove(txId);
            messagesToDelete = info.addMessages;
        }
        this.deleteMessages(messagesToDelete);
        info.log.rollbackTx(txId);
        HashMap hashMap2 = this.transToTxLogs;
        synchronized (hashMap2) {
            this.releaseTx(txId);
            this.releaseTxInfo(info);
        }
    }

    protected Tx getTx(long value) {
        if (this.txPool.isEmpty()) {
            return new Tx(value);
        }
        Tx tx = (Tx)this.txPool.remove(this.txPool.size() - 1);
        tx.setValue(value);
        return tx;
    }

    protected TxInfo getTxInfo(Tx txId, SpyTxLog txLog) {
        if (this.listPool.isEmpty()) {
            return new TxInfo(txId, txLog);
        }
        TxInfo info = (TxInfo)this.listPool.remove(this.listPool.size() - 1);
        info.txId = txId;
        info.log = txLog;
        return info;
    }

    protected void releaseTxInfo(TxInfo list) {
        if (this.listPool.size() < MAX_POOL_SIZE) {
            list.ackMessages.clear();
            list.addMessages.clear();
            this.listPool.add(list);
        }
    }

    protected void deleteMessages(LinkedList messages) throws JMSException {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            LogInfo info;
            LogInfo logInfo = info = (LogInfo)((MessageReference)it.next()).persistData;
            synchronized (logInfo) {
                --info.liveMessages;
            }
        }
    }

    protected void checkRollOver() throws JMSException {
        HashMap hashMap = this.queues;
        synchronized (hashMap) {
            int max = this.queues.size();
            max = max == 0 ? this.rollOverSize : (max *= this.rollOverSize);
            if (++this.messageCounter > max) {
                this.messageCounter = 0;
                this.rollOverLogs();
            }
        }
    }

    protected void rollOverLogs() throws JMSException {
        try {
            HashMap<String, LogInfo> logs = new HashMap<String, LogInfo>();
            ++this.numRollOvers;
            SpyTxLog newTxLog = new SpyTxLog(new File(this.dataDir, TRANS_FILE_NAME + this.numRollOvers));
            Iterator it = this.queues.values().iterator();
            while (it.hasNext()) {
                SpyDestination spyDest = (SpyDestination)it.next();
                logs.put(spyDest.toString(), this.newQueueInfo(spyDest, newTxLog));
            }
            SpyTxLog oldLog = this.currentTxLog;
            HashMap hashMap = this.messageLogs;
            synchronized (hashMap) {
                this.currentTxLog = newTxLog;
                this.messageLogs.put(newTxLog, logs);
            }
            this.checkCleanup();
        }
        catch (Exception e) {
            SpyJMSException jme = new SpyJMSException("Error rolling over logs to new files.");
            jme.setLinkedException(e);
            throw jme;
        }
    }

    protected LogInfo newQueueInfo(SpyDestination spyDest, SpyTxLog txLog) throws JMSException {
        try {
            String destName = spyDest.toString();
            SpyMessageLog log = new SpyMessageLog(this.messageCache, new File(this.dataDir, destName + ".dat" + this.numRollOvers));
            return new LogInfo(log, spyDest, txLog);
        }
        catch (Exception e) {
            SpyJMSException jme = new SpyJMSException("Error rolling over log to new file for dest: " + spyDest);
            jme.setLinkedException(e);
            throw jme;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkCleanup() throws JMSException {
        Iterator logs = null;
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logs = new ArrayList(this.messageLogs.keySet()).iterator();
        }
        while (logs.hasNext()) {
            this.checkCleanup((SpyTxLog)logs.next());
        }
    }

    protected void checkCleanup(SpyTxLog txLog) throws JMSException {
        HashMap logs;
        if (txLog == null || txLog == this.currentTxLog) {
            return;
        }
        HashMap hashMap = this.messageLogs;
        synchronized (hashMap) {
            logs = (HashMap)this.messageLogs.get(txLog);
        }
        HashMap hashMap2 = logs;
        synchronized (hashMap2) {
            Iterator it = logs.values().iterator();
            while (it.hasNext()) {
                LogInfo info;
                LogInfo logInfo = info = (LogInfo)it.next();
                synchronized (logInfo) {
                    if (info.liveMessages != 0) {
                        return;
                    }
                }
            }
        }
        if (!txLog.completed()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Cleaning up");
        }
        HashMap hashMap3 = this.messageLogs;
        synchronized (hashMap3) {
            logs = (HashMap)this.messageLogs.remove(txLog);
        }
        if (logs == null) {
            return;
        }
        txLog.close();
        txLog.delete();
        Iterator it = logs.values().iterator();
        while (it.hasNext()) {
            LogInfo info = (LogInfo)it.next();
            info.log.close();
            info.log.delete();
        }
    }

    protected void releaseTx(Tx tx) {
        if (this.txPool.size() < MAX_POOL_SIZE) {
            this.txPool.add(tx);
        }
    }

    public void closeQueue(JMSDestination jmsDest, SpyDestination dest) throws JMSException {
    }

    static class TxInfo {
        Tx txId;
        LinkedList addMessages = new LinkedList();
        LinkedList ackMessages = new LinkedList();
        SpyTxLog log;

        TxInfo(Tx txId, SpyTxLog log) {
            this.txId = txId;
            this.log = log;
        }
    }

    static class LogInfo {
        SpyMessageLog log;
        SpyDestination destination;
        int liveMessages = 0;
        SpyTxLog txLog;

        LogInfo(SpyMessageLog log, SpyDestination destination, SpyTxLog txLog) {
            this.log = log;
            this.destination = destination;
            this.txLog = txLog;
        }
    }
}

