/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.security;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SimplePrincipal;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SecurityMetadata {
    static Role DEFAULT_ROLE = new Role("guest", true, true, true);
    HashMap roles = new HashMap();
    HashSet read = new HashSet();
    HashSet write = new HashSet();
    HashSet create = new HashSet();
    Logger log = Logger.getLogger((Class)(class$org$jboss$mq$security$SecurityMetadata == null ? (class$org$jboss$mq$security$SecurityMetadata = SecurityMetadata.class$("org.jboss.mq.security.SecurityMetadata")) : class$org$jboss$mq$security$SecurityMetadata));
    static /* synthetic */ Class class$org$jboss$mq$security$SecurityMetadata;

    public SecurityMetadata() {
        this.addRole(DEFAULT_ROLE);
    }

    public SecurityMetadata(String conf) throws Exception {
        this.configure(conf);
    }

    public SecurityMetadata(Element conf) throws Exception {
        this.configure(conf);
    }

    public void configure(String conf) throws Exception {
        Element sec = null;
        if (conf != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser2 = factory.newDocumentBuilder();
            Document doc = parser2.parse(new InputSource(new StringReader(conf)));
            sec = doc.getDocumentElement();
        }
        this.configure(sec);
    }

    public void configure(Element sec) throws Exception {
        if (sec == null) {
            this.addRole(DEFAULT_ROLE);
        } else {
            if (!sec.getTagName().equals("security")) {
                throw new SAXException("Configuration document not valid: root element must be security, not " + sec.getTagName());
            }
            NodeList list = sec.getElementsByTagName("role");
            int l = list.getLength();
            int i = 0;
            while (i < l) {
                Element role = (Element)list.item(i);
                Attr na = role.getAttributeNode("name");
                if (na == null) {
                    throw new SAXException("There must exist a name attribute of role");
                }
                String n = na.getValue();
                boolean r = role.getAttributeNode("read") != null ? Boolean.valueOf(role.getAttributeNode("read").getValue()) : false;
                boolean w = role.getAttributeNode("write") != null ? Boolean.valueOf(role.getAttributeNode("write").getValue()) : false;
                boolean c = role.getAttributeNode("create") != null ? Boolean.valueOf(role.getAttributeNode("create").getValue()) : false;
                this.addRole(n, r, w, c);
                ++i;
            }
        }
    }

    public void addRole(String name, boolean read, boolean write, boolean create) {
        Role r = new Role(name, read, write, create);
        this.addRole(r);
    }

    public void addRole(Role r) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Adding role: " + r.toString()));
        }
        this.roles.put(r.name, r);
        SimplePrincipal p = new SimplePrincipal(r.name);
        if (r.read) {
            this.read.add(p);
        }
        if (r.write) {
            this.write.add(p);
        }
        if (r.create) {
            this.create.add(p);
        }
    }

    public Set getReadPrincipals() {
        return this.read;
    }

    public Set getWritePrincipals() {
        return this.write;
    }

    public Set getCreatePrincipals() {
        return this.create;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Role {
        String name;
        boolean read = false;
        boolean write = false;
        boolean create = false;

        public Role(String name, boolean read, boolean write, boolean create) {
            this.name = name;
            this.read = read;
            this.write = write;
            this.create = create;
        }

        public String toString() {
            return "Role {name=" + this.name + ";read=" + this.read + ";write=" + this.write + ";create=" + this.create + "}";
        }
    }
}

