/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.server.MessageCache;

public class MessageReference
implements Comparable {
    Logger log = Logger.getLogger((Class)(class$org$jboss$mq$server$MessageReference == null ? (class$org$jboss$mq$server$MessageReference = MessageReference.class$("org.jboss.mq.server.MessageReference")) : class$org$jboss$mq$server$MessageReference));
    public long referenceId;
    public MessageCache messageCache;
    public SpyMessage hardReference;
    public MessageSoftReference softReference;
    public boolean isStored;
    public byte jmsPriority;
    public long messageId;
    public transient Object persistData = null;
    static /* synthetic */ Class class$org$jboss$mq$server$MessageReference;

    MessageReference() {
    }

    void init(MessageCache messageCache, long referenceId, SpyMessage message) {
        this.messageCache = messageCache;
        this.hardReference = message;
        this.referenceId = referenceId;
        this.jmsPriority = (byte)message.getJMSPriority();
        this.messageId = message.header.messageId;
        this.isStored = false;
    }

    void reset() {
        this.messageCache = null;
        this.hardReference = null;
        this.softReference = null;
        this.persistData = null;
    }

    public SpyMessage getMessage() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"getMessage lock aquire");
        }
        MessageCache messageCache = this.messageCache;
        synchronized (messageCache) {
            if (this.hardReference == null) {
                this.makeHard();
                this.messageCache.messageReferenceUsedEvent(this, false);
            } else {
                ++this.messageCache.cacheHits;
                this.messageCache.messageReferenceUsedEvent(this, true);
            }
            if (trace) {
                this.log.trace((Object)"getMessage lock released");
            }
            SpyMessage spyMessage = this.hardReference;
            return spyMessage;
        }
    }

    public SpyMessage.Header getHeaders() throws JMSException {
        return this.getMessage().header;
    }

    void clear() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"clear lock aquire");
        }
        MessageCache messageCache = this.messageCache;
        synchronized (messageCache) {
            if (this.isStored) {
                this.messageCache.removeFromStorage(this);
                this.isStored = false;
            }
            if (trace) {
                this.log.trace((Object)"clear lock relased");
            }
        }
    }

    public void invalidate() throws JMSException {
        this.clear();
    }

    void makeSoft() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"makeSoft lock aquire");
        }
        MessageCache messageCache = this.messageCache;
        synchronized (messageCache) {
            if (this.softReference != null) {
                return;
            }
            if (!this.isStored) {
                this.messageCache.saveToStorage(this, this.hardReference);
                this.isStored = true;
            }
            this.softReference = new MessageSoftReference(this, this.hardReference, this.messageCache.referenceQueue);
            this.hardReference = null;
            ++this.messageCache.softRefCacheSize;
            if (trace) {
                this.log.trace((Object)"makeSoft lock released");
            }
        }
    }

    public void setStored(Object persistData) throws JMSException {
        this.persistData = persistData;
        this.isStored = persistData != null;
    }

    void makeHard() throws JMSException {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)"makeHard lock aquire");
        }
        MessageCache messageCache = this.messageCache;
        synchronized (messageCache) {
            if (this.hardReference != null) {
                return;
            }
            this.hardReference = (SpyMessage)this.softReference.get();
            if (this.hardReference == null) {
                this.hardReference = this.messageCache.loadFromStorage(this);
                ++this.messageCache.cacheMisses;
            } else {
                ++this.messageCache.cacheHits;
                --this.messageCache.softRefCacheSize;
            }
            this.softReference = null;
            if (trace) {
                this.log.trace((Object)"makeHard lock released");
            }
        }
    }

    public boolean equals(Object o) {
        try {
            return this.referenceId == ((MessageReference)o).referenceId;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int compareTo(Object o) {
        MessageReference sm = (MessageReference)o;
        if (this.jmsPriority > sm.jmsPriority) {
            return -1;
        }
        if (this.jmsPriority < sm.jmsPriority) {
            return 1;
        }
        return (int)(this.messageId - sm.messageId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MessageSoftReference
    extends SoftReference {
        MessageReference parent;

        public MessageSoftReference(MessageReference parent, Object message, ReferenceQueue rq) {
            super(message, rq);
            this.parent = parent;
        }
    }
}

