/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.sm.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.JMSTopic;
import org.jboss.mq.sm.StateManager;
import org.jboss.mq.sm.file.OldStateManagerMBean;
import org.jboss.mq.xml.XElement;
import org.jboss.mq.xml.XElementException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigLocator;

public class OldStateManager
extends ServiceMBeanSupport
implements StateManager,
OldStateManagerMBean {
    XElement stateConfig;
    private final Set loggedOnClientIds = new HashSet();
    private String stateFile = "conf/default/jbossmq-state.xml";
    private URL systemConfigURL;

    protected void createService() throws Exception {
        this.systemConfigURL = ServerConfigLocator.locate().getServerConfigURL();
    }

    public void setStateFile(String newStateFile) {
        this.stateFile = newStateFile.trim();
    }

    public StateManager getInstance() {
        return this;
    }

    public void setDurableSubscription(JMSDestinationManager server, DurableSubscriptionID sub, SpyTopic topic) throws JMSException {
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            this.log.debug((Object)("Checking durable subscription: " + sub + ", on topic: " + topic));
        }
        try {
            Enumeration enumeration = this.stateConfig.getElementsNamed("User");
            while (enumeration.hasMoreElements()) {
                XElement user = (XElement)enumeration.nextElement();
                if (!user.containsField("Id") || !user.getField("Id").equals(sub.getClientID())) continue;
                if (debug) {
                    this.log.debug((Object)"Found a matching ClientID configuration section.");
                }
                XElement subscription = null;
                Enumeration enum2 = user.getElementsNamed("DurableSubscription");
                while (enum2.hasMoreElements()) {
                    XElement t = (XElement)enum2.nextElement();
                    if (!t.getField("Name").equals(sub.getSubscriptionName())) continue;
                    subscription = t;
                    break;
                }
                if (subscription == null) {
                    if (debug) {
                        this.log.debug((Object)"The subscription was not previously registered.");
                    }
                    if (topic == null) {
                        return;
                    }
                    JMSTopic dest = (JMSTopic)server.getJMSDestination(topic);
                    dest.createDurableSubscription(sub);
                    subscription = new XElement("DurableSubscription");
                    subscription.addField("Name", sub.getSubscriptionName());
                    subscription.addField("TopicName", topic.getName());
                    user.addElement(subscription);
                    this.saveConfig();
                } else {
                    SpyTopic prevTopic;
                    if (debug) {
                        this.log.debug((Object)"The subscription was previously registered.");
                    }
                    if (topic == null) {
                        prevTopic = new SpyTopic(subscription.getField("TopicName"));
                        JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                        dest.destroyDurableSubscription(sub);
                        subscription.removeFromParent();
                        this.saveConfig();
                    } else if (!subscription.getField("TopicName").equals(topic.getName())) {
                        if (debug) {
                            this.log.debug((Object)"But the topic was different, changing the subscription.");
                        }
                        prevTopic = new SpyTopic(subscription.getField("TopicName"));
                        JMSTopic dest = (JMSTopic)server.getJMSDestination(prevTopic);
                        dest.destroyDurableSubscription(sub);
                        dest = (JMSTopic)server.getJMSDestination(topic);
                        dest.createDurableSubscription(sub);
                        subscription.setField("TopicName", topic.getName());
                        this.saveConfig();
                    }
                }
                return;
            }
            throw new JMSException("ClientID '" + sub.getClientID() + "' cannot create durable subscriptions.");
        }
        catch (IOException e) {
            SpyJMSException newE = new SpyJMSException("Could not setup the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not setup the durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    public SpyTopic getDurableTopic(DurableSubscriptionID sub) throws JMSException {
        try {
            XElement subscription = this.getSubscription(sub);
            if (subscription == null) {
                throw new JMSException("No durable subscription found for subscription: " + sub.getSubscriptionName());
            }
            return new SpyTopic(subscription.getField("TopicName"));
        }
        catch (XElementException e) {
            SpyJMSException newE = new SpyJMSException("Could not find durable subscription");
            newE.setLinkedException(e);
            throw newE;
        }
    }

    private XElement getSubscription(DurableSubscriptionID sub) throws JMSException, XElementException {
        boolean debug = this.log.isDebugEnabled();
        XElement subscription = null;
        Enumeration enumeration = this.stateConfig.getElementsNamed("User");
        while (enumeration.hasMoreElements()) {
            XElement user = (XElement)enumeration.nextElement();
            if (!user.containsField("Id") || !user.getField("Id").equals(sub.getClientID())) continue;
            if (debug) {
                this.log.debug((Object)"Found a matching ClientID configuration section.");
            }
            Enumeration enum2 = user.getElementsNamed("DurableSubscription");
            while (enum2.hasMoreElements()) {
                XElement t = (XElement)enum2.nextElement();
                if (!t.getField("Name").equals(sub.getSubscriptionName())) continue;
                subscription = t;
                return subscription;
            }
        }
        return subscription;
    }

    public String getStateFile() {
        return this.stateFile;
    }

    public String checkUser(String login, String passwd) throws JMSException {
        try {
            XElement xElement = this.stateConfig;
            synchronized (xElement) {
                Enumeration enumeration = this.stateConfig.getElementsNamed("User");
                while (enumeration.hasMoreElements()) {
                    Object object;
                    XElement element = (XElement)enumeration.nextElement();
                    String name = element.getField("Name");
                    if (!name.equals(login)) continue;
                    String pw = element.getField("Password");
                    if (!passwd.equals(pw)) {
                        throw new JMSException("Bad password");
                    }
                    String clientId = null;
                    if (element.containsField("Id")) {
                        clientId = element.getField("Id");
                    }
                    if (clientId != null) {
                        object = this.loggedOnClientIds;
                        synchronized (object) {
                            if (this.loggedOnClientIds.contains(clientId)) {
                                throw new JMSSecurityException("The login id has an assigned client id. That client id is already connected to the server!");
                            }
                            this.loggedOnClientIds.add(clientId);
                        }
                    }
                    object = clientId;
                    return object;
                }
                throw new JMSSecurityException("This user does not exist");
            }
        }
        catch (XElementException e) {
            this.log.error((Object)e);
            throw new JMSException("Invalid server user configuration.");
        }
    }

    public void addLoggedOnClientId(String ID) throws JMSException {
        Set set = this.loggedOnClientIds;
        synchronized (set) {
            if (this.loggedOnClientIds.contains(ID)) {
                throw new InvalidClientIDException("This loggedOnClientIds is already registered !");
            }
        }
        XElement xElement = this.stateConfig;
        synchronized (xElement) {
            Enumeration enumeration = this.stateConfig.getElementsNamed("User");
            while (enumeration.hasMoreElements()) {
                XElement element = (XElement)enumeration.nextElement();
                try {
                    if (!element.containsField("Id") || !element.getField("Id").equals(ID)) continue;
                    throw new InvalidClientIDException("This loggedOnClientIds is password protected !");
                }
                catch (XElementException ignore) {
                    // empty catch block
                }
            }
        }
        Set set2 = this.loggedOnClientIds;
        synchronized (set2) {
            this.loggedOnClientIds.add(ID);
        }
    }

    public void removeLoggedOnClientId(String ID) {
        Set set = this.loggedOnClientIds;
        synchronized (set) {
            this.loggedOnClientIds.remove(ID);
        }
    }

    public void startService() throws Exception {
        this.loadConfig();
    }

    public Collection getDurableSubscriptionIdsForTopic(SpyTopic topic) throws JMSException {
        ArrayList<DurableSubscriptionID> durableSubs = new ArrayList<DurableSubscriptionID>();
        try {
            Enumeration enumeration = this.stateConfig.getElementsNamed("User/DurableSubscription");
            while (enumeration.hasMoreElements()) {
                XElement element = (XElement)enumeration.nextElement();
                String clientId = element.getField("../Id");
                String name = element.getField("Name");
                String topicName = element.getField("TopicName");
                if (!topic.getName().equals(topicName)) continue;
                durableSubs.add(new DurableSubscriptionID(clientId, name, null));
            }
        }
        catch (XElementException e) {
            JMSException jmse = new JMSException("Error in statemanager xml");
            jmse.setLinkedException((Exception)e);
            throw jmse;
        }
        return durableSubs;
    }

    public void loadConfig() throws IOException, XElementException {
        URL configURL = new URL(this.systemConfigURL, this.stateFile);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading config from: " + configURL));
        }
        BufferedInputStream in = new BufferedInputStream(configURL.openStream());
        try {
            this.stateConfig = XElement.createFrom(in);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    public void saveConfig() throws IOException {
        URL configURL = new URL(this.systemConfigURL, this.stateFile);
        if (configURL.getProtocol().equals("file")) {
            File file = new File(configURL.getFile());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Saving config to: " + file));
            }
            PrintStream stream = new PrintStream(new FileOutputStream(file));
            try {
                stream.print(this.stateConfig.toXML(true));
                Object var5_4 = null;
                stream.close();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                stream.close();
                throw throwable;
            }
        } else {
            this.log.error((Object)("Can not save configuration to non-file URL: " + configURL));
        }
    }

    public String displayStateConfig() throws Exception {
        return this.stateConfig.toString();
    }
}

