/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.iiop;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.jboss.ejb.plugins.iiop.CDRStreamReader;
import org.jboss.ejb.plugins.iiop.CDRStreamWriter;
import org.jboss.ejb.plugins.iiop.RmiIdlUtil;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class CDRStream {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$java$lang$Object;

    public static String abbrevFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return "Z";
        }
        if (clz == Byte.TYPE) {
            return "B";
        }
        if (clz == Character.TYPE) {
            return "C";
        }
        if (clz == Double.TYPE) {
            return "D";
        }
        if (clz == Float.TYPE) {
            return "F";
        }
        if (clz == Integer.TYPE) {
            return "I";
        }
        if (clz == Long.TYPE) {
            return "J";
        }
        if (clz == Short.TYPE) {
            return "S";
        }
        if (clz == Void.TYPE) {
            return "V";
        }
        if (clz == (class$java$lang$String == null ? (class$java$lang$String = CDRStream.class$("java.lang.String")) : class$java$lang$String)) {
            return "G";
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return "R" + clz.getName();
        }
        if (CDRStream.isAbstractInterface(clz)) {
            return "A";
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz)) {
            if (clz == (class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable)) {
                return "E";
            }
            return "L" + clz.getName();
        }
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = CDRStream.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
            return "X";
        }
        if (clz == (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object)) {
            return "M";
        }
        if (clz == (class$java$lang$Object == null ? (class$java$lang$Object = CDRStream.class$("java.lang.Object")) : class$java$lang$Object)) {
            return "O";
        }
        return "L" + clz.getName();
    }

    public static CDRStreamReader readerFor(String s, ClassLoader cl) {
        switch (s.charAt(0)) {
            case 'A': {
                return AbstractInterfaceReader.instance;
            }
            case 'B': {
                return BooleanReader.instance;
            }
            case 'C': {
                return CharReader.instance;
            }
            case 'D': {
                return DoubleReader.instance;
            }
            case 'E': {
                return SerializableReader.instance;
            }
            case 'F': {
                return FloatReader.instance;
            }
            case 'G': {
                return StringReader.instance;
            }
            case 'I': {
                return IntReader.instance;
            }
            case 'J': {
                return LongReader.instance;
            }
            case 'L': {
                try {
                    return new ValuetypeReader(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
                }
            }
            case 'M': {
                return CorbaObjectReader.instance;
            }
            case 'O': {
                return ObjectReader.instance;
            }
            case 'R': {
                try {
                    return new RemoteReader(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
                }
            }
            case 'S': {
                return ShortReader.instance;
            }
            case 'V': {
                return null;
            }
            case 'X': {
                return ExternalizableReader.instance;
            }
            case 'Z': {
                return BooleanReader.instance;
            }
        }
        return null;
    }

    public static CDRStreamWriter writerFor(String s, ClassLoader cl) {
        switch (s.charAt(0)) {
            case 'A': {
                return AbstractInterfaceWriter.instance;
            }
            case 'B': {
                return BooleanWriter.instance;
            }
            case 'C': {
                return CharWriter.instance;
            }
            case 'D': {
                return DoubleWriter.instance;
            }
            case 'E': {
                return SerializableWriter.instance;
            }
            case 'F': {
                return FloatWriter.instance;
            }
            case 'G': {
                return StringWriter.instance;
            }
            case 'I': {
                return IntWriter.instance;
            }
            case 'J': {
                return LongWriter.instance;
            }
            case 'L': {
                try {
                    return new ValuetypeWriter(cl.loadClass(s.substring(1)));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
                }
            }
            case 'M': {
                return CorbaObjectWriter.instance;
            }
            case 'O': {
                return ObjectWriter.instance;
            }
            case 'R': {
                return RemoteWriter.instance;
            }
            case 'S': {
                return ShortWriter.instance;
            }
            case 'V': {
                return null;
            }
            case 'X': {
                return ExternalizableWriter.instance;
            }
            case 'Z': {
                return BooleanWriter.instance;
            }
        }
        return null;
    }

    public static CDRStreamReader readerFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return BooleanReader.instance;
        }
        if (clz == Byte.TYPE) {
            return ByteReader.instance;
        }
        if (clz == Character.TYPE) {
            return CharReader.instance;
        }
        if (clz == Double.TYPE) {
            return DoubleReader.instance;
        }
        if (clz == Float.TYPE) {
            return FloatReader.instance;
        }
        if (clz == Integer.TYPE) {
            return IntReader.instance;
        }
        if (clz == Long.TYPE) {
            return LongReader.instance;
        }
        if (clz == Short.TYPE) {
            return ShortReader.instance;
        }
        if (clz == Void.TYPE) {
            return null;
        }
        if (clz == (class$java$lang$String == null ? (class$java$lang$String = CDRStream.class$("java.lang.String")) : class$java$lang$String)) {
            return StringReader.instance;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return new RemoteReader(clz);
        }
        if (CDRStream.isAbstractInterface(clz)) {
            return AbstractInterfaceReader.instance;
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz)) {
            if (clz == (class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable)) {
                return SerializableReader.instance;
            }
            return new ValuetypeReader(clz);
        }
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = CDRStream.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
            return ExternalizableReader.instance;
        }
        if (clz == (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object)) {
            return CorbaObjectReader.instance;
        }
        if (clz == (class$java$lang$Object == null ? (class$java$lang$Object = CDRStream.class$("java.lang.Object")) : class$java$lang$Object)) {
            return ObjectReader.instance;
        }
        return new ValuetypeReader(clz);
    }

    public static CDRStreamWriter writerFor(Class clz) {
        if (clz == Boolean.TYPE) {
            return BooleanWriter.instance;
        }
        if (clz == Byte.TYPE) {
            return ByteWriter.instance;
        }
        if (clz == Character.TYPE) {
            return CharWriter.instance;
        }
        if (clz == Double.TYPE) {
            return DoubleWriter.instance;
        }
        if (clz == Float.TYPE) {
            return FloatWriter.instance;
        }
        if (clz == Integer.TYPE) {
            return IntWriter.instance;
        }
        if (clz == Long.TYPE) {
            return LongWriter.instance;
        }
        if (clz == Short.TYPE) {
            return ShortWriter.instance;
        }
        if (clz == (class$java$lang$String == null ? (class$java$lang$String = CDRStream.class$("java.lang.String")) : class$java$lang$String)) {
            return StringWriter.instance;
        }
        if (clz == Void.TYPE) {
            return null;
        }
        if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
            return RemoteWriter.instance;
        }
        if (CDRStream.isAbstractInterface(clz)) {
            return AbstractInterfaceWriter.instance;
        }
        if ((class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(clz)) {
            if (clz == (class$java$io$Serializable == null ? (class$java$io$Serializable = CDRStream.class$("java.io.Serializable")) : class$java$io$Serializable)) {
                return SerializableWriter.instance;
            }
            return new ValuetypeWriter(clz);
        }
        if ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = CDRStream.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(clz)) {
            return ExternalizableWriter.instance;
        }
        if (clz == (class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object)) {
            return CorbaObjectWriter.instance;
        }
        if (clz == (class$java$lang$Object == null ? (class$java$lang$Object = CDRStream.class$("java.lang.Object")) : class$java$lang$Object)) {
            return ObjectWriter.instance;
        }
        return new ValuetypeWriter(clz);
    }

    private static boolean isAbstractInterface(Class clz) {
        if (!clz.isInterface()) {
            return false;
        }
        Method[] methods = clz.getMethods();
        int n = methods.length;
        int i = 0;
        while (i < n) {
            if (!RmiIdlUtil.throwsRemoteException(methods[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ValuetypeWriter
    implements CDRStreamWriter {
        private Class clz;

        ValuetypeWriter(Class clz) {
            this.clz = clz;
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_value((Serializable)obj, this.clz);
        }
    }

    private static final class AbstractInterfaceWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new AbstractInterfaceWriter();

        private AbstractInterfaceWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_abstract_interface(obj);
        }
    }

    private static final class CorbaObjectWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new CorbaObjectWriter();

        private CorbaObjectWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_Object((Object)out);
        }
    }

    private static final class ExternalizableWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ExternalizableWriter();

        private ExternalizableWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)((Externalizable)obj));
        }
    }

    private static final class SerializableWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new SerializableWriter();

        private SerializableWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)((Serializable)obj));
        }
    }

    private static final class ObjectWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ObjectWriter();

        private ObjectWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)out, (java.lang.Object)obj);
        }
    }

    private static final class RemoteWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new RemoteWriter();

        private RemoteWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_Object((Object)obj);
        }
    }

    private static final class StringWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new StringWriter();
        static /* synthetic */ Class class$java$lang$String;

        private StringWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_value((Serializable)((java.lang.Object)((String)obj)), class$java$lang$String == null ? (class$java$lang$String = StringWriter.class$("java.lang.String")) : class$java$lang$String);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class ShortWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ShortWriter();

        private ShortWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_short(((Short)obj).shortValue());
        }
    }

    private static final class LongWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new LongWriter();

        private LongWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_longlong(((Long)obj).longValue());
        }
    }

    private static final class IntWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new IntWriter();

        private IntWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_long(((Integer)obj).intValue());
        }
    }

    private static final class FloatWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new FloatWriter();

        private FloatWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_float(((Float)obj).floatValue());
        }
    }

    private static final class DoubleWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new DoubleWriter();

        private DoubleWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_double(((Double)obj).doubleValue());
        }
    }

    private static final class CharWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new CharWriter();

        private CharWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_wchar(((Character)obj).charValue());
        }
    }

    private static final class ByteWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new ByteWriter();

        private ByteWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_octet(((Byte)obj).byteValue());
        }
    }

    private static final class BooleanWriter
    implements CDRStreamWriter {
        static final CDRStreamWriter instance = new BooleanWriter();

        private BooleanWriter() {
        }

        public void write(OutputStream out, java.lang.Object obj) {
            out.write_boolean(((Boolean)obj).booleanValue());
        }
    }

    private static final class ValuetypeReader
    implements CDRStreamReader {
        private Class clz;

        ValuetypeReader(Class clz) {
            this.clz = clz;
        }

        public java.lang.Object read(InputStream in) {
            return in.read_value(this.clz);
        }
    }

    private static final class AbstractInterfaceReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new AbstractInterfaceReader();

        private AbstractInterfaceReader() {
        }

        public java.lang.Object read(InputStream in) {
            return in.read_abstract_interface();
        }
    }

    private static final class CorbaObjectReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new CorbaObjectReader();

        private CorbaObjectReader() {
        }

        public java.lang.Object read(InputStream in) {
            return in.read_Object();
        }
    }

    private static final class ExternalizableReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ExternalizableReader();

        private ExternalizableReader() {
        }

        public java.lang.Object read(InputStream in) {
            return (Externalizable)Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class SerializableReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new SerializableReader();

        private SerializableReader() {
        }

        public java.lang.Object read(InputStream in) {
            return (Serializable)Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class ObjectReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ObjectReader();

        private ObjectReader() {
        }

        public java.lang.Object read(InputStream in) {
            return Util.readAny((org.omg.CORBA.portable.InputStream)in);
        }
    }

    private static final class RemoteReader
    implements CDRStreamReader {
        private Class clz;

        RemoteReader(Class clz) {
            this.clz = clz;
        }

        public java.lang.Object read(InputStream in) {
            return PortableRemoteObject.narrow((java.lang.Object)in.read_Object(), (Class)this.clz);
        }
    }

    private static final class StringReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new StringReader();
        static /* synthetic */ Class class$java$lang$String;

        private StringReader() {
        }

        public java.lang.Object read(InputStream in) {
            return in.read_value(class$java$lang$String == null ? (class$java$lang$String = StringReader.class$("java.lang.String")) : class$java$lang$String);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class ShortReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ShortReader();

        private ShortReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Short(in.read_short());
        }
    }

    private static final class LongReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new LongReader();

        private LongReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Long(in.read_longlong());
        }
    }

    private static final class IntReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new IntReader();

        private IntReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Integer(in.read_long());
        }
    }

    private static final class FloatReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new FloatReader();

        private FloatReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Float(in.read_float());
        }
    }

    private static final class DoubleReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new DoubleReader();

        private DoubleReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Double(in.read_double());
        }
    }

    private static final class CharReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new CharReader();

        private CharReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Character(in.read_wchar());
        }
    }

    private static final class ByteReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new ByteReader();

        private ByteReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Byte(in.read_octet());
        }
    }

    private static final class BooleanReader
    implements CDRStreamReader {
        static final CDRStreamReader instance = new BooleanReader();

        private BooleanReader() {
        }

        public java.lang.Object read(InputStream in) {
            return new Boolean(in.read_boolean());
        }
    }
}

