/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.iiop.client;

import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.ejb.plugins.iiop.CDRStream;
import org.jboss.ejb.plugins.iiop.CDRStreamReader;
import org.jboss.ejb.plugins.iiop.CDRStreamWriter;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class StubStrategy {
    private CDRStreamWriter[] paramWriters;
    private List exceptionList;
    private Map exceptionMap;
    private CDRStreamReader retvalReader;

    public static StubStrategy forMethod(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl) {
        return new StubStrategy(paramTypes, excepIds, excepTypes, retvalType, cl);
    }

    private StubStrategy(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl) {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        int len = paramTypes.length;
        this.paramWriters = new CDRStreamWriter[len];
        int i = 0;
        while (i < len) {
            this.paramWriters[i] = CDRStream.writerFor(paramTypes[i], cl);
            ++i;
        }
        this.exceptionList = new ArrayList();
        this.exceptionMap = new HashMap();
        len = excepIds.length;
        int i2 = 0;
        while (i2 < len) {
            try {
                Class<?> clz = cl.loadClass(excepTypes[i2]);
                this.exceptionList.add(clz);
                this.exceptionMap.put(excepIds[i2], clz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Error loading class " + excepTypes[i2] + ": " + e);
            }
            ++i2;
        }
        this.retvalReader = CDRStream.readerFor(retvalType, cl);
    }

    public void writeParams(OutputStream out, Object[] params) {
        int len = params.length;
        if (len != this.paramWriters.length) {
            throw new RuntimeException("Cannot marshal parameters: unexpected number of parameters");
        }
        int i = 0;
        while (i < len) {
            this.paramWriters[i].write(out, params[i]);
            ++i;
        }
    }

    public boolean isNonVoid() {
        return this.retvalReader != null;
    }

    public Object readRetval(InputStream in) {
        return this.retvalReader.read(in);
    }

    public Exception readException(InputStream in) {
        String repositoryId = in.read_string();
        Class exceptionClass = (Class)this.exceptionMap.get(repositoryId);
        if (exceptionClass == null) {
            return new UnexpectedException(repositoryId);
        }
        return (Exception)in.read_value(exceptionClass);
    }

    public boolean isDeclaredException(Throwable t) {
        Iterator iterator = this.exceptionList.iterator();
        while (iterator.hasNext()) {
            if (!((Class)iterator.next()).isInstance(t)) continue;
            return true;
        }
        return false;
    }
}

