/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ClassAnalysis;
import org.jboss.iiop.rmi.ConstantAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.ParameterAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.Util;
import org.jboss.logging.Logger;

public abstract class ContainerAnalysis
extends ClassAnalysis {
    protected final byte M_OVERLOADED = 1;
    protected final byte M_READ = (byte)2;
    protected final byte M_WRITE = (byte)4;
    protected final byte M_READONLY = (byte)8;
    protected final byte M_INHERITED = (byte)16;
    protected final byte M_WRITEOBJECT = (byte)32;
    protected final byte F_CONSTANT = 1;
    protected final byte F_SPFFIELD = (byte)2;
    protected Method[] methods;
    protected byte[] m_flags;
    protected int[] mutators;
    protected Field[] fields;
    protected byte[] f_flags;
    protected long classHashCode = 0L;
    protected String repositoryId;
    protected String memberPrefix;
    protected String memberPostfix;
    protected InterfaceAnalysis[] interfaces;
    protected AttributeAnalysis[] attributes;
    protected ConstantAnalysis[] constants;
    protected OperationAnalysis[] operations;
    private static final Logger logger = Logger.getLogger((Class)(class$org$jboss$iiop$rmi$ContainerAnalysis == null ? (class$org$jboss$iiop$rmi$ContainerAnalysis = ContainerAnalysis.class$("org.jboss.iiop.rmi.ContainerAnalysis")) : class$org$jboss$iiop$rmi$ContainerAnalysis));
    private String idlModuleName = null;
    static /* synthetic */ Class class$org$jboss$iiop$rmi$ContainerAnalysis;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$Externalizable;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$lang$String;

    protected ContainerAnalysis(Class cls) {
        super(cls);
        if (cls == (class$java$lang$Object == null ? (class$java$lang$Object = ContainerAnalysis.class$("java.lang.Object")) : class$java$lang$Object) || cls == (class$java$io$Serializable == null ? (class$java$io$Serializable = ContainerAnalysis.class$("java.io.Serializable")) : class$java$io$Serializable) || cls == (class$java$io$Externalizable == null ? (class$java$io$Externalizable = ContainerAnalysis.class$("java.io.Externalizable")) : class$java$io$Externalizable)) {
            throw new IllegalArgumentException("Cannot analyze special class: " + cls.getName());
        }
        this.cls = cls;
    }

    protected void doAnalyze() throws RMIIIOPViolationException {
        this.analyzeInterfaces();
        this.analyzeMethods();
        this.analyzeFields();
        this.calculateClassHashCode();
        this.calculateRepositoryId();
        this.analyzeAttributes();
        this.analyzeConstants();
        this.analyzeOperations();
        this.fixupOverloadedOperationNames();
    }

    public InterfaceAnalysis[] getInterfaces() {
        logger.debug((Object)("Interface count: " + this.interfaces.length));
        return (InterfaceAnalysis[])this.interfaces.clone();
    }

    public AttributeAnalysis[] getAttributes() {
        logger.debug((Object)("Attribute count: " + this.attributes.length));
        return (AttributeAnalysis[])this.attributes.clone();
    }

    public ConstantAnalysis[] getConstants() {
        logger.debug((Object)("Constants count: " + this.constants.length));
        return (ConstantAnalysis[])this.constants.clone();
    }

    public OperationAnalysis[] getOperations() {
        return (OperationAnalysis[])this.operations.clone();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getMemberRepositoryId(String memberName) {
        return this.memberPrefix + this.escapeIRName(memberName) + this.memberPostfix;
    }

    public String getIDLModuleName() {
        if (this.idlModuleName == null) {
            String pkgName = this.cls.getPackage().getName();
            StringBuffer b = new StringBuffer();
            while (!"".equals(pkgName)) {
                int idx = pkgName.indexOf(46);
                String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
                b.append("::").append(Util.javaToIDLName(n));
                String string = pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
            }
            this.idlModuleName = b.toString();
        }
        return this.idlModuleName;
    }

    protected String toHexString(int i) {
        String s = Integer.toHexString(i).toUpperCase();
        if (s.length() < 8) {
            return "00000000".substring(0, 8 - s.length()) + s;
        }
        return s;
    }

    protected String toHexString(long l) {
        String s = Long.toHexString(l).toUpperCase();
        if (s.length() < 16) {
            return "0000000000000000".substring(0, 16 - s.length()) + s;
        }
        return s;
    }

    protected boolean isAccessor(Method m) {
        Class<?> returnType = m.getReturnType();
        if (!(m.getName().startsWith("get") || m.getName().startsWith("is") && returnType == Boolean.TYPE)) {
            return false;
        }
        if (returnType == Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return this.hasNonAppExceptions(m);
    }

    protected boolean isMutator(Method m) {
        if (!m.getName().startsWith("set")) {
            return false;
        }
        if (m.getReturnType() != Void.TYPE) {
            return false;
        }
        if (m.getParameterTypes().length != 1) {
            return false;
        }
        return this.hasNonAppExceptions(m);
    }

    protected boolean hasNonAppExceptions(Method m) {
        Class<?>[] ex = m.getExceptionTypes();
        int i = 0;
        while (i < ex.length) {
            if (!(class$java$rmi$RemoteException == null ? ContainerAnalysis.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(ex[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void analyzeFields() {
        this.fields = this.cls.getDeclaredFields();
        this.f_flags = new byte[this.fields.length];
        int i = 0;
        while (i < this.fields.length) {
            int mods = this.fields[i].getModifiers();
            if (Modifier.isFinal(mods) && Modifier.isStatic(mods) && Modifier.isPublic(mods)) {
                int n = i;
                this.f_flags[n] = (byte)(this.f_flags[n] | 1);
            }
            ++i;
        }
    }

    protected void analyzeInterfaces() throws RMIIIOPViolationException {
        Class<?>[] intfs = this.cls.getInterfaces();
        ArrayList<InterfaceAnalysis> a = new ArrayList<InterfaceAnalysis>();
        int i = 0;
        while (i < intfs.length) {
            if (!(this.cls.isInterface() && (class$java$rmi$Remote == null ? ContainerAnalysis.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(this.cls) ? intfs[i] == (class$java$rmi$Remote == null ? ContainerAnalysis.class$("java.rmi.Remote") : class$java$rmi$Remote) : intfs[i] == (class$java$io$Serializable == null ? ContainerAnalysis.class$("java.io.Serializable") : class$java$io$Serializable) || intfs[i] == (class$java$io$Externalizable == null ? ContainerAnalysis.class$("java.io.Externalizable") : class$java$io$Externalizable))) {
                a.add(InterfaceAnalysis.getInterfaceAnalysis(intfs[i]));
            }
            ++i;
        }
        this.interfaces = new InterfaceAnalysis[a.size()];
        this.interfaces = a.toArray(this.interfaces);
    }

    protected void analyzeMethods() {
        this.methods = this.cls.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = ContainerAnalysis.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.cls) ? this.cls.getMethods() : this.cls.getDeclaredMethods();
        this.m_flags = new byte[this.methods.length];
        this.mutators = new int[this.methods.length];
        int i = 0;
        while (i < this.methods.length) {
            this.mutators[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.methods.length) {
            int j;
            String attrName;
            logger.debug((Object)("analyzeMethods(): method[" + i2 + "].getName()=\"" + this.methods[i2].getName() + "\"."));
            if (this.isAccessor(this.methods[i2]) && (this.m_flags[i2] & 2) == 0) {
                attrName = this.attributeReadName(this.methods[i2].getName());
                Class<?> iReturn = this.methods[i2].getReturnType();
                j = i2 + 1;
                while (j < this.methods.length) {
                    Class<?>[] jParams;
                    if (this.isMutator(this.methods[j]) && (this.m_flags[j] & 4) == 0 && attrName.equals(this.attributeWriteName(this.methods[j].getName())) && (jParams = this.methods[j].getParameterTypes()).length == 1 && jParams[0] == iReturn) {
                        int n = i2;
                        this.m_flags[n] = (byte)(this.m_flags[n] | 2);
                        int n2 = j;
                        this.m_flags[n2] = (byte)(this.m_flags[n2] | 4);
                        this.mutators[i2] = j;
                        break;
                    }
                    ++j;
                }
            } else if (this.isMutator(this.methods[i2]) && (this.m_flags[i2] & 4) == 0) {
                attrName = this.attributeWriteName(this.methods[i2].getName());
                Class<?>[] iParams = this.methods[i2].getParameterTypes();
                j = i2 + 1;
                while (j < this.methods.length) {
                    if (this.isAccessor(this.methods[j]) && (this.m_flags[j] & 2) == 0 && attrName.equals(this.attributeReadName(this.methods[j].getName()))) {
                        Class<?> jReturn = this.methods[j].getReturnType();
                        if (iParams.length == 1 && iParams[0] == jReturn) {
                            int n = i2;
                            this.m_flags[n] = (byte)(this.m_flags[n] | 4);
                            int n3 = j;
                            this.m_flags[n3] = (byte)(this.m_flags[n3] | 2);
                            this.mutators[j] = i2;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.methods.length) {
            if ((this.m_flags[i3] & 6) == 0 && this.isAccessor(this.methods[i3])) {
                int n = i3;
                this.m_flags[n] = (byte)(this.m_flags[n] | 8);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.methods.length) {
            if ((this.m_flags[i4] & 0xE) == 0) {
                String iName = this.methods[i4].getName();
                int j = i4 + 1;
                while (j < this.methods.length) {
                    if (iName.equals(this.methods[j].getName())) {
                        int n = i4;
                        this.m_flags[n] = (byte)(this.m_flags[n] | 1);
                        int n4 = j;
                        this.m_flags[n4] = (byte)(this.m_flags[n4] | 1);
                    }
                    ++j;
                }
            }
            if (this.methods[i4].getDeclaringClass() != this.cls) {
                int n = i4;
                this.m_flags[n] = (byte)(this.m_flags[n] | 0x10);
            }
            ++i4;
        }
    }

    protected String attributeReadName(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            throw new IllegalArgumentException("Not an accessor: " + name);
        }
        return name;
    }

    protected String attributeWriteName(String name) {
        if (!name.startsWith("set")) {
            throw new IllegalArgumentException("Not an accessor: " + name);
        }
        name = name.substring(3);
        return name;
    }

    protected void analyzeConstants() throws RMIIIOPViolationException {
        ArrayList<ConstantAnalysis> a = new ArrayList<ConstantAnalysis>();
        int i = 0;
        while (i < this.fields.length) {
            logger.debug((Object)("f_flags[" + i + "]=" + this.f_flags[i]));
            if ((this.f_flags[i] & 1) != 0) {
                Class<?> type = this.fields[i].getType();
                if (!type.isPrimitive() && type != (class$java$lang$String == null ? ContainerAnalysis.class$("java.lang.String") : class$java$lang$String)) {
                    if (this.cls.isInterface()) {
                        throw new RMIIIOPViolationException("Field \"" + this.fields[i].getName() + "\" of interface \"" + this.cls.getName() + "\" is a constant, but not of one " + "of the primitive types, or String.", "1.2.3");
                    }
                } else {
                    Object value;
                    String name = this.fields[i].getName();
                    try {
                        value = this.fields[i].get(null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex.toString());
                    }
                    logger.debug((Object)("Constant[" + i + "] name= " + name));
                    logger.debug((Object)("Constant[" + i + "] type= " + type.getName()));
                    logger.debug((Object)("Constant[" + i + "] value= " + value));
                    a.add(new ConstantAnalysis(name, type, value));
                }
            }
            ++i;
        }
        logger.debug((Object)("Constants count: " + a.size()));
        this.constants = new ConstantAnalysis[a.size()];
        this.constants = a.toArray(this.constants);
    }

    protected void analyzeAttributes() throws RMIIIOPViolationException {
        ArrayList<AttributeAnalysis> a = new ArrayList<AttributeAnalysis>();
        int i = 0;
        while (i < this.methods.length) {
            logger.debug((Object)("m_flags[" + i + "]=" + this.m_flags[i]));
            if ((this.m_flags[i] & 0xA) != 0) {
                String name = this.attributeReadName(this.methods[i].getName());
                logger.debug((Object)("Attribute[" + i + "] name= " + name));
                if ((this.m_flags[i] & 8) != 0) {
                    a.add(new AttributeAnalysis(name, this.methods[i]));
                } else {
                    a.add(new AttributeAnalysis(name, this.methods[i], this.methods[this.mutators[i]]));
                }
            }
            ++i;
        }
        logger.debug((Object)("Attribute count: " + a.size()));
        this.attributes = new AttributeAnalysis[a.size()];
        this.attributes = a.toArray(this.attributes);
    }

    protected void analyzeOperations() throws RMIIIOPViolationException {
        this.operations = new OperationAnalysis[0];
    }

    protected void fixupOverloadedOperationNames() throws RMIIIOPViolationException {
        int i = 0;
        while (i < this.methods.length) {
            if ((this.m_flags[i] & 1) != 0) {
                OperationAnalysis oa = null;
                String javaName = this.methods[i].getName();
                int opIdx = 0;
                while (oa == null && opIdx < this.operations.length) {
                    if (this.operations[opIdx].getMethod().equals(this.methods[i])) {
                        oa = this.operations[opIdx];
                    }
                    ++opIdx;
                }
                if (oa != null) {
                    ParameterAnalysis[] parms = oa.getParameters();
                    StringBuffer b = new StringBuffer(oa.getIDLName());
                    if (parms.length == 0) {
                        b.append("__");
                    }
                    int j = 0;
                    while (j < parms.length) {
                        String s = parms[j].getTypeIDLName();
                        if (s.startsWith("::")) {
                            s = s.substring(2);
                        }
                        b.append('_');
                        while (!"".equals(s)) {
                            int idx = s.indexOf("::");
                            b.append('_');
                            if (idx == -1) {
                                b.append(s);
                                s = "";
                                continue;
                            }
                            b.append(s.substring(0, idx));
                            s = s.substring(idx + 2);
                        }
                        ++j;
                    }
                    oa.setIDLName(b.toString());
                }
            }
            ++i;
        }
    }

    protected void fixupCaseNames() throws RMIIIOPViolationException {
        ArrayList entries = this.getContainedEntries();
        boolean[] clash = new boolean[entries.size()];
        String[] upperNames = new String[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            AbstractAnalysis aa = (AbstractAnalysis)entries.get(i);
            clash[i] = false;
            upperNames[i] = aa.getIDLName().toUpperCase();
            int j = 0;
            while (j < i) {
                if (upperNames[i].equals(upperNames[j])) {
                    clash[i] = true;
                    clash[j] = true;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < entries.size()) {
            if (clash[i2]) {
                AbstractAnalysis aa = (AbstractAnalysis)entries.get(i2);
                boolean noUpper = true;
                String name = aa.getIDLName();
                StringBuffer b = new StringBuffer(name);
                b.append('_');
                int j = 0;
                while (j < name.length()) {
                    if (Character.isUpperCase(name.charAt(j))) {
                        if (noUpper) {
                            noUpper = false;
                        } else {
                            b.append('_');
                        }
                        b.append(j);
                    }
                    ++j;
                }
                aa.setIDLName(b.toString());
            }
            ++i2;
        }
    }

    protected abstract ArrayList getContainedEntries();

    protected void calculateClassHashCode() {
        this.classHashCode = this.cls.isInterface() ? 0L : (!(class$java$io$Serializable == null ? (class$java$io$Serializable = ContainerAnalysis.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.cls) ? 0L : ((class$java$io$Externalizable == null ? (class$java$io$Externalizable = ContainerAnalysis.class$("java.io.Externalizable")) : class$java$io$Externalizable).isAssignableFrom(this.cls) ? 1L : Util.getClassHashCode(this.cls)));
    }

    protected String escapeIRName(String name) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c < '\u0100') {
                b.append(c);
            } else {
                b.append("\\U").append(this.toHexString(c));
            }
            ++i;
        }
        return b.toString();
    }

    protected void calculateRepositoryId() {
        if (this.cls.isArray() || this.cls.isPrimitive()) {
            throw new IllegalArgumentException("Not a class or interface.");
        }
        StringBuffer b = new StringBuffer("RMI:");
        b.append(this.escapeIRName(this.cls.getName()));
        this.memberPrefix = b.toString() + ".";
        String hashStr = this.toHexString(this.classHashCode);
        b.append(':').append(hashStr);
        ObjectStreamClass osClass = ObjectStreamClass.lookup(this.cls);
        if (osClass != null) {
            long serialVersionUID = osClass.getSerialVersionUID();
            String SVUID = this.toHexString(serialVersionUID);
            if (this.classHashCode != serialVersionUID) {
                b.append(':').append(SVUID);
            }
            this.memberPostfix = ":" + hashStr + ":" + SVUID;
        } else {
            this.memberPostfix = ":" + hashStr;
        }
        this.repositoryId = b.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

