/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.lang.reflect.Method;
import java.util.HashMap;
import javax.ejb.EJBContext;
import org.jboss.security.SecurityProxy;

public abstract class AbstractSecurityProxy
implements SecurityProxy {
    private HashMap methodMap;
    private Method setContextMethod;
    private Method setBeanMethod;
    protected Object delegate;
    protected boolean strict = true;
    static /* synthetic */ Class class$javax$ejb$EJBContext;
    static /* synthetic */ Class class$java$lang$Object;

    AbstractSecurityProxy(Object delegate) {
        this.delegate = delegate;
        this.methodMap = new HashMap();
    }

    protected abstract void invokeHomeOnDelegate(Method var1, Object[] var2, Object var3) throws SecurityException;

    protected abstract void invokeOnDelegate(Method var1, Object[] var2, Object var3) throws SecurityException;

    public void init(Class beanHome, Class beanRemote, Object securityMgr) throws InstantiationException {
        Class[] parameterTypes;
        this.mapHomeMethods(beanHome);
        this.mapRemoteMethods(beanRemote);
        try {
            parameterTypes = new Class[]{class$javax$ejb$EJBContext == null ? (class$javax$ejb$EJBContext = AbstractSecurityProxy.class$("javax.ejb.EJBContext")) : class$javax$ejb$EJBContext};
            this.setContextMethod = this.delegate.getClass().getMethod("setEJBContext", parameterTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            parameterTypes = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AbstractSecurityProxy.class$("java.lang.Object")) : class$java$lang$Object};
            this.setBeanMethod = this.delegate.getClass().getMethod("setBean", parameterTypes);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setEJBContext(EJBContext ctx) {
        if (this.setContextMethod != null) {
            Object[] args = new Object[]{ctx};
            try {
                this.setContextMethod.invoke(this.delegate, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void invokeHome(Method m, Object[] args) throws SecurityException {
        Method delegateMethod = (Method)this.methodMap.get(m);
        if (delegateMethod != null) {
            this.invokeHomeOnDelegate(delegateMethod, args, this.delegate);
        }
    }

    public void invoke(Method m, Object[] args, Object bean) throws SecurityException {
        Method delegateMethod = (Method)this.methodMap.get(m);
        if (delegateMethod != null) {
            if (this.setBeanMethod != null) {
                Object[] bargs = new Object[]{bean};
                try {
                    this.setBeanMethod.invoke(this.delegate, bargs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SecurityException("Failed to set bean on proxy" + e.getMessage());
                }
            }
            this.invokeOnDelegate(delegateMethod, args, this.delegate);
        }
    }

    protected void mapHomeMethods(Class beanHome) {
        Class<?> delegateClass = this.delegate.getClass();
        Method[] methods = beanHome.getMethods();
        int m = 0;
        while (m < methods.length) {
            block3: {
                Method hm = methods[m];
                Class<?>[] parameterTypes = hm.getParameterTypes();
                String name = hm.getName();
                name = "ejb" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                try {
                    Method match = delegateClass.getMethod(name, parameterTypes);
                    this.methodMap.put(hm, match);
                }
                catch (NoSuchMethodException e) {
                    if (!this.strict) break block3;
                    throw new SecurityException("Missing home method in delegate, " + e);
                }
            }
            ++m;
        }
    }

    protected void mapRemoteMethods(Class beanRemote) {
        Class<?> delegateClass = this.delegate.getClass();
        Method[] methods = beanRemote.getMethods();
        int m = 0;
        while (m < methods.length) {
            block3: {
                Method rm = methods[m];
                Class<?>[] parameterTypes = rm.getParameterTypes();
                String name = rm.getName();
                try {
                    Method match = delegateClass.getMethod(name, parameterTypes);
                    this.methodMap.put(rm, match);
                }
                catch (NoSuchMethodException e) {
                    if (!this.strict) break block3;
                    throw new SecurityException("Missing method in delegate, " + e);
                }
            }
            ++m;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

