/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.TrustManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.security.SecurityDomain;
import org.jboss.security.plugins.JaasSecurityDomainMBean;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceMBean;

public class JaasSecurityDomain
extends JaasSecurityManager
implements SecurityDomain,
JaasSecurityDomainMBean {
    private int state;
    private KeyStore keyStore;
    private KeyManagerFactory keyMgr;
    private String keyStoreType = "JKS";
    private URL keyStoreURL;
    private char[] keyStorePassword;
    private ObjectName securityMgrServiceName;

    public JaasSecurityDomain() {
        this("other");
    }

    public JaasSecurityDomain(String securityDomain) {
        super(securityDomain);
    }

    public KeyStore getKeyStore() throws SecurityException {
        return this.keyStore;
    }

    public KeyManagerFactory getKeyManagerFactory() throws SecurityException {
        return this.keyMgr;
    }

    public KeyStore getTrustStore() throws SecurityException {
        return null;
    }

    public TrustManagerFactory getTrustManagerFactory() throws SecurityException {
        return null;
    }

    public void create() {
        this.log.info((Object)"Initialized");
    }

    public void start() throws Exception {
        if (this.getState() != 0) {
            return;
        }
        this.state = 2;
        this.log.info((Object)"Starting");
        if (this.keyStoreURL != null) {
            this.keyStore = KeyStore.getInstance(this.keyStoreType);
            InputStream is = this.keyStoreURL.openStream();
            this.keyStore.load(is, this.keyStorePassword);
            String algorithm = KeyManagerFactory.getDefaultAlgorithm();
            this.keyMgr = KeyManagerFactory.getInstance((String)algorithm);
            this.keyMgr.init(this.keyStore, this.keyStorePassword);
        }
        MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
        ObjectName jaasMgr = this.securityMgrServiceName;
        if (this.securityMgrServiceName == null) {
            jaasMgr = JaasSecurityManagerServiceMBean.OBJECT_NAME;
        }
        Object[] params = new Object[]{this.getSecurityDomain(), this};
        String[] signature = new String[]{"java.lang.String", "org.jboss.security.SecurityDomain"};
        server.invoke(jaasMgr, "registerSecurityDomain", params, signature);
        this.state = 3;
        this.log.info((Object)"Started");
    }

    public void stop() {
        this.state = 0;
    }

    public void destroy() {
    }

    public String getName() {
        return "JaasSecurityDomain(" + this.getSecurityDomain() + ")";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return ServiceMBean.states[this.state];
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public String getKeyStoreURL() {
        String url = null;
        if (this.keyStoreURL != null) {
            url = this.keyStoreURL.toExternalForm();
        }
        return url;
    }

    public void setKeyStoreURL(String storeURL) throws IOException {
        File tst;
        this.keyStoreURL = null;
        try {
            this.keyStoreURL = new URL(storeURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (this.keyStoreURL == null && (tst = new File(storeURL)).exists()) {
            this.keyStoreURL = tst.toURL();
        }
        if (this.keyStoreURL == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.keyStoreURL = loader.getResource(storeURL);
        }
        if (this.keyStoreURL == null) {
            String msg = "Failed to find url=" + storeURL + " as a URL, file or resource";
            throw new MalformedURLException(msg);
        }
        this.log.debug((Object)("Using KeyStore=" + this.keyStoreURL.toExternalForm()));
    }

    public void setKeyStorePass(String password) {
        this.keyStorePassword = password.toCharArray();
    }

    public void setSecurityManagerService(String objectName) throws MalformedObjectNameException {
        this.securityMgrServiceName = new ObjectName(objectName);
    }
}

