/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.naming.Util;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.srp.SRPRemoteServer;
import org.jboss.security.srp.SRPServerListener;
import org.jboss.security.srp.SRPServerProxy;
import org.jboss.security.srp.SRPServerSession;
import org.jboss.security.srp.SRPServiceMBean;
import org.jboss.security.srp.SRPVerifierStore;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.TimedCachePolicy;

public class SRPService
extends ServiceMBeanSupport
implements SRPServiceMBean,
SRPServerListener {
    private SRPRemoteServer server;
    private int serverPort = 10099;
    private SRPVerifierStore verifierStore;
    private String verifierSourceJndiName = "srp/DefaultVerifierSource";
    private String serverJndiName = "srp/SRPServerInterface";
    private String cacheJndiName = "srp/AuthenticationCache";
    private TimedCachePolicy cachePolicy;
    private int cacheTimeout = 1800;
    private int cacheResolution = 60;
    private RMIClientSocketFactory clientSocketFactory;
    private RMIServerSocketFactory serverSocketFactory;
    private String clientSocketFactoryName;
    private String serverSocketFactoryName;
    static /* synthetic */ Class class$org$jboss$security$srp$SRPServerInterface;

    public String getVerifierSourceJndiName() {
        return this.verifierSourceJndiName;
    }

    public void setVerifierSourceJndiName(String jndiName) {
        this.verifierSourceJndiName = jndiName;
    }

    public String getJndiName() {
        return this.serverJndiName;
    }

    public void setJndiName(String jndiName) {
        this.serverJndiName = jndiName;
    }

    public String getAuthenticationCacheJndiName() {
        return this.cacheJndiName;
    }

    public void setAuthenticationCacheJndiName(String jndiName) {
        this.cacheJndiName = jndiName;
    }

    public int getAuthenticationCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setAuthenticationCacheTimeout(int timeoutInSecs) {
        this.cacheTimeout = timeoutInSecs;
    }

    public int getAuthenticationCacheResolution() {
        return this.cacheResolution;
    }

    public void setAuthenticationCacheResolution(int resInSecs) {
        this.cacheResolution = resInSecs;
    }

    public String getClientSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.clientSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.clientSocketFactoryName);
        this.clientSocketFactory = (RMIClientSocketFactory)clazz.newInstance();
    }

    public String getServerSocketFactory() {
        return this.serverSocketFactoryName;
    }

    public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.serverSocketFactoryName = factoryClassName;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = loader.loadClass(this.serverSocketFactoryName);
        this.serverSocketFactory = (RMIServerSocketFactory)clazz.newInstance();
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void verifiedUser(String username, SRPServerSession session) {
        try {
            SimplePrincipal principal = new SimplePrincipal(username);
            TimedCachePolicy timedCachePolicy = this.cachePolicy;
            synchronized (timedCachePolicy) {
                if (this.cachePolicy.peek((Object)principal) == null) {
                    this.cachePolicy.insert((Object)principal, (Object)session);
                    this.log.trace((Object)("Cached SRP session for username=" + username));
                } else {
                    this.log.debug((Object)("Ignoring SRP session due to existing session for username=" + username));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to update SRP cache for username=" + username), (Throwable)e);
        }
    }

    public void closedUserSession(String username) {
        try {
            SimplePrincipal principal = new SimplePrincipal(username);
            TimedCachePolicy timedCachePolicy = this.cachePolicy;
            synchronized (timedCachePolicy) {
                if (this.cachePolicy.peek((Object)principal) == null) {
                    this.log.warn((Object)("No SRP session found for username=" + username));
                }
                this.cachePolicy.remove((Object)principal);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to update SRP cache for username=" + username), (Throwable)e);
        }
    }

    public String getName() {
        return "SRPService";
    }

    protected void startService() throws Exception {
        this.loadStore();
        this.server = new SRPRemoteServer(this.verifierStore, this.serverPort, this.clientSocketFactory, this.serverSocketFactory);
        this.server.addSRPServerListener(this);
        SRPServerProxy proxyHandler = new SRPServerProxy(this.server);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class[] interfaces = new Class[]{class$org$jboss$security$srp$SRPServerInterface == null ? (class$org$jboss$security$srp$SRPServerInterface = SRPService.class$("org.jboss.security.srp.SRPServerInterface")) : class$org$jboss$security$srp$SRPServerInterface};
        Object proxy = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)proxyHandler);
        InitialContext ctx = new InitialContext();
        Name name = ctx.getNameParser("").parse(this.serverJndiName);
        if (name.size() > 1) {
            int size = name.size();
            Name prefix = name.getPrefix(size - 1);
            Util.createSubcontext((Context)ctx, (Name)prefix);
        }
        ctx.rebind(this.serverJndiName, proxy);
        this.log.debug((Object)("Bound SRPServerProxy at " + this.serverJndiName));
        this.cachePolicy = new TimedCachePolicy(this.cacheTimeout, true, this.cacheResolution);
        this.cachePolicy.create();
        this.cachePolicy.start();
        name = ctx.getNameParser("").parse(this.cacheJndiName);
        NonSerializableFactory.rebind((Name)name, (Object)this.cachePolicy, (boolean)true);
        this.log.debug((Object)("Bound AuthenticationCache at " + this.cacheJndiName));
    }

    protected void stopService() throws Exception {
        InitialContext ctx = new InitialContext();
        ctx.unbind(this.serverJndiName);
        this.log.debug((Object)("Unbound SRPServerProxy at " + this.serverJndiName));
        NonSerializableFactory.unbind((String)this.cacheJndiName);
        ctx.unbind(this.cacheJndiName);
        this.log.debug((Object)("Unbound AuthenticationCache at " + this.cacheJndiName));
    }

    private void loadStore() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.verifierStore = (SRPVerifierStore)ctx.lookup(this.verifierSourceJndiName);
        if (this.server != null) {
            this.server.setVerifierStore(this.verifierStore);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

