/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.DatabaseImpl;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.jdo.engine.SimpleQueryExecutor;
import org.exolab.castor.jdo.oql.Lexer;
import org.exolab.castor.jdo.oql.ParamInfo;
import org.exolab.castor.jdo.oql.ParseTreeNode;
import org.exolab.castor.jdo.oql.ParseTreeWalker;
import org.exolab.castor.jdo.oql.Parser;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.spi.PersistenceQuery;
import org.exolab.castor.persist.spi.QueryExpression;

public class OQLQueryImpl
implements Query,
OQLQuery {
    private LockEngine _dbEngine;
    private DatabaseImpl _dbImpl;
    private Class _objClass;
    private JDOClassDescriptor _clsDesc;
    private QueryExpression _expr;
    private String _spCall;
    private Class[] _bindTypes;
    private Object[] _bindValues;
    private Hashtable _paramInfo;
    private int _fieldNum;
    private int _projectionType;
    private Vector _pathInfo;
    private PersistenceQuery _query;
    private QueryResults _results;
    static /* synthetic */ Class class$java$lang$Object;

    OQLQueryImpl(DatabaseImpl databaseImpl) {
        this._dbImpl = databaseImpl;
    }

    public void bind(double d) {
        this.bind(new Double(d));
    }

    public void bind(float f) {
        this.bind(new Float(f));
    }

    public void bind(int n) {
        this.bind(new Integer(n));
    }

    public void bind(long l) {
        this.bind(new Long(l));
    }

    public void bind(Object object) {
        Object object2;
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._fieldNum == this._paramInfo.size()) {
            throw new IllegalArgumentException("Only " + this._paramInfo.size() + " fields in this query");
        }
        ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(new Integer(this._fieldNum + 1));
        Class clazz = paramInfo.getTheClass();
        Class<?> clazz2 = object.getClass();
        Class clazz3 = paramInfo.getFieldType();
        Class clazz4 = paramInfo.getSQLType();
        if (object != null) {
            if (clazz.isAssignableFrom(clazz2)) {
                object2 = this._dbImpl.getLockEngine().getClassMolder(clazz2);
                if (object2 != null) {
                    object = ((ClassMolder)object2).getActualIdentity(this._dbImpl.getClassLoader(), object);
                }
            } else if (paramInfo.isUserDefined()) {
                throw new IllegalArgumentException("Query paramter " + (this._fieldNum + 1) + " is not of the expected type " + clazz + " it is an instance of the class " + clazz2);
            }
            if (clazz4 != null && !clazz4.isAssignableFrom(clazz2)) {
                if (clazz3 != clazz2) {
                    try {
                        object2 = SQLTypes.getConvertor(clazz2, clazz3);
                        object = object2.convert(object, null);
                    }
                    catch (MappingException mappingException) {
                        throw new IllegalArgumentException("Query parameter " + (this._fieldNum + 1) + " cannot be converted from " + clazz2 + " to " + clazz + ", because no convertor can be found.");
                    }
                }
                if (paramInfo.getConvertor() != null) {
                    object = paramInfo.getConvertor().convert(object, paramInfo.getConvertorParam());
                }
            }
        }
        if (this._bindValues == null) {
            this._bindValues = new Object[this._bindTypes.length];
        }
        object2 = paramInfo.getParamMap().elements();
        while (object2.hasMoreElements()) {
            int n = (Integer)object2.nextElement();
            this._bindValues[n - 1] = object;
        }
        ++this._fieldNum;
    }

    public void bind(short s) {
        this.bind(new Short(s));
    }

    public void bind(boolean bl) {
        this.bind(new Boolean(bl));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        if (this._query != null) {
            this._query.close();
            this._query = null;
        }
        if (this._results != null) {
            this._results.close();
            this._results = null;
        }
    }

    public void create(String string) throws QueryException {
        Object object;
        Object object2;
        this._fieldNum = 0;
        this._expr = null;
        this._spCall = null;
        if (string.startsWith("CALL ")) {
            this.createCall(string);
            return;
        }
        Lexer lexer = new Lexer(string);
        Parser parser = new Parser(lexer);
        ParseTreeNode parseTreeNode = parser.getParseTree();
        this._dbEngine = this._dbImpl.getLockEngine();
        if (this._dbEngine == null) {
            throw new QueryException("Could not get a persistence engine");
        }
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker(this._dbEngine, parseTreeNode, this._dbImpl.getClassLoader());
        this._objClass = parseTreeWalker.getObjClass();
        this._clsDesc = parseTreeWalker.getClassDescriptor();
        this._expr = parseTreeWalker.getQueryExpression();
        this._paramInfo = parseTreeWalker.getParamInfo();
        this._projectionType = parseTreeWalker.getProjectionType();
        this._pathInfo = parseTreeWalker.getPathInfo();
        int n = 0;
        Enumeration enumeration = this._paramInfo.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ParamInfo)enumeration.nextElement();
            object = ((ParamInfo)object2).getParamMap().elements();
            while (object.hasMoreElements()) {
                int n2 = (Integer)object.nextElement();
                if (n2 <= n) continue;
                n = n2;
            }
        }
        this._bindTypes = new Class[n];
        object2 = this._paramInfo.elements();
        while (object2.hasMoreElements()) {
            object = (ParamInfo)object2.nextElement();
            Enumeration enumeration2 = ((ParamInfo)object).getParamMap().elements();
            while (enumeration2.hasMoreElements()) {
                int n3 = (Integer)enumeration2.nextElement();
                Class clazz = this._bindTypes[n3 - 1] = ((ParamInfo)object).getSQLType() == null ? ((ParamInfo)object).getTheClass() : ((ParamInfo)object).getSQLType();
            }
        }
    }

    public void createCall(String string) throws QueryException {
        int n;
        if (!string.startsWith("CALL ")) {
            throw new QueryException("Stored procedure call must start with CALL");
        }
        int n2 = string.indexOf(" AS ");
        if (n2 < 0) {
            throw new QueryException("Stored procedure call must end with \"AS <class-name>\"");
        }
        int n3 = string.indexOf("(");
        int n4 = string.indexOf(")");
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        this._paramInfo = new Hashtable();
        if (n3 < 0 && n4 < 0) {
            stringBuffer.append(string.substring(5, n2));
        } else {
            int n6;
            if (n3 < 0 && n4 >= 0 || n3 > n4) {
                throw new QueryException("Syntax error: parenthesis");
            }
            stringBuffer.append(string.substring(5, n3));
            stringBuffer.append('(');
            n = n3 + 1;
            while (n < n4) {
                if (string.charAt(n) == '$') {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    n6 = n + 1;
                    while (n6 < n4) {
                        char c = string.charAt(n6);
                        if (c < '0' || c > '9') break;
                        stringBuffer2.append(c);
                        ++n6;
                    }
                    Integer n7 = stringBuffer2.length() > 0 ? Integer.valueOf(stringBuffer2.toString()) : new Integer(n5 + 1);
                    ParamInfo paramInfo = (ParamInfo)this._paramInfo.get(n7);
                    if (paramInfo == null) {
                        paramInfo = new ParamInfo("", "java.lang.Object", null);
                    }
                    paramInfo.mapToSQLParam(n5 + 1);
                    this._paramInfo.put(n7, paramInfo);
                    ++n5;
                }
                ++n;
            }
            n6 = 0;
            while (n6 < n5) {
                stringBuffer.append('?');
                if (n6 < n5 - 1) {
                    stringBuffer.append(',');
                }
                ++n6;
            }
            stringBuffer.append(')');
        }
        this._spCall = stringBuffer.toString();
        this._projectionType = 3;
        this._bindTypes = new Class[n5];
        n = 0;
        while (n < n5) {
            this._bindTypes[n] = class$java$lang$Object != null ? class$java$lang$Object : OQLQueryImpl.class$("java.lang.Object");
            ++n;
        }
        String string2 = string.substring(n2 + 4).trim();
        if (string2.length() == 0) {
            throw new QueryException("Missing object name");
        }
        try {
            this._objClass = this._dbImpl.getClassLoader() == null ? Class.forName(string2) : this._dbImpl.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QueryException("Could not find class " + string2);
        }
        this._dbEngine = this._dbImpl.getLockEngine();
        if (this._dbEngine == null || this._dbEngine.getPersistence(this._objClass) == null) {
            throw new QueryException("Could not find an engine supporting class " + string2);
        }
    }

    public QueryResults execute() throws QueryException, PersistenceException, TransactionNotInProgressException {
        return this.execute(null);
    }

    private QueryResults execute(AccessMode accessMode) throws QueryException, PersistenceException, TransactionNotInProgressException {
        if (this._expr == null && this._spCall == null) {
            throw new IllegalStateException("Must create query before using it");
        }
        if (this._results != null) {
            this._results.close();
        }
        switch (this._projectionType) {
            case 3: 
            case 4: 
            case 5: {
                try {
                    SQLEngine sQLEngine = (SQLEngine)this._dbEngine.getPersistence(this._objClass);
                    this._query = this._expr != null ? sQLEngine.createQuery(this._expr, this._bindTypes, accessMode) : sQLEngine.createCall(this._spCall, this._bindTypes);
                    if (this._bindValues != null) {
                        int n = 0;
                        while (n < this._bindValues.length) {
                            this._query.setParameter(n, this._bindValues[n]);
                            ++n;
                        }
                    }
                }
                catch (QueryException queryException) {
                    throw new QueryException(queryException.getMessage());
                }
                org.exolab.castor.persist.QueryResults queryResults = this._dbImpl.getTransaction().query(this._dbEngine, this._query, accessMode);
                this._fieldNum = 0;
                this._results = this._projectionType == 3 ? new OQLEnumeration(queryResults) : new OQLEnumeration(queryResults, this._pathInfo, this._clsDesc);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                SimpleQueryExecutor simpleQueryExecutor = new SimpleQueryExecutor(this._dbImpl);
                this._results = simpleQueryExecutor.execute(this._expr, this._bindValues);
                this._fieldNum = 0;
                break;
            }
            default: {
                return this._results;
            }
        }
        return this._results;
    }

    public QueryResults execute(short s) throws QueryException, PersistenceException, TransactionNotInProgressException {
        switch (s) {
            case 0: {
                return this.execute(AccessMode.ReadOnly);
            }
            case 1: {
                return this.execute(AccessMode.Shared);
            }
            case 2: {
                return this.execute(AccessMode.Exclusive);
            }
            case 3: {
                return this.execute(AccessMode.DbLocked);
            }
        }
        throw new IllegalArgumentException("Value for 'accessMode' is invalid");
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getSQL() throws QueryException {
        if (this._expr != null) {
            return this._expr.getStatement(true);
        }
        return this._spCall;
    }

    static class OQLEnumeration
    implements QueryResults,
    Enumeration {
        private Object _lastObject;
        private Vector _pathInfo;
        private JDOClassDescriptor _classDescriptor;
        private org.exolab.castor.persist.QueryResults _results;

        OQLEnumeration(org.exolab.castor.persist.QueryResults queryResults) {
            this._results = queryResults;
            this._pathInfo = null;
            this._classDescriptor = null;
        }

        OQLEnumeration(org.exolab.castor.persist.QueryResults queryResults, Vector vector, JDOClassDescriptor jDOClassDescriptor) {
            this._results = queryResults;
            this._pathInfo = vector;
            this._classDescriptor = jDOClassDescriptor;
        }

        public void close() {
            if (this._results != null) {
                this._results.close();
                this._results = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        private Object followPath(Object object) {
            JDOClassDescriptor jDOClassDescriptor = this._classDescriptor;
            Object object2 = object;
            int n = 1;
            while (n < this._pathInfo.size()) {
                String string = (String)this._pathInfo.elementAt(n);
                try {
                    JDOFieldDescriptor jDOFieldDescriptor = jDOClassDescriptor.getField(string);
                    FieldHandler fieldHandler = jDOFieldDescriptor.getHandler();
                    object2 = fieldHandler.getValue(object2);
                    jDOClassDescriptor = (JDOClassDescriptor)jDOFieldDescriptor.getClassDescriptor();
                }
                catch (Exception exception) {
                    throw new NoSuchElementException("An exception was thrown trying to access get methods to follow the path expression. " + exception.toString());
                }
                ++n;
            }
            return object2;
        }

        public boolean hasMore() throws PersistenceException {
            return this.hasMore(false);
        }

        public boolean hasMore(boolean bl) throws PersistenceException {
            block9: {
                if (this._lastObject != null) {
                    return true;
                }
                if (this._results == null) {
                    return false;
                }
                try {
                    Object object = this._results.nextIdentity();
                    while (object != null) {
                        try {
                            this._lastObject = this._results.fetch();
                            if (this._lastObject == null) continue;
                            break;
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            object = this._results.nextIdentity();
                        }
                        catch (PersistenceException persistenceException) {
                            object = this._results.nextIdentity();
                            if (bl) continue;
                            throw persistenceException;
                        }
                    }
                    if (object == null) {
                        this._results.close();
                        this._results = null;
                    }
                }
                catch (PersistenceException persistenceException) {
                    this._results.close();
                    this._results = null;
                    if (bl) break block9;
                    throw persistenceException;
                }
            }
            return this._lastObject != null;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore(true);
            }
            catch (PersistenceException persistenceException) {
                return false;
            }
        }

        public Object next() throws PersistenceException, NoSuchElementException {
            return this.next(false);
        }

        private Object next(boolean bl) throws PersistenceException, NoSuchElementException {
            block13: {
                if (this._lastObject != null) {
                    Object object = this._lastObject;
                    this._lastObject = null;
                    if (this._pathInfo == null) {
                        return object;
                    }
                    return this.followPath(object);
                }
                if (this._results == null) {
                    throw new NoSuchElementException();
                }
                try {
                    Object object = this._results.nextIdentity();
                    while (object != null) {
                        block12: {
                            try {
                                Object object2 = this._results.fetch();
                                if (object2 != null) {
                                    if (this._pathInfo == null) {
                                        return object2;
                                    }
                                    return this.followPath(object2);
                                }
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                            }
                            catch (PersistenceException persistenceException) {
                                if (bl) break block12;
                                throw persistenceException;
                            }
                        }
                        object = this._results.nextIdentity();
                    }
                    if (object == null) {
                        this._results.close();
                        this._results = null;
                    }
                }
                catch (PersistenceException persistenceException) {
                    this._results.close();
                    this._results = null;
                    if (bl) break block13;
                    throw persistenceException;
                }
            }
            throw new NoSuchElementException();
        }

        public Object nextElement() throws NoSuchElementException {
            try {
                return this.next(true);
            }
            catch (PersistenceException persistenceException) {
                return null;
            }
        }
    }
}

