/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.regexp.UncheckedRE;
import javax.management.AttributeValueExp;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.ObjectName;
import javax.management.QueryExpSupport;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class MatchQueryExp
extends QueryExpSupport {
    AttributeValueExp attr;
    StringValueExp string;
    UncheckedRE re;

    public MatchQueryExp(AttributeValueExp attr, StringValueExp string) {
        this.attr = attr;
        this.string = string;
        StringBuffer buffer = new StringBuffer();
        char[] chars = string.toString().toCharArray();
        boolean escaping = false;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\\' && !escaping) {
                escaping = true;
            } else {
                if (chars[i] == '?' && !escaping) {
                    buffer.append("(?:.)");
                } else if (chars[i] == '?') {
                    buffer.append("\\?");
                } else if (chars[i] == '*' && !escaping) {
                    buffer.append("(?:.)*");
                } else if (chars[i] == '*') {
                    buffer.append("\\*");
                } else if (chars[i] == '^') {
                    buffer.append("\\^");
                } else if (chars[i] == '$') {
                    buffer.append("\\$");
                } else if (chars[i] == '\\') {
                    buffer.append("\\\\");
                } else if (chars[i] == '.') {
                    buffer.append("\\.");
                } else if (chars[i] == '|') {
                    buffer.append("\\|");
                } else if (chars[i] == '[' && escaping) {
                    buffer.append("\\[");
                } else {
                    buffer.append(chars[i]);
                }
                escaping = false;
            }
            ++i;
        }
        if (escaping) {
            buffer.append("\\\\");
        }
        this.re = new UncheckedRE((Object)buffer);
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp calcAttr = this.attr.apply(name);
        ValueExp calcString = this.string.apply(name);
        if (calcAttr instanceof StringValueExp) {
            return this.re.isMatch((Object)((StringValueExp)calcAttr).toString());
        }
        return false;
    }

    public String toString() {
        return new String("(" + this.attr.toString() + " matches " + this.string.toString() + ")");
    }
}

