/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;

public class ObjectName
implements Serializable {
    private boolean hasPattern = false;
    private boolean hasPropertyPattern = false;
    private Hashtable propertiesHash = null;
    private String domain = null;
    private String kProps = null;
    private String ckProps = null;
    private int hash;

    public ObjectName(String name) throws MalformedObjectNameException {
        int domainSep;
        if (name == null) {
            throw new MalformedObjectNameException("null name");
        }
        if (name.length() == 0) {
            name = "*:*";
        }
        if (-1 == (domainSep = name.indexOf(58))) {
            throw new MalformedObjectNameException("missing domain");
        }
        this.initDomain(name.substring(0, domainSep));
        this.initProperties(name.substring(domainSep + 1));
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        this.initDomain(domain);
        if (null == key || null == value) {
            throw new MalformedObjectNameException("properties key or value cannot be null");
        }
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        ptable.put(key, value);
        this.initProperties(ptable);
        this.kProps = key + "=" + value;
    }

    public ObjectName(String domain, Hashtable table) throws MalformedObjectNameException {
        if (null == table || table.size() < 1) {
            throw new MalformedObjectNameException("null or empty properties");
        }
        this.initDomain(domain);
        this.initProperties((Hashtable)table.clone());
        this.kProps = this.ckProps;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ObjectName) {
            ObjectName oname = (ObjectName)object;
            return oname.hash == this.hash && this.domain.equals(oname.domain) && this.ckProps.equals(oname.ckProps);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.domain + ":" + this.kProps;
    }

    public boolean isPattern() {
        return this.hasPattern;
    }

    public String getCanonicalName() {
        return this.domain + ":" + this.ckProps;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getKeyProperty(String property) {
        return (String)this.propertiesHash.get(property);
    }

    public Hashtable getKeyPropertyList() {
        return (Hashtable)this.propertiesHash.clone();
    }

    public String getKeyPropertyListString() {
        return this.kProps;
    }

    public String getCanonicalKeyPropertyListString() {
        return this.ckProps;
    }

    public boolean isPropertyPattern() {
        return this.hasPropertyPattern;
    }

    private void initDomain(String dstring) throws MalformedObjectNameException {
        if (null == dstring) {
            throw new MalformedObjectNameException("null domain");
        }
        if (this.isIllegalDomain(dstring)) {
            throw new MalformedObjectNameException("domain contains illegal characters");
        }
        if (dstring.indexOf(42) > -1 || dstring.indexOf(63) > -1) {
            this.hasPattern = true;
        }
        this.domain = dstring;
    }

    private void initProperties(String properties) throws MalformedObjectNameException {
        if (null == properties || properties.length() < 1) {
            throw new MalformedObjectNameException("null or empty properties");
        }
        if (properties.startsWith(",") || properties.endsWith(",") || properties.indexOf(",,") != -1) {
            throw new MalformedObjectNameException("empty key/value pair in properties string");
        }
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            String chunk = tokenizer.nextToken();
            if (chunk.equals("*")) {
                this.hasPropertyPattern = true;
                this.hasPattern = true;
                continue;
            }
            int keylen = chunk.length();
            int eqpos = chunk.indexOf(61);
            if (eqpos < 1 || keylen == eqpos + 1) {
                throw new MalformedObjectNameException("malformed key/value pair: " + chunk);
            }
            String key = chunk.substring(0, eqpos);
            if (ptable.containsKey(key)) {
                throw new MalformedObjectNameException("duplicate key: " + key);
            }
            ptable.put(key, chunk.substring(eqpos + 1, keylen));
        }
        this.initProperties(ptable);
        this.kProps = properties;
    }

    private void initProperties(Hashtable properties) throws MalformedObjectNameException {
        if (null == properties || !this.hasPropertyPattern && properties.size() < 1) {
            throw new MalformedObjectNameException("null or empty properties");
        }
        Iterator<Object> it = properties.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException("key is not a string");
            }
            String val = null;
            try {
                val = (String)properties.get(key);
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException("value is not a string");
            }
            if (key.equals("*") && val.equals("*")) {
                it.remove();
                this.hasPropertyPattern = true;
                this.hasPattern = true;
                continue;
            }
            if (this.isIllegalKeyOrValue(key) || this.isIllegalKeyOrValue(val)) {
                throw new MalformedObjectNameException("malformed key/value pair: " + key + "=" + val);
            }
            list.add(new String(key + "=" + val));
        }
        Collections.sort(list);
        StringBuffer strBuffer = new StringBuffer();
        it = list.iterator();
        while (it.hasNext()) {
            strBuffer.append(it.next());
            if (!it.hasNext()) continue;
            strBuffer.append(',');
        }
        if (this.hasPropertyPattern) {
            if (properties.size() > 0) {
                strBuffer.append(",*");
            } else {
                strBuffer.append("*");
            }
        }
        this.propertiesHash = properties;
        this.ckProps = strBuffer.toString();
        this.hash = this.getCanonicalName().hashCode();
    }

    private boolean isIllegalKeyOrValue(String keyOrValue) {
        char[] chars = keyOrValue.toCharArray();
        if (chars.length == 0) {
            return true;
        }
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '*': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isIllegalDomain(String dom) {
        char[] chars = dom.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case ',': 
                case ':': 
                case '=': {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

