/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.MLetMBean;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.MBeanElement;
import org.jboss.mx.loading.MLetParser;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepository;
import org.jboss.mx.logging.Logger;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration {
    private MBeanServer server = null;
    private ObjectName objectName = null;
    private static final Logger log = Logger.getLogger(class$javax$management$loading$MLet == null ? (class$javax$management$loading$MLet = MLet.class$("javax.management.loading.MLet")) : class$javax$management$loading$MLet);
    static /* synthetic */ Class class$javax$management$loading$MLet;

    public MLet() {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
    }

    public MLet(URL[] urls) {
        super(urls, Thread.currentThread().getContextClassLoader());
    }

    public MLet(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (name == null) {
            name = new ObjectName(":type=MLet");
        }
        this.objectName = name;
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        try {
            return this.getMBeansFromURL(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException("Malformed URL:" + url);
        }
    }

    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException("Loader must be registered to the server before loading the MBeans.");
        }
        HashSet<Serializable> mbeans = new HashSet<Serializable>();
        MBeanElement element = null;
        try {
            MLetParser parser = new MLetParser();
            Set mlets = parser.parseMBeanFile(url);
            if (mlets.size() == 0) {
                throw new ServiceNotFoundException("The specified URL '" + url + "' does not contain MLET tags.");
            }
            Iterator it = mlets.iterator();
            while (it.hasNext()) {
                element = (MBeanElement)it.next();
                String codebase = element.getCodebase();
                if (codebase == null) {
                    codebase = url.toString().substring(0, url.toString().lastIndexOf(47));
                }
                Iterator archives = element.getArchives().iterator();
                String codebaseURL = null;
                while (archives.hasNext()) {
                    try {
                        codebaseURL = codebase + (codebase.endsWith("/") ? "" : "/") + archives.next();
                        this.addURL(new URL(codebaseURL));
                    }
                    catch (MalformedURLException e) {
                        log.error("MLET ERROR: malformed codebase URL: '" + codebaseURL + "'");
                    }
                }
                try {
                    mbeans.add(this.server.createMBean(element.getCode(), element.getName() != null ? new ObjectName(element.getName()) : null, this.objectName, element.getConstructorValues(), element.getConstructorTypes()));
                }
                catch (Throwable t) {
                    mbeans.add(t);
                    log.error("MLET ERROR: can't create MBean: " + t.toString(), t);
                }
            }
        }
        catch (ParseException e) {
            throw new ServiceNotFoundException(e.getMessage());
        }
        return mbeans;
    }

    public void addURL(URL url) {
        if (System.getProperty("jbossmx.loader.repository.class").equals("org.jboss.mx.loading.UnifiedLoaderRepository")) {
            LoaderRepository.getDefaultLoaderRepository().addClassLoader(new UnifiedClassLoader(url));
        } else {
            super.addURL(url);
        }
    }

    public void addURL(String url) throws ServiceNotFoundException {
        try {
            this.addURL(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ServiceNotFoundException("Malformed URL: " + url);
        }
    }

    public String getLibraryDirectory() {
        throw new Error("NYI");
    }

    public void setLibraryDirectory(String libdir) {
        throw new Error("NYI");
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (System.getProperty("jbossmx.loader.repository.class").equals("org.jboss.mx.loading.UnifiedLoaderRepository")) {
            UnifiedLoaderRepository ulr = (UnifiedLoaderRepository)LoaderRepository.getDefaultLoaderRepository();
            return ulr.loadClass(name, resolve, Thread.currentThread().getContextClassLoader());
        }
        return super.loadClass(name, resolve);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

