/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.Vector;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private Vector enabled = new Vector();
    private Vector disabled = null;

    public synchronized void disableAllObjectNames() {
        this.enabled = new Vector();
        this.disabled = null;
    }

    public synchronized void disableObjectName(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        if (this.enabled != null) {
            this.enabled.removeElement(objectName);
        }
        if (this.disabled != null && !this.disabled.contains(objectName)) {
            this.disabled.addElement(objectName);
        }
    }

    public synchronized void enableAllObjectNames() {
        this.enabled = null;
        this.disabled = new Vector();
    }

    public synchronized void enableObjectName(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("null object name");
        }
        if (this.disabled != null) {
            this.disabled.removeElement(objectName);
        }
        if (this.enabled != null && !this.enabled.contains(objectName)) {
            this.enabled.addElement(objectName);
        }
    }

    public synchronized Vector getDisabledObjectNames() {
        if (this.disabled == null) {
            return null;
        }
        return new Vector(this.disabled);
    }

    public synchronized Vector getEnabledObjectNames() {
        if (this.enabled == null) {
            return null;
        }
        return new Vector(this.enabled);
    }

    public synchronized boolean isNotificationEnabled(Notification notification) throws IllegalArgumentException {
        if (notification == null) {
            throw new IllegalArgumentException("null notification");
        }
        if (!super.isNotificationEnabled(notification)) {
            return false;
        }
        MBeanServerNotification mbsNotification = (MBeanServerNotification)notification;
        ObjectName objectName = mbsNotification.getMBeanName();
        if (this.enabled != null) {
            return this.enabled.contains(objectName);
        }
        return !this.disabled.contains(objectName);
    }
}

