/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;
import org.jboss.mx.metadata.MBeanCapability;

public class RoleInfo
implements Serializable {
    public static int ROLE_CARDINALITY_INFINITY = -1;
    private String name;
    private String className;
    boolean readable;
    boolean writable;
    int minDegree;
    int maxDegree;
    String description;

    public RoleInfo(RoleInfo other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("Null role info");
        }
        this.name = other.name;
        this.className = other.className;
        this.readable = other.readable;
        this.writable = other.writable;
        this.minDegree = other.minDegree;
        this.maxDegree = other.maxDegree;
        this.description = other.description;
    }

    public RoleInfo(String name, String className) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        this(name, className, true, true);
    }

    public RoleInfo(String name, String className, boolean readable, boolean writable) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        this.name = name;
        this.className = className;
        this.readable = readable;
        this.writable = writable;
        this.minDegree = 1;
        this.maxDegree = 1;
        this.checkClass();
    }

    public RoleInfo(String name, String className, boolean readable, boolean writable, int minDegree, int maxDegree, String description) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException, InvalidRoleInfoException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (maxDegree < minDegree && maxDegree != ROLE_CARDINALITY_INFINITY) {
            throw new InvalidRoleInfoException("maximum less than minimum");
        }
        if (minDegree == ROLE_CARDINALITY_INFINITY && maxDegree != ROLE_CARDINALITY_INFINITY) {
            throw new InvalidRoleInfoException("maximum less than minimum");
        }
        this.name = name;
        this.className = className;
        this.minDegree = minDegree;
        this.maxDegree = maxDegree;
        this.readable = readable;
        this.writable = writable;
        this.description = description;
        this.checkClass();
    }

    public boolean checkMinDegree(int value) {
        return value >= this.minDegree || this.minDegree == ROLE_CARDINALITY_INFINITY;
    }

    public boolean checkMaxDegree(int value) {
        return value <= this.maxDegree || this.maxDegree == ROLE_CARDINALITY_INFINITY;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public int getMaxDegree() {
        return this.maxDegree;
    }

    public String getName() {
        return this.name;
    }

    public String getRefMBeanClassName() {
        return this.className;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("RoleInfo for name: (");
        buffer.append(this.name);
        buffer.append(") class name: (");
        buffer.append(this.className);
        buffer.append(") description: (");
        buffer.append(this.description);
        buffer.append(") readable: (");
        buffer.append(this.readable);
        buffer.append(") writable: (");
        buffer.append(this.writable);
        buffer.append(") minimum degree: (");
        buffer.append(this.minDegree);
        buffer.append(") maximum degree: (");
        buffer.append(this.maxDegree);
        buffer.append(")");
        return buffer.toString();
    }

    private void checkClass() throws ClassNotFoundException, NotCompliantMBeanException {
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.className);
        MBeanCapability.of(clazz);
    }
}

