/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.util.Iterator;
import org.jboss.mx.loading.LoaderRepository;

public class BasicLoaderRepository
extends LoaderRepository {
    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClassWithout(null, className);
    }

    public Class loadClassWithout(ClassLoader skipLoader, String className) throws ClassNotFoundException {
        Class<?> clazz = (Class<?>)LoaderRepository.nativeClassBySignature.get(className);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (ctxLoader != skipLoader) {
            try {
                clazz = ctxLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return clazz;
        }
        Iterator it = LoaderRepository.loaders.iterator();
        while (it.hasNext()) {
            ClassLoader cl = (ClassLoader)it.next();
            if (cl == skipLoader) continue;
            try {
                clazz = cl.loadClass(className);
                return clazz;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }

    public void addClassLoader(ClassLoader cl) {
        LoaderRepository.loaders.add(cl);
    }

    public void removeClassLoader(ClassLoader cl) {
        LoaderRepository.loaders.remove(cl);
    }
}

