/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedLoaderRepositoryMBean;
import org.jboss.mx.logging.Logger;

public class UnifiedLoaderRepository
extends LoaderRepository
implements NotificationBroadcaster,
UnifiedLoaderRepositoryMBean {
    private HashSet classLoaders = new HashSet();
    private HashSet classLoaderURLs = new HashSet();
    private HashMap classes = new HashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;
    private Thread currentThread;
    private ReentrantLock reentrantLock = new ReentrantLock();
    private Object lock = new Object();
    private int threadsCount;
    private static final Logger log = Logger.getLogger(class$org$jboss$mx$loading$UnifiedLoaderRepository == null ? (class$org$jboss$mx$loading$UnifiedLoaderRepository = UnifiedLoaderRepository.class$("org.jboss.mx.loading.UnifiedLoaderRepository")) : class$org$jboss$mx$loading$UnifiedLoaderRepository);
    static /* synthetic */ Class class$org$jboss$mx$loading$UnifiedLoaderRepository;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        Class clazz;
        block7: {
            Class clazz2;
            block6: {
                try {
                    this.synchronize(cl);
                    UnifiedLoaderRepository unifiedLoaderRepository = this;
                    synchronized (unifiedLoaderRepository) {
                        Class cls = this.loadClassFromCache(name, cl);
                        if (cls != null) {
                            Class clazz3 = cls;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
                            Object var9_9 = null;
                            this.unsynchronize(cl);
                            return clazz3;
                        }
                        cls = this.loadClassFromClassLoader(name, resolve, cl);
                        if (cls != null) {
                            clazz2 = cls;
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                            break block6;
                        }
                        cls = this.loadClassFromRepository(name, resolve, cl);
                        if (cls == null) throw new ClassNotFoundException(name);
                        clazz = cls;
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    this.unsynchronize(cl);
                    throw throwable;
                }
            }
            Object var9_10 = null;
            this.unsynchronize(cl);
            return clazz2;
        }
        Object var9_11 = null;
        this.unsynchronize(cl);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronize(ClassLoader cl) {
        try {
            try {
                this.reentrantLock.acquire();
                while (!this.isThreadAllowed(Thread.currentThread())) {
                    this.reentrantLock.release();
                    ClassLoader classLoader = cl;
                    synchronized (classLoader) {
                        try {
                            cl.wait(137L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                    try {
                        this.reentrantLock.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (InterruptedException ignored) {
                Object var6_8 = null;
                this.increaseThreadsCount();
                this.reentrantLock.release();
                return;
            }
            Object var6_7 = null;
            this.increaseThreadsCount();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.increaseThreadsCount();
            this.reentrantLock.release();
            throw throwable;
        }
        this.reentrantLock.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unsynchronize(ClassLoader cl) {
        try {
            block8: {
                try {
                    this.reentrantLock.acquire();
                    if (this.decreaseThreadsCount() != 0) break block8;
                    this.setCurrentThread(null);
                }
                catch (InterruptedException ignored) {
                    Object var4_3 = null;
                    this.reentrantLock.release();
                    ClassLoader classLoader3 = cl;
                    synchronized (classLoader3) {
                        cl.notifyAll();
                        return;
                    }
                }
            }
            Object var4_2 = null;
            this.reentrantLock.release();
            ClassLoader classLoader = cl;
            synchronized (classLoader) {
                cl.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.reentrantLock.release();
            ClassLoader classLoader2 = cl;
            synchronized (classLoader2) {
                cl.notifyAll();
                throw throwable;
            }
        }
    }

    private boolean isThreadAllowed(Thread thread) {
        Object object = this.lock;
        synchronized (object) {
            Thread current = this.getCurrentThread();
            if (current == null) {
                this.setCurrentThread(thread);
                boolean bl = true;
                return bl;
            }
            if (current == thread) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void setCurrentThread(Thread t) {
        Object object = this.lock;
        synchronized (object) {
            this.currentThread = t;
        }
    }

    private Thread getCurrentThread() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread = this.currentThread;
            return thread;
        }
    }

    private int increaseThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            ++this.threadsCount;
            int n = this.getThreadsCount();
            return n;
        }
    }

    private int decreaseThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            --this.threadsCount;
            int n = this.getThreadsCount();
            return n;
        }
    }

    private int getThreadsCount() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.threadsCount;
            return n;
        }
    }

    private Class loadClassFromCache(String name, ClassLoader cl) {
        Class cls = (Class)this.classes.get(name);
        return cls;
    }

    private void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        this.classes.put(name, cls);
        HashSet<String> classes = (HashSet<String>)this.loaderToClassesMap.get(cl);
        if (classes == null) {
            classes = new HashSet<String>();
            this.loaderToClassesMap.put(cl, classes);
        }
        classes.add(name);
    }

    private Class loadClassFromClassLoader(String name, boolean resolve, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            try {
                Class cls = ((UnifiedClassLoader)cl).loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, cl);
                return cls;
            }
            catch (ClassNotFoundException x) {
                // empty catch block
            }
        }
        return null;
    }

    private Class loadClassFromRepository(String name, boolean resolve, ClassLoader cl) {
        Iterator i = this.classLoaders.iterator();
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader)) continue;
            try {
                Class cls = ((UnifiedClassLoader)classloader).loadClassLocally(name, resolve);
                this.cacheLoadedClass(name, cls, classloader);
                return cls;
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URL getResource(String name, ClassLoader cl) {
        block9: {
            URL uRL;
            block8: {
                URL uRL2;
                block7: {
                    try {
                        this.synchronize(cl);
                        UnifiedLoaderRepository unifiedLoaderRepository = this;
                        synchronized (unifiedLoaderRepository) {
                            URL resource = this.getResourceFromCache(name, cl);
                            if (resource != null) {
                                URL uRL3 = resource;
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                                Object var8_8 = null;
                                this.unsynchronize(cl);
                                return uRL3;
                            }
                            resource = this.getResourceFromClassLoader(name, cl);
                            if (resource != null) {
                                uRL2 = resource;
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                                break block7;
                            }
                            resource = this.getResourceFromRepository(name, cl);
                            if (resource != null) {
                                uRL = resource;
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                                break block8;
                            }
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        this.unsynchronize(cl);
                        throw throwable;
                    }
                }
                Object var8_9 = null;
                this.unsynchronize(cl);
                return uRL2;
            }
            Object var8_10 = null;
            this.unsynchronize(cl);
            return uRL;
        }
        Object var8_11 = null;
        this.unsynchronize(cl);
        return null;
    }

    private URL getResourceFromCache(String name, ClassLoader cl) {
        if (this.loaderToResourcesMap.containsKey(cl)) {
            HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
            return (URL)resources.get(name);
        }
        return null;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        if (cl instanceof UnifiedClassLoader) {
            URL url = ((UnifiedClassLoader)cl).getResourceLocally(name);
            this.cacheLoadedResource(name, url, cl);
            return url;
        }
        return null;
    }

    private URL getResourceFromRepository(String name, ClassLoader cl) {
        Iterator i = this.classLoaders.iterator();
        while (i.hasNext()) {
            URL url;
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof UnifiedClassLoader) || (url = ((UnifiedClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            return url;
        }
        return null;
    }

    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
        if (resources == null) {
            resources = new HashMap<String, URL>();
            this.loaderToResourcesMap.put(cl, resources);
        }
        resources.put(name, url);
    }

    public Class findClass(String name) {
        String classRsrcName = name.replace('.', '/') + ".class";
        UnifiedLoaderRepository unifiedLoaderRepository = this;
        synchronized (unifiedLoaderRepository) {
            Iterator iter = this.classLoaders.iterator();
            while (iter.hasNext()) {
                ClassLoader cl = (ClassLoader)iter.next();
                URL classURL = cl.getResource(classRsrcName);
                if (classURL == null) continue;
                try {
                    Class<?> cls;
                    Class<?> clazz = cls = cl.loadClass(name);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    log.debug("Failed to load class: " + name, e);
                }
            }
        }
        return null;
    }

    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        UnifiedLoaderRepository unifiedLoaderRepository = this;
        synchronized (unifiedLoaderRepository) {
            Iterator iter = this.classLoaders.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof UnifiedClassLoader)) continue;
                UnifiedClassLoader cl = (UnifiedClassLoader)obj;
                URL[] urls = cl.getClasspath();
                int length = urls != null ? urls.length : 0;
                int u = 0;
                while (u < length) {
                    URL path = urls[u];
                    classpath.add(path);
                    ++u;
                }
            }
        }
        return classpath.toArray(new URL[classpath.size()]);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = this.loadClass(className, false, scl);
        }
        catch (ClassNotFoundException e) {
            if (!(scl instanceof UnifiedClassLoader)) {
                clazz = scl.loadClass(className);
            }
            throw e;
        }
        return clazz;
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new Error("NYI");
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader instanceof UnifiedClassLoader) {
            this.addUnifiedClassLoader((UnifiedClassLoader)loader);
        } else if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            URL[] urls = ucl.getURLs();
            int i = 0;
            while (i < urls.length) {
                this.addUnifiedClassLoader(new UnifiedClassLoader(urls[i], this));
                ++i;
            }
        } else {
            log.warn("Tried to add non- URLClassLoader.  Ignored");
        }
    }

    private void addUnifiedClassLoader(UnifiedClassLoader cl) {
        try {
            this.synchronize(cl);
            UnifiedLoaderRepository unifiedLoaderRepository = this;
            synchronized (unifiedLoaderRepository) {
                cl.setRepository(this);
                URL url = cl.getURL();
                boolean exists = this.classLoaderURLs.contains(url);
                boolean added = false;
                if (!exists) {
                    added = this.classLoaders.add(cl);
                }
                if (added) {
                    log.debug("UnifiedLoaderRepository adding " + cl);
                } else {
                    log.debug("UnifiedLoaderRepository skipping duplicate " + cl);
                }
            }
            Object var8_7 = null;
            this.unsynchronize(cl);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.unsynchronize(cl);
            throw throwable;
        }
    }

    public void removeClassLoader(ClassLoader cl) {
        try {
            this.synchronize(cl);
            UnifiedLoaderRepository unifiedLoaderRepository = this;
            synchronized (unifiedLoaderRepository) {
                HashSet loaded;
                if (cl instanceof UnifiedClassLoader) {
                    UnifiedClassLoader ucl = (UnifiedClassLoader)cl;
                    URL url = ucl.getURL();
                    this.classLoaderURLs.remove(url);
                }
                boolean removed = this.classLoaders.remove(cl);
                log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
                if (this.loaderToClassesMap.containsKey(cl) && (loaded = (HashSet)this.loaderToClassesMap.remove(cl)) != null) {
                    Iterator iter = loaded.iterator();
                    while (iter.hasNext()) {
                        this.broadcaster.sendNotification(new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), (String)iter.next()));
                    }
                    Iterator i = loaded.iterator();
                    while (i.hasNext()) {
                        String cls = (String)i.next();
                        this.classes.remove(cls);
                    }
                }
                if (this.loaderToResourcesMap.containsKey(cl)) {
                    HashMap resources = (HashMap)this.loaderToResourcesMap.remove(cl);
                }
            }
            Object var10_10 = null;
            this.unsynchronize(cl);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.unsynchronize(cl);
            throw throwable;
        }
    }

    public LoaderRepository registerClassLoader(UnifiedClassLoader ucl) {
        this.addClassLoader(ucl);
        Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
        msg.setUserData(ucl);
        this.broadcaster.sendNotification(msg);
        return this;
    }

    public UnifiedLoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")};
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ReentrantLock {
        private int holds;
        private Thread owner;

        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread caller = Thread.currentThread();
            ReentrantLock reentrantLock = this;
            synchronized (reentrantLock) {
                if (caller == this.owner) {
                    ++this.holds;
                } else {
                    try {
                        while (this.owner != null) {
                            this.wait();
                        }
                        this.owner = caller;
                        this.holds = 1;
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
            }
        }

        public synchronized void release() {
            Thread t = Thread.currentThread();
            if (t != this.owner) {
                throw new Error("Illegal Lock usage, t=" + t + ", owner=" + this.owner);
            }
            if (--this.holds == 0) {
                this.owner = null;
                this.notify();
            }
        }

        public synchronized int holds() {
            if (Thread.currentThread() != this.owner) {
                return 0;
            }
            return this.holds;
        }
    }
}

