/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging;

import java.io.PrintStream;
import org.jboss.mx.logging.LoggerAdapterSupport;

public final class DefaultLoggerAdapter
extends LoggerAdapterSupport {
    private int level = 30000;

    public final String getName() {
        return "Default";
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final void log(int level, String message) {
        if (!this.isEnabled(level)) {
            return;
        }
        DefaultLoggerAdapter.doLog(level, message, null);
    }

    public final void log(int level, String message, Throwable throwable) {
        if (!this.isEnabled(level)) {
            return;
        }
        DefaultLoggerAdapter.doLog(level, message, throwable);
    }

    public final boolean isEnabled(int level) {
        return level >= this.level;
    }

    public Object getUnderlyingLogger() {
        return this;
    }

    private static final void doLog(int level, String message, Throwable throwable) {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            if (level == 50000) {
                System.err.print("FATAL ");
            }
            if (level == 40000) {
                System.err.print("ERROR ");
            }
            if (level == 30000) {
                System.err.print("WARN  ");
            }
            if (level == 20000) {
                System.err.print("INFO  ");
            }
            if (level == 10000) {
                System.err.print("DEBUG ");
            }
            if (level == 9000) {
                System.err.print("TRACE ");
            }
            System.err.println(message);
            if (throwable != null) {
                throwable.printStackTrace(System.err);
            }
        }
    }
}

