/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging;

import java.lang.reflect.Constructor;
import java.util.WeakHashMap;
import org.jboss.mx.logging.DefaultLoggerAdapterFactory;
import org.jboss.mx.logging.LoggerAdapterFactory;
import org.jboss.mx.logging.LoggerContext;
import org.jboss.mx.logging.LoggerContextSelector;
import org.jboss.mx.server.ServerConstants;

public final class DefaultLoggerContextSelector
implements LoggerContextSelector,
ServerConstants {
    private WeakHashMap contexts = new WeakHashMap();
    public static LoggerContext defaultLoggerContext;

    public final void associate(Object context, LoggerContext loggerContext) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (!(context instanceof ClassLoader)) {
            throw new RuntimeException("Only classloaders are allowed as contexts");
        }
        if (loggerContext == null) {
            throw new IllegalArgumentException("null logger context");
        }
        WeakHashMap weakHashMap = this.contexts;
        synchronized (weakHashMap) {
            this.contexts.put(context, loggerContext);
        }
    }

    public final void remove(Object context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        WeakHashMap weakHashMap = this.contexts;
        synchronized (weakHashMap) {
            this.contexts.remove(context);
        }
    }

    public final LoggerContext getLoggerContext() {
        LoggerContext result = null;
        WeakHashMap weakHashMap = this.contexts;
        synchronized (weakHashMap) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            while (cl != null) {
                result = (LoggerContext)this.contexts.get(cl);
                if (result != null) break;
                cl = cl.getParent();
            }
        }
        if (result == null) {
            result = defaultLoggerContext;
        }
        return result;
    }

    static {
        String factoryClass = System.getProperty("jbossmx.logging.adapter.factory.class", "org.jboss.mx.logging.log4j.Log4jAdapterFactory");
        LoggerAdapterFactory factory = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(factoryClass);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            factory = (LoggerAdapterFactory)constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            factory = new DefaultLoggerAdapterFactory();
        }
        defaultLoggerContext = new LoggerContext(factory);
    }
}

