/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.mx.logging.Logger;
import org.jboss.mx.logging.LoggerAdapter;
import org.jboss.mx.logging.LoggerAdapterFactory;
import org.jboss.mx.logging.LoggerManager;

public class LoggerContext {
    private LoggerAdapterFactory factory;
    private final HashMap loggers = new HashMap();
    private static final LoggerManager manager = LoggerManager.getLoggerManager();
    private static final GarbageMonitor garbageMonitor = new GarbageMonitor();
    private static final ReferenceQueue garbageCollected = new ReferenceQueue();
    private static final HashMap monitored = new HashMap();

    private static final void monitor(WeakReference weak, LoggerContext context, String name) {
        LoggerInfo info = new LoggerInfo(context, name);
        HashMap hashMap = monitored;
        synchronized (hashMap) {
            monitored.put(weak, info);
        }
    }

    private static final void remove(WeakReference weak) {
        LoggerInfo info;
        HashMap hashMap = monitored;
        synchronized (hashMap) {
            info = (LoggerInfo)monitored.remove(weak);
        }
        info.context.remove(info.name);
    }

    public LoggerContext(LoggerAdapterFactory factory) {
        this.factory = factory;
        Object context = factory.getContext();
        if (context != null) {
            manager.associateContext(context, this);
        }
    }

    public final Logger getLogger(String name) {
        Logger result;
        WeakReference<Logger> weak;
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        HashMap hashMap = this.loggers;
        synchronized (hashMap) {
            weak = (WeakReference<Logger>)this.loggers.get(name);
            if (weak != null && (result = (Logger)weak.get()) != null) {
                Logger logger = result;
                return logger;
            }
            LoggerAdapter adapter = this.factory.getLoggerAdapter(name);
            result = new Logger(adapter);
            weak = new WeakReference<Logger>(result, garbageCollected);
            this.loggers.put(name, weak);
        }
        LoggerContext.monitor(weak, this, name);
        return result;
    }

    public final LoggerAdapterFactory getLoggerAdapterFactory() throws SecurityException {
        return this.factory;
    }

    public final void setLoggerAdapterFactory(LoggerAdapterFactory factory) throws SecurityException {
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        HashMap hashMap = this.loggers;
        synchronized (hashMap) {
            Class oldDelegateClass = this.factory.getLoggerAdapterClass();
            Class newDelegateClass = factory.getLoggerAdapterClass();
            if (oldDelegateClass != newDelegateClass) {
                return;
            }
            Object context = this.factory.getContext();
            if (context != null) {
                manager.removeContext(context);
            }
            this.factory = factory;
            context = factory.getContext();
            if (context != null) {
                manager.associateContext(context, this);
            }
            Iterator iterator = this.loggers.entrySet().iterator();
            while (iterator.hasNext()) {
                LoggerAdapter adapter;
                Map.Entry entry = iterator.next();
                WeakReference weak = (WeakReference)entry.getValue();
                Logger logger = (Logger)weak.get();
                if (logger == null) {
                    iterator.remove();
                }
                if ((adapter = logger.getLoggerAdapter()).getClass().equals(newDelegateClass)) continue;
                String name = (String)entry.getKey();
                logger.setLoggerAdapter(factory.getLoggerAdapter(name));
            }
        }
    }

    public final void setConfiguration(Object configurator) throws SecurityException {
        this.factory.setConfiguration(configurator);
    }

    public final void resetConfiguration() throws SecurityException {
        this.factory.resetConfiguration();
    }

    public final Enumeration getLoggers() {
        return new LoggersEnumeration();
    }

    private final void remove(String name) {
        HashMap hashMap = this.loggers;
        synchronized (hashMap) {
            this.loggers.remove(name);
        }
    }

    private static class GarbageMonitor
    extends Thread {
        public GarbageMonitor() {
            this.setDaemon(true);
            this.start();
        }

        public final void run() {
            while (true) {
                try {
                    WeakReference weak = (WeakReference)garbageCollected.remove();
                    LoggerContext.remove(weak);
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    private static class LoggerInfo {
        public LoggerContext context;
        private String name;

        public LoggerInfo(LoggerContext context, String name) {
            this.context = context;
            this.name = name;
        }
    }

    private class LoggersEnumeration
    implements Enumeration {
        private Iterator iterator;
        private Object current;

        public LoggersEnumeration() {
            this.iterator = LoggerContext.this.loggers.values().iterator();
            this.next();
        }

        public final boolean hasMoreElements() {
            return this.current != null;
        }

        public final Object nextElement() {
            Object result = this.current;
            this.next();
            return result;
        }

        private final void next() {
            this.current = null;
            while (this.iterator.hasNext()) {
                WeakReference weak = (WeakReference)this.iterator.next();
                this.current = weak.get();
                if (this.current == null) continue;
                return;
            }
        }
    }
}

