/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging.file;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jboss.mx.logging.LoggerAdapterSupport;

public final class FileLogger
extends LoggerAdapterSupport {
    private int level = Integer.MIN_VALUE;
    private String fileName;
    private PrintStream output;

    public FileLogger(String name) throws FileNotFoundException {
        this(name, true);
    }

    public FileLogger(String name, boolean append) throws FileNotFoundException {
        this.fileName = name;
        this.output = new PrintStream(new FileOutputStream(name, append), true);
    }

    public final String getName() {
        return this.fileName;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int level) throws SecurityException {
        this.level = level;
    }

    public final void log(int level, String message) {
        if (!this.isEnabled(level)) {
            return;
        }
        this.doLog(level, message, null);
    }

    public final void log(int level, String message, Throwable throwable) {
        if (!this.isEnabled(level)) {
            return;
        }
        this.doLog(level, message, throwable);
    }

    public final boolean isEnabled(int level) {
        return level <= this.level;
    }

    public Object getUnderlyingLogger() {
        return this;
    }

    private final void doLog(int level, String message, Throwable throwable) {
        PrintStream printStream = this.output;
        synchronized (printStream) {
            if (level == 50000) {
                this.output.print("FATAL ");
            }
            if (level == 40000) {
                this.output.print("ERROR ");
            }
            if (level == 30000) {
                this.output.print("WARN  ");
            }
            if (level == 20000) {
                this.output.print("INFO  ");
            }
            if (level == 10000) {
                this.output.print("DEBUG ");
            }
            if (level == 9000) {
                this.output.print("TRACE ");
            }
            this.output.println(message);
            if (throwable != null) {
                throwable.printStackTrace(this.output);
            }
        }
    }
}

