/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.logging.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.jboss.mx.logging.LoggerAdapter;
import org.jboss.mx.logging.log4j.TracePriority;

public final class Log4jAdapter
implements LoggerAdapter {
    Category category;

    public Log4jAdapter(String name) {
        this.category = Category.getInstance((String)name);
    }

    public final String getName() {
        return this.category.getName();
    }

    public final int getLevel() {
        return this.category.getPriority().toInt();
    }

    public final void setLevel(int level) throws SecurityException {
        this.category.setPriority(Priority.toPriority((int)level));
    }

    public final void log(int level, String message) {
        this.category.log(Priority.toPriority((int)level), (Object)message);
    }

    public final void log(int level, String message, Throwable throwable) {
        this.category.log(Priority.toPriority((int)level), (Object)message);
    }

    public final boolean isEnabled(int level) {
        Priority p = Priority.toPriority((int)level);
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void fatal(String message) {
        this.category.fatal((Object)message);
    }

    public final void fatal(String message, Throwable throwable) {
        this.category.fatal((Object)message, throwable);
    }

    public final boolean isFatalEnabled() {
        Priority p = Priority.FATAL;
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void error(String message) {
        this.category.error((Object)message);
    }

    public final void error(String message, Throwable throwable) {
        this.category.error((Object)message, throwable);
    }

    public final boolean isErrorEnabled() {
        Priority p = Priority.ERROR;
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void warn(String message) {
        this.category.warn((Object)message);
    }

    public final void warn(String message, Throwable throwable) {
        this.category.warn((Object)message, throwable);
    }

    public final boolean isWarnEnabled() {
        Priority p = Priority.WARN;
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void info(String message) {
        this.category.info((Object)message);
    }

    public final void info(String message, Throwable throwable) {
        this.category.info((Object)message, throwable);
    }

    public final boolean isInfoEnabled() {
        Priority p = Priority.INFO;
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void debug(String message) {
        this.category.debug((Object)message);
    }

    public final void debug(String message, Throwable throwable) {
        this.category.debug((Object)message, throwable);
    }

    public final boolean isDebugEnabled() {
        Priority p = Priority.DEBUG;
        if (!this.category.isEnabledFor(p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public final void trace(String message) {
        this.category.log((Priority)TracePriority.TRACE, (Object)message);
    }

    public final void trace(String message, Throwable throwable) {
        this.category.log((Priority)TracePriority.TRACE, (Object)message, throwable);
    }

    public final boolean isTraceEnabled() {
        TracePriority p = TracePriority.TRACE;
        if (!this.category.isEnabledFor((Priority)p)) {
            return false;
        }
        return p.isGreaterOrEqual(this.category.getChainedPriority());
    }

    public Object getUnderlyingLogger() {
        return this.category;
    }
}

