/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.modelmbean;

import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import org.jboss.mx.interceptor.MBeanAttributeInterceptor;
import org.jboss.mx.interceptor.ObjectReferenceInterceptor;
import org.jboss.mx.interceptor.PersistenceInterceptor;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.persistence.NullPersistence;
import org.jboss.mx.persistence.PersistenceManager;
import org.jboss.mx.server.MBeanInvoker;

public abstract class ModelBase
extends MBeanInvoker
implements ModelMBean,
ModelMBeanConstants,
MBeanRegistration {
    protected String resourceType = null;
    protected PersistenceManager persistence = new NullPersistence();
    protected NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    protected long notifierSequence = 1L;
    protected long attrNotifierSequence = 1L;

    public ModelBase() {
    }

    public ModelBase(ModelMBeanInfo info) throws MBeanException {
        this.setModelMBeanInfo(info);
        try {
            this.load();
        }
        catch (InstanceNotFoundException e) {
            throw new MBeanException(e);
        }
    }

    public abstract boolean isSupportedResourceType(String var1);

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new IllegalArgumentException("MBeanInfo cannot be null.");
        }
        this.info = new ModelMBeanInfoSupport(info);
    }

    public void setManagedResource(Object ref, String resourceType) throws MBeanException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (ref == null) {
            throw new IllegalArgumentException("Resource reference cannot be null.");
        }
        if (!this.isSupportedResourceType(resourceType)) {
            throw new InvalidTargetObjectTypeException("Unsupported resource type: " + resourceType);
        }
        this.resource = ref;
        this.resourceType = resourceType;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException {
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute(attributeName);
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    public void sendNotification(String message) throws MBeanException {
        Notification notif = new Notification("jmx.modelmbean.generic", (Object)this, ++this.notifierSequence, message);
        this.sendNotification(notif);
    }

    public void sendNotification(Notification notification) throws MBeanException {
        this.notifier.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException {
        this.notifier.sendNotification(notification);
    }

    public void sendAttributeChangeNotification(Attribute oldValue, Attribute newValue) throws MBeanException {
        String attr = oldValue.getName();
        String type = ((ModelMBeanInfo)((Object)this.info)).getAttribute(attr).getType();
        AttributeChangeNotification notif = new AttributeChangeNotification(this, ++this.attrNotifierSequence, System.currentTimeMillis(), "" + attr + " changed from " + oldValue + " to " + newValue, attr, type, oldValue.getValue(), newValue.getValue());
        this.notifier.sendNotification(notif);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        throw new Error("NYI");
    }

    public void load() throws MBeanException, InstanceNotFoundException {
        if (this.info == null) {
            return;
        }
        this.persistence.load(this.info);
    }

    public void store() throws MBeanException, InstanceNotFoundException {
        this.persistence.store(this.info);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ModelMBeanInfoSupport infoSupport = (ModelMBeanInfoSupport)this.info;
        this.stack = new PersistenceInterceptor(server, this, infoSupport.getDescriptors(ModelMBeanConstants.ALL_DESCRIPTORS));
        this.stack.insertLast(new MBeanAttributeInterceptor(infoSupport, this));
        this.stack.insertLast(new ObjectReferenceInterceptor(this.resource, infoSupport));
        return name;
    }

    public void postRegister(Boolean registrationSuccessful) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

