/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.capability.DispatcherFactory;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.logging.Logger;
import org.jboss.mx.metadata.MBeanCapability;
import org.jboss.mx.server.ServerObjectInstance;
import org.jboss.mx.server.registry.MBeanEntry;
import org.jboss.mx.server.registry.MBeanRegistry;

public class BasicMBeanRegistry
implements MBeanRegistry {
    private Map domainMap = new HashMap();
    private String defaultDomain;
    private MBeanServer server = null;
    private MBeanServerDelegate delegate = null;
    private LoaderRepository loaderRepository = LoaderRepository.getDefaultLoaderRepository();
    private long registrationNotificationSequence = 1L;
    private long unregistrationNotificationSequence = 1L;
    private static Logger log = Logger.getLogger(class$org$jboss$mx$server$registry$BasicMBeanRegistry == null ? (class$org$jboss$mx$server$registry$BasicMBeanRegistry = BasicMBeanRegistry.class$("org.jboss.mx.server.registry.BasicMBeanRegistry")) : class$org$jboss$mx$server$registry$BasicMBeanRegistry);
    static /* synthetic */ Class class$org$jboss$mx$server$registry$BasicMBeanRegistry;

    public BasicMBeanRegistry(MBeanServer server, String defaultDomain) {
        this.server = server;
        this.defaultDomain = defaultDomain;
        try {
            this.delegate = new MBeanServerDelegate();
            this.registerMBean(this.delegate, new ObjectName("JMImplementation:type=MBeanServerDelegate"), null, "JMImplementation");
        }
        catch (MalformedObjectNameException e) {
            throw new Error("Cannot create MBean Server Delegate.");
        }
        catch (InstanceAlreadyExistsException e) {
            throw new Error("Cannot register the MBean Server Delegate.");
        }
        catch (MBeanRegistrationException e) {
            throw new Error("Exception registering the the MBean Server Delegate: " + e.getTargetException().toString());
        }
        catch (NotCompliantMBeanException e) {
            throw new Error("MBean Server Delegate is not a compliant MBean");
        }
        try {
            String loaderClassMBeanName = this.loaderRepository.getClass().getName() + "MBean";
            ClassLoader cl = this.loaderRepository.getClass().getClassLoader();
            Class<?> mbean = cl.loadClass(loaderClassMBeanName);
            ObjectName loaderName = new ObjectName("JMImplementation:service=LoaderRepository,name=Default");
            this.registerMBean(this.loaderRepository, loaderName, null, "JMImplementation");
        }
        catch (Exception e) {
            System.out.println("problem with mbean loader rep.");
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectInstance registerMBean(Object object, ObjectName name, ClassLoader cl, Object magicToken) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        boolean registrationDone = true;
        ObjectName regName = name;
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null object"));
        }
        MBeanCapability mbcap = MBeanCapability.of(object.getClass());
        MBeanRegistration registrationInterface = null;
        if (object instanceof MBeanRegistration) {
            registrationInterface = (MBeanRegistration)object;
        }
        try {
            ServerObjectInstance serverObjectInstance;
            try {
                if (null != registrationInterface) {
                    if (regName != null) {
                        regName = this.qualifyName(regName);
                    }
                    try {
                        ObjectName mbean = registrationInterface.preRegister(this.server, regName);
                        if (regName == null) {
                            regName = mbean;
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof MBeanRegistrationException)) throw new MBeanRegistrationException(e, "preRegister() failed [ObjectName='" + name + "', Class=" + object.getClass().getName() + " (" + object + ")]");
                        throw e;
                    }
                    catch (Throwable t) {
                        log.warn("preRegister() failed for " + name + ": ", t);
                        throw t;
                    }
                }
                regName = this.validateAndQualifyName(regName, (String)magicToken);
                try {
                    DynamicMBean invoker = null;
                    invoker = mbcap.getMBeanType() == 291 ? DispatcherFactory.create(mbcap.getStandardMBeanInfo(), object) : (DynamicMBean)object;
                    MBeanEntry entry = new MBeanEntry(regName, invoker, object, cl);
                    this.add(entry);
                    try {
                        if (object instanceof ClassLoader) {
                            this.loaderRepository.addClassLoader((ClassLoader)object);
                        }
                        try {
                            this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.registered", (Object)this.delegate, this.registrationNotificationSequence++, regName));
                            serverObjectInstance = new ServerObjectInstance(regName, entry.getResourceClassName(), this.delegate.getMBeanServerId());
                            Object var15_21 = null;
                            if (registrationInterface == null) return serverObjectInstance;
                        }
                        catch (Throwable t) {
                            if (!(object instanceof ClassLoader)) throw t;
                            this.loaderRepository.removeClassLoader((ClassLoader)object);
                            throw t;
                        }
                    }
                    catch (Throwable t) {
                        this.remove(regName);
                        throw t;
                    }
                }
                catch (InstanceAlreadyExistsException e) {
                    throw e;
                }
                catch (Throwable t) {
                    log.error("Unexpected Exception:", t);
                    throw t;
                }
            }
            catch (InstanceAlreadyExistsException e) {
                registrationDone = false;
                throw e;
            }
            catch (MBeanRegistrationException e) {
                registrationDone = false;
                log.debug("preRegister() failed [ObjectName='" + name + "', Class=" + object.getClass().getName() + " (" + object + ")]");
                log.debug("Target Exception: ", e.getTargetException());
                throw e;
            }
            catch (RuntimeOperationsException e) {
                registrationDone = false;
                throw e;
            }
            catch (Throwable t) {
                registrationDone = false;
                ObjectInstance objectInstance = null;
                Object var15_22 = null;
                if (registrationInterface == null) return objectInstance;
                registrationInterface.postRegister(new Boolean(registrationDone));
                return objectInstance;
            }
            registrationInterface.postRegister(new Boolean(registrationDone));
            return serverObjectInstance;
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            if (registrationInterface == null) throw throwable;
            registrationInterface.postRegister(new Boolean(registrationDone));
            throw throwable;
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if ((name = this.qualifyName(name)).getDomain().equals("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Not allowed to unregister: " + name.toString()));
        }
        MBeanEntry entry = this.get(name);
        Object resource = entry.getResourceInstance();
        MBeanRegistration registrationInterface = null;
        if (resource instanceof MBeanRegistration) {
            registrationInterface = (MBeanRegistration)resource;
            try {
                registrationInterface.preDeregister();
            }
            catch (Exception e) {
                if (e instanceof MBeanRegistrationException) {
                    e.fillInStackTrace();
                    throw (MBeanRegistrationException)e;
                }
                throw new MBeanRegistrationException(e, "preDeregister");
            }
        }
        if (resource instanceof ClassLoader) {
            this.loaderRepository.removeClassLoader((ClassLoader)resource);
        }
        this.remove(name);
        this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.unregistered", (Object)this.delegate, this.unregistrationNotificationSequence++, name));
        if (registrationInterface != null) {
            registrationInterface.postDeregister();
        }
    }

    public synchronized MBeanEntry get(ObjectName name) throws InstanceNotFoundException {
        Object o;
        block6: {
            block5: {
                if (name == null) {
                    throw new InstanceNotFoundException("null object name");
                }
                String domain = name.getDomain();
                if (domain.length() == 0) {
                    domain = this.defaultDomain;
                }
                String props = name.getCanonicalKeyPropertyListString();
                Map mbeanMap = (Map)this.domainMap.get(domain);
                o = null;
                if (null == mbeanMap) break block5;
                Object v = mbeanMap.get(props);
                o = v;
                if (null != v) break block6;
            }
            throw new InstanceNotFoundException(name + " is not registered.");
        }
        return o;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public synchronized ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (!this.contains(name)) {
            throw new InstanceNotFoundException(name + " not registered.");
        }
        return new ServerObjectInstance(this.qualifyName(name), this.get(name).getResourceClassName(), this.delegate.getMBeanServerId());
    }

    public synchronized boolean contains(ObjectName name) {
        String domain = name.getDomain();
        if (domain.length() == 0) {
            domain = this.defaultDomain;
        }
        String props = name.getCanonicalKeyPropertyListString();
        Map mbeanMap = (Map)this.domainMap.get(domain);
        return null != mbeanMap && mbeanMap.containsKey(props);
    }

    public synchronized int getSize() {
        int retval = 0;
        Iterator iterator = this.domainMap.values().iterator();
        while (iterator.hasNext()) {
            retval += ((Map)iterator.next()).size();
        }
        return retval;
    }

    public synchronized List findEntries(ObjectName pattern) {
        ArrayList<Object> retval = new ArrayList<Object>();
        if (pattern == null || pattern.getCanonicalName().equals("*:*")) {
            Iterator domainIter = this.domainMap.values().iterator();
            while (domainIter.hasNext()) {
                Iterator mbeanIter = ((Map)domainIter.next()).values().iterator();
                while (mbeanIter.hasNext()) {
                    retval.add(mbeanIter.next());
                }
            }
        } else if (!pattern.isPattern()) {
            try {
                retval.add(this.get(pattern));
            }
            catch (InstanceNotFoundException e) {}
        } else {
            String patternDomain = pattern.getDomain();
            if (patternDomain.length() == 0) {
                patternDomain = this.defaultDomain;
            }
            boolean patternIsPropertyPattern = pattern.isPropertyPattern();
            String patternCanonicalKPS = pattern.getCanonicalKeyPropertyListString();
            Object[] propkeys = null;
            Object[] propvals = null;
            if (patternIsPropertyPattern) {
                Hashtable patternKPList = pattern.getKeyPropertyList();
                propkeys = new Object[patternKPList.size()];
                propvals = new Object[propkeys.length];
                int i = 0;
                Iterator iterator = patternKPList.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    propkeys[i] = mapEntry.getKey();
                    propvals[i] = mapEntry.getValue();
                    ++i;
                }
            }
            Iterator domainIter = this.domainMap.entrySet().iterator();
            while (domainIter.hasNext()) {
                Map.Entry mapEntry = domainIter.next();
                if (!this.domainMatches((String)mapEntry.getKey(), patternDomain)) continue;
                Iterator mbeanIter = ((Map)mapEntry.getValue()).values().iterator();
                block6: while (mbeanIter.hasNext()) {
                    MBeanEntry entry = (MBeanEntry)mbeanIter.next();
                    ObjectName name = entry.getObjectName();
                    if (patternIsPropertyPattern) {
                        if (propkeys.length > 0) {
                            Hashtable nameKPList = name.getKeyPropertyList();
                            int i = 0;
                            while (i < propkeys.length) {
                                if (!propvals[i].equals(nameKPList.get(propkeys[i]))) continue block6;
                                ++i;
                            }
                        }
                        retval.add(entry);
                        continue;
                    }
                    if (!patternCanonicalKPS.equals(name.getCanonicalKeyPropertyListString())) continue;
                    retval.add(entry);
                }
            }
        }
        return retval;
    }

    protected boolean domainMatches(String src, String pat) {
        if (src.equals("*")) {
            return true;
        }
        return this.domainMatches(src.toCharArray(), 0, pat.toCharArray(), 0);
    }

    protected boolean domainMatches(char[] src, int spos, char[] pat, int ppos) {
        int slen = src.length;
        int plen = pat.length;
        while (ppos < plen) {
            char c;
            if ('?' == (c = pat[ppos++])) {
                if (spos++ != slen) continue;
                return false;
            }
            if ('*' == c) {
                if (ppos == plen) {
                    return true;
                }
                do {
                    if (!this.domainMatches(src, spos, pat, ppos)) continue;
                    return true;
                } while (++spos < slen);
                continue;
            }
            if (spos != slen && c == src[spos++]) continue;
            return false;
        }
        return spos == slen;
    }

    protected synchronized void add(MBeanEntry entry) throws InstanceAlreadyExistsException {
        ObjectName name = entry.getObjectName();
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        HashMap<String, MBeanEntry> mbeanMap = (HashMap<String, MBeanEntry>)this.domainMap.get(domain);
        if (mbeanMap == null) {
            mbeanMap = new HashMap<String, MBeanEntry>();
            this.domainMap.put(domain, mbeanMap);
        }
        if (mbeanMap.get(props) != null) {
            throw new InstanceAlreadyExistsException(name + " already registered.");
        }
        mbeanMap.put(props, entry);
    }

    protected synchronized void remove(ObjectName name) throws InstanceNotFoundException {
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        Map mbeanMap = (Map)this.domainMap.get(domain);
        if (null == mbeanMap || null == mbeanMap.remove(props)) {
            throw new InstanceNotFoundException(name + " not registered.");
        }
    }

    protected ObjectName validateAndQualifyName(ObjectName name, String magicToken) {
        ObjectName result = this.qualifyName(name);
        if (result.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name is a pattern:" + name));
        }
        if (magicToken != "JMImplementation" && result.getDomain().equals("JMImplementation")) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Domain JMImplementation is reserved"));
        }
        return result;
    }

    protected ObjectName qualifyName(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null object name"));
        }
        try {
            if (name.getDomain().length() == 0) {
                return new ObjectName(this.defaultDomain + ":" + name.getCanonicalKeyPropertyListString());
            }
            return name;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeOperationsException(new IllegalArgumentException(e.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

