/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class ForwardGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    String page;
    boolean isExpression = false;
    Hashtable params;
    boolean isXml;

    public ForwardGenerator(Mark start, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        if (attrs.getLength() != 1) {
            throw new JasperException(Constants.getString("jsp.error.invalid.forward"));
        }
        this.page = attrs.getValue("page");
        if (this.page == null) {
            throw new CompileException(start, Constants.getString("jsp.error.invalid.forward"));
        }
        this.params = param;
        this.isXml = isXml;
        this.isExpression = JspUtil.isExpression(this.page, isXml);
    }

    public void generate(ServletWriter writer, Class phase) {
        int sep = 63;
        writer.println("if (true) {");
        writer.pushIndent();
        writer.println("out.clear();");
        writer.println("String _jspx_qfStr = \"\";");
        if (this.params != null && this.params.size() > 0) {
            Enumeration en = this.params.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String[] value = (String[])this.params.get(key);
                int i = 0;
                while (i < value.length) {
                    String v = JspUtil.isExpression(value[i], this.isXml) ? JspUtil.getExpr(value[i], this.isXml) : "\"" + URLEncoder.encode(value[i]) + "\"";
                    writer.println("_jspx_qfStr = _jspx_qfStr + \"" + (char)sep + key + "=\" +" + v + ";");
                    sep = 38;
                    ++i;
                }
            }
        }
        if (!this.isExpression) {
            writer.println("pageContext.forward(" + writer.quoteString(this.page) + " +  _jspx_qfStr);");
        } else {
            writer.println("pageContext.forward(" + JspUtil.getExpr(this.page, this.isXml) + " +  _jspx_qfStr);");
        }
        writer.println("return;");
        writer.popIndent();
        writer.println("}");
    }
}

