/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class JspReader {
    protected Mark current = null;
    String master = null;
    Vector sourceFiles = new Vector();
    int currFileId = 0;
    int size = 0;
    private JspCompilationContext context;
    boolean singleFile = false;
    Logger.Helper loghelper = new Logger.Helper("JASPER_LOG", "JspReader");

    public String getFile(int fileid) {
        return (String)this.sourceFiles.elementAt(fileid);
    }

    protected int registerSourceFile(String file) {
        if (this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.addElement(file);
        ++this.size;
        return this.sourceFiles.size() - 1;
    }

    protected int unregisterSourceFile(String file) {
        if (!this.sourceFiles.contains(file)) {
            return -1;
        }
        this.sourceFiles.removeElement(file);
        --this.size;
        return this.sourceFiles.size() - 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void pushFile2(String file, String encoding, InputStreamReader reader) throws ParseException, FileNotFoundException {
        String longName = file;
        int fileid = this.registerSourceFile(longName);
        if (fileid == -1) {
            throw new ParseException(Constants.getString("jsp.error.file.already.registered", new Object[]{file}));
        }
        this.currFileId = fileid;
        try {
            block11: {
                try {
                    CharArrayWriter caw = new CharArrayWriter();
                    char[] buf = new char[1024];
                    int i = 0;
                    while (true) {
                        if ((i = reader.read(buf)) == -1) {
                            caw.close();
                            if (this.current != null) break;
                            this.current = new Mark(this, caw.toCharArray(), fileid, this.getFile(fileid), this.master, encoding);
                            break block11;
                        }
                        caw.write(buf, 0, i);
                    }
                    this.current.pushStream(caw.toCharArray(), fileid, this.getFile(fileid), longName, encoding);
                }
                catch (Throwable ex) {
                    this.loghelper.log("Exception parsing file ", ex);
                    this.popFile();
                    throw new ParseException(Constants.getString("jsp.error.file.cannot.read", new Object[]{new String("ze file")}));
                }
            }
            Object var10_10 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (Exception any) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception any) {}
        reader.close();
        return;
    }

    public boolean popFile() throws ParseException {
        if (this.current == null) {
            return false;
        }
        if (this.currFileId < 0) {
            throw new ParseException(Constants.getString("jsp.error.no.more.content"));
        }
        String fName = this.getFile(this.currFileId);
        this.currFileId = this.unregisterSourceFile(fName);
        if (this.currFileId < -1) {
            throw new ParseException(Constants.getString("jsp.error.file.not.registered", new Object[]{fName}));
        }
        boolean result = this.current.popStream();
        if (result) {
            this.master = this.current.baseDir;
        }
        return result;
    }

    protected JspReader(JspCompilationContext ctx, String file, String encoding, InputStreamReader reader) throws ParseException, FileNotFoundException {
        this.context = ctx;
        this.pushFile2(file, encoding, reader);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasMoreInput() throws ParseException {
        block1: {
            if (this.current.cursor < this.current.stream.length) break block1;
            if (!this.singleFile) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                if (this.current.cursor >= this.current.stream.length) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.popFile())
            }
lbl7:
            // 1 sources

            return false;
        }
        return true;
    }

    public int nextChar() throws ParseException {
        if (!this.hasMoreInput()) {
            return -1;
        }
        char ch = this.current.stream[this.current.cursor];
        ++this.current.cursor;
        if (ch == '\n') {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        return ch;
    }

    /*
     * WARNING - void declaration
     */
    String nextContent() {
        char ch;
        int cur_cursor = this.current.cursor;
        int len = this.current.stream.length;
        if (this.peekChar() == 10) {
            ++this.current.line;
            this.current.col = 0;
        } else {
            ++this.current.col;
        }
        while (++this.current.cursor < len && (ch = this.current.stream[this.current.cursor]) != '<') {
            void var3_3;
            if (var3_3 == 10) {
                ++this.current.line;
                this.current.col = 0;
                continue;
            }
            ++this.current.col;
        }
        return new String(this.current.stream, cur_cursor, this.current.cursor - cur_cursor);
    }

    char[] getChars(Mark start, Mark stop) throws ParseException {
        Mark oldstart = this.mark();
        this.reset(start);
        CharArrayWriter caw = new CharArrayWriter();
        while (!stop.equals(this.mark())) {
            caw.write(this.nextChar());
        }
        caw.close();
        this.reset(oldstart);
        return caw.toCharArray();
    }

    public int peekChar() {
        return this.current.stream[this.current.cursor];
    }

    public Mark mark() {
        return new Mark(this.current);
    }

    public void reset(Mark mark) {
        this.current = new Mark(mark);
    }

    public boolean matchesIgnoreCase(String string) throws ParseException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if (Character.toLowerCase((char)(ch = this.nextChar())) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public boolean matches(String string) throws ParseException {
        Mark mark = this.mark();
        int ch = 0;
        int i = 0;
        do {
            if ((char)(ch = this.nextChar()) == string.charAt(i++)) continue;
            this.reset(mark);
            return false;
        } while (i < string.length());
        this.reset(mark);
        return true;
    }

    public void advance(int n) throws ParseException {
        while (--n >= 0) {
            this.nextChar();
        }
    }

    public int skipSpaces() throws ParseException {
        int i = 0;
        while (this.isSpace()) {
            ++i;
            this.nextChar();
        }
        return i;
    }

    public Mark skipUntil(String limit) throws ParseException {
        Mark ret = null;
        int limlen = limit.length();
        ret = this.mark();
        int ch = this.nextChar();
        while (ch != -1) {
            block4: {
                if (ch == limit.charAt(0)) {
                    int i = 1;
                    while (i < limlen) {
                        if (Character.toLowerCase((char)this.nextChar()) == limit.charAt(i)) {
                            ++i;
                            continue;
                        }
                        break block4;
                    }
                    return ret;
                }
            }
            ret = this.mark();
            ch = this.nextChar();
        }
        return null;
    }

    final boolean isSpace() {
        return this.peekChar() <= 32;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String parseToken(boolean quoted) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipSpaces();
        stringBuffer.setLength(0);
        int ch = this.peekChar();
        if (quoted) {
            if (ch != 34 && ch != 39) throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.quoted"));
            int endQuote = ch == 34 ? 34 : 39;
            ch = this.nextChar();
            ch = this.nextChar();
            while (ch != -1 && ch != endQuote) {
                if (ch == 92) {
                    ch = this.nextChar();
                }
                stringBuffer.append((char)ch);
                ch = this.nextChar();
            }
            if (ch != -1) return stringBuffer.toString();
            throw new ParseException(this.mark(), Constants.getString("jsp.error.quotes.unterminated"));
        }
        if (this.isDelimiter()) return stringBuffer.toString();
        do {
            if ((ch = this.nextChar()) == 92 && (this.peekChar() == 34 || this.peekChar() == 39 || this.peekChar() == 62 || this.peekChar() == 37)) {
                ch = this.nextChar();
            }
            stringBuffer.append((char)ch);
        } while (!this.isDelimiter());
        return stringBuffer.toString();
    }

    private void parseAttributeValue(AttributesImpl into) throws ParseException {
        this.skipSpaces();
        String name = this.parseToken(false);
        this.skipSpaces();
        if (this.peekChar() != 61) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.attr.novalue", new Object[]{name}));
        }
        char ch = (char)this.nextChar();
        this.skipSpaces();
        String value = this.parseToken(true);
        this.skipSpaces();
        into.addAttribute("", name, name, "CDATA", value);
    }

    public Attributes parseTagAttributesBean() throws ParseException {
        AttributesImpl values = new AttributesImpl();
        while (true) {
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == 62) {
                return values;
            }
            if (ch == 47) {
                Object var6_4;
                Mark mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        AttributesImpl attributesImpl = values;
                        var6_4 = null;
                        this.reset(mark);
                        return attributesImpl;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public Attributes parseTagAttributes() throws ParseException {
        AttributesImpl values = new AttributesImpl();
        while (true) {
            Mark mark;
            this.skipSpaces();
            int ch = this.peekChar();
            if (ch == 62) {
                return values;
            }
            if (ch == 45) {
                Object var6_4;
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 45 && this.nextChar() == 62) {
                        AttributesImpl attributesImpl = values;
                        var6_4 = null;
                        this.reset(mark);
                        return attributesImpl;
                    }
                    var6_4 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var6_4 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch == 37) {
                Object var8_5;
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        AttributesImpl attributesImpl = values;
                        var8_5 = null;
                        this.reset(mark);
                        return attributesImpl;
                    }
                    var8_5 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var8_5 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch == 47) {
                Object var10_6;
                mark = this.mark();
                this.nextChar();
                try {
                    if (this.nextChar() == 62) {
                        AttributesImpl attributesImpl = values;
                        var10_6 = null;
                        this.reset(mark);
                        return attributesImpl;
                    }
                    var10_6 = null;
                    this.reset(mark);
                }
                catch (Throwable throwable) {
                    var10_6 = null;
                    this.reset(mark);
                    throw throwable;
                }
            }
            if (ch == -1) break;
            this.parseAttributeValue(values);
        }
        throw new ParseException(this.mark(), Constants.getString("jsp.error.tag.attr.unterminated"));
    }

    public void parseParamTag(Hashtable into) throws ParseException {
        if (this.matches("param")) {
            this.advance(6);
            this.parseParams(into);
        }
    }

    public void parsePluginParamTag(Hashtable into) throws ParseException {
        if (this.matches("<jsp:param")) {
            this.advance(11);
            this.parseParams(into);
        }
    }

    private void parseParams(Hashtable into) throws ParseException {
        Attributes attrs = this.parseTagAttributes();
        String name = attrs.getValue("name");
        String value = attrs.getValue("value");
        if (name == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.noname"));
        }
        if (value == null) {
            throw new ParseException(this.mark(), Constants.getString("jsp.error.param.novalue"));
        }
        String[] oldval = (String[])into.get(name);
        if (oldval == null) {
            String[] newval = new String[]{value};
            into.put(name, newval);
        } else {
            String[] newval = new String[oldval.length + 1];
            System.arraycopy(oldval, 0, newval, 0, oldval.length);
            newval[oldval.length] = value;
            into.put(name, newval);
        }
    }

    private boolean isDelimiter() throws ParseException {
        if (!this.isSpace()) {
            int ch = this.peekChar();
            if (ch == 61 || ch == 62 || ch == 34 || ch == 39 || ch == 47) {
                return true;
            }
            if (ch == 45) {
                Mark mark = this.mark();
                ch = this.nextChar();
                if (ch == 62 || ch == 45 && this.nextChar() == 62) {
                    this.reset(mark);
                    return true;
                }
                this.reset(mark);
                return false;
            }
            return false;
        }
        return true;
    }

    public void setSingleFile(boolean val) {
        this.singleFile = val;
    }
}

