/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserXJspSaxHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ParserXJspSax {
    private InputSource is;
    private String filePath;
    private ParseEventListener jspHandler;
    private static final boolean validate = false;
    static final String[] lexicalHandlerPropNames = new String[]{"http://xml.org/sax/handlers/LexicalHandler", "http://xml.org/sax/properties/lexical-handler"};

    public ParserXJspSax(String filePath, InputStreamReader reader, ParseEventListener jspHandler) {
        this.filePath = filePath;
        this.is = new InputSource(reader);
        this.jspHandler = jspHandler;
    }

    public void parse() throws JasperException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            ParserXJspSaxHandler handler = new ParserXJspSaxHandler(this.filePath, this.jspHandler);
            parser.setContentHandler(handler);
            parser.setEntityResolver(handler);
            parser.setDTDHandler(handler);
            parser.setErrorHandler(handler);
            int i = 0;
            while (i < lexicalHandlerPropNames.length) {
                if (this.setSaxProperty(parser, handler, lexicalHandlerPropNames[i])) break;
                ++i;
            }
            try {
                parser.setFeature("http://xml.org/sax/features/validation", false);
                parser.setFeature("http://xml.org/sax/features/namespaces", false);
                parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotSupportedException ex) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotsupported", new Object[]{ex.getMessage()}));
            }
            catch (SAXNotRecognizedException ex) {
                throw new JasperException(Constants.getString("jsp.parser.sax.featurenotrecognized", new Object[]{ex.getMessage()}));
            }
            parser.parse(this.is);
        }
        catch (IOException ex) {
            throw new JasperException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException(ex.getMessage());
        }
        catch (SAXParseException ex) {
            Mark mark = new Mark(this.filePath, ex.getLineNumber(), ex.getColumnNumber());
            String reason = ex.getException() != null ? ex.getException().getMessage() : ex.getMessage();
            throw new ParseException(mark, reason);
        }
        catch (SAXException ex) {
            Exception ex2 = ex;
            if (ex.getException() != null) {
                ex2 = ex.getException();
            }
            throw new JasperException(ex2);
        }
    }

    private boolean setSaxProperty(XMLReader parser, DefaultHandler handler, String propName) {
        try {
            parser.setProperty(propName, handler);
            return true;
        }
        catch (SAXNotSupportedException ex) {
            Constants.message("jsp.parser.sax.propertynotsupported", new Object[]{ex.getMessage()}, 2);
            return false;
        }
        catch (SAXNotRecognizedException ex) {
            Constants.message("jsp.parser.sax.propertynotrecognized", new Object[]{ex.getMessage()}, 2);
            return false;
        }
    }
}

