/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.management.jmx.Introspector;
import java.io.Serializable;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.relation.InvalidRoleInfoException;

public class RoleInfo
implements Serializable {
    public static int ROLE_CARDINALITY_INFINITY = -1;
    private String myName = null;
    private boolean myIsReadableFlg;
    private boolean myIsWritableFlg;
    private String myDescription = null;
    private int myMinDegree;
    private int myMaxDegree;
    private String myRefMBeanClassName = null;

    public RoleInfo(String string, String string2) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(string, string2, true, true, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {}
    }

    public RoleInfo(String string, String string2, boolean bl, boolean bl2) throws IllegalArgumentException, ClassNotFoundException, NotCompliantMBeanException {
        try {
            this.init(string, string2, bl, bl2, 1, 1, null);
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {}
    }

    public RoleInfo(String string, String string2, boolean bl, boolean bl2, int n, int n2, String string3) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        this.init(string, string2, bl, bl2, n, n2, string3);
    }

    public RoleInfo(RoleInfo roleInfo) throws IllegalArgumentException {
        if (roleInfo == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        try {
            this.init(roleInfo.getName(), roleInfo.getRefMBeanClassName(), roleInfo.isReadable(), roleInfo.isWritable(), roleInfo.getMinDegree(), roleInfo.getMaxDegree(), roleInfo.getDescription());
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvalidRoleInfoException invalidRoleInfoException) {}
    }

    public boolean checkMaxDegree(int n) {
        return n >= ROLE_CARDINALITY_INFINITY && (this.myMaxDegree == ROLE_CARDINALITY_INFINITY || n != ROLE_CARDINALITY_INFINITY && n <= this.myMaxDegree);
    }

    public boolean checkMinDegree(int n) {
        return n >= ROLE_CARDINALITY_INFINITY && (this.myMinDegree == ROLE_CARDINALITY_INFINITY || n >= this.myMinDegree);
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int getMaxDegree() {
        return this.myMaxDegree;
    }

    public int getMinDegree() {
        return this.myMinDegree;
    }

    public String getName() {
        return this.myName;
    }

    public String getRefMBeanClassName() {
        return this.myRefMBeanClassName;
    }

    private void init(String string, String string2, boolean bl, boolean bl2, int n, int n2, String string3) throws IllegalArgumentException, InvalidRoleInfoException, ClassNotFoundException, NotCompliantMBeanException {
        if (string == null || string2 == null) {
            String string4 = "Invalid parameter.";
            throw new IllegalArgumentException(string4);
        }
        this.myName = new String(string);
        this.myIsReadableFlg = bl;
        this.myIsWritableFlg = bl2;
        if (string3 != null) {
            this.myDescription = new String(string3);
        }
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 != ROLE_CARDINALITY_INFINITY && (n == ROLE_CARDINALITY_INFINITY || n > n2)) {
            stringBuffer.append("Minimum degree ");
            stringBuffer.append(n);
            stringBuffer.append(" is greater than maximum degree ");
            stringBuffer.append(n2);
            bl3 = true;
        } else if (n < ROLE_CARDINALITY_INFINITY || n2 < ROLE_CARDINALITY_INFINITY) {
            stringBuffer.append("Minimum or maximum degree has an illegal value, must be [0, ROLE_CARDINALITY_INFINITY].");
            bl3 = true;
        }
        if (bl3) {
            throw new InvalidRoleInfoException(stringBuffer.toString());
        }
        this.myMinDegree = n;
        this.myMaxDegree = n2;
        Class<?> clazz = Class.forName(string2);
        MBeanInfo mBeanInfo = Introspector.testCompliance(clazz);
        this.myRefMBeanClassName = new String(string2);
    }

    public boolean isReadable() {
        return this.myIsReadableFlg;
    }

    public boolean isWritable() {
        return this.myIsWritableFlg;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("role info name: " + this.myName);
        stringBuffer.append("; isReadable: " + this.myIsReadableFlg);
        stringBuffer.append("; isWritable: " + this.myIsWritableFlg);
        stringBuffer.append("; description: " + this.myDescription);
        stringBuffer.append("; minimum degree: " + this.myMinDegree);
        stringBuffer.append("; maximum degree: " + this.myMaxDegree);
        stringBuffer.append("; MBean class: " + this.myRefMBeanClassName);
        return stringBuffer.toString();
    }
}

