/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEServerMBean;

public class J2EEServer
extends J2EEManagedObject
implements J2EEServerMBean {
    public static final String J2EE_TYPE = "J2EEServer";
    private List mDeployedObjects = new ArrayList();
    private List mResources = new ArrayList();
    private List mJVMs = new ArrayList();
    private String mServerVendor = null;
    private String mServerVersion = null;
    protected static boolean sIsActive = false;

    public J2EEServer(String pName, ObjectName pDomain, String pServerVendor, String pServerVersion) throws MalformedObjectNameException, InvalidParentException {
        super(J2EE_TYPE, pName, pDomain);
        this.mServerVendor = pServerVendor;
        this.mServerVersion = pServerVersion;
    }

    public ObjectName[] getDeployedObjects() {
        return this.mDeployedObjects.toArray(new ObjectName[0]);
    }

    public ObjectName getDeployedObject(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mDeployedObjects.size()) {
            return (ObjectName)this.mDeployedObjects.get(pIndex);
        }
        return null;
    }

    public ObjectName[] getResources() {
        return this.mResources.toArray(new ObjectName[0]);
    }

    public ObjectName getResource(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mResources.size()) {
            return (ObjectName)this.mResources.get(pIndex);
        }
        return null;
    }

    public ObjectName[] getJavaVMs() {
        return this.mJVMs.toArray(new ObjectName[0]);
    }

    public ObjectName getJavaVM(int pIndex) {
        if (pIndex >= 0 && pIndex < this.mJVMs.size()) {
            return (ObjectName)this.mJVMs.get(pIndex);
        }
        return null;
    }

    public String getServerVendor() {
        return this.mServerVendor;
    }

    public String getServerVersion() {
        return this.mServerVersion;
    }

    public void addChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType)) {
            this.mDeployedObjects.add(pChild);
        } else if ("JVM".equals(lType)) {
            this.mJVMs.add(pChild);
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JTAResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "RMI_IIOPResource".equals(lType) || "JCAResource".equals(lType)) {
            this.mResources.add(pChild);
        }
    }

    public void removeChild(ObjectName pChild) {
        String lType = J2EEManagedObject.getType(pChild);
        if ("J2EEApplication".equals(lType) || "EJBModule".equals(lType) || "ResourceAdapterModule".equals(lType) || "WebModule".equals(lType)) {
            this.mDeployedObjects.remove(pChild);
        } else if ("JVM".equals(lType)) {
            this.mJVMs.remove(pChild);
        } else if ("JNDIResource".equals(lType) || "JMSResource".equals(lType) || "URLResource".equals(lType) || "JTAResource".equals(lType) || "JavaMailResource".equals(lType) || "JDBCResource".equals(lType) || "RMI_IIOPResource".equals(lType) || "JCAResource".equals(lType)) {
            this.mResources.remove(pChild);
        }
    }

    public String toString() {
        return "J2EEServer { " + super.toString() + " } [ " + "depoyed objects: " + this.mDeployedObjects + ", resources: " + this.mResources + ", JVMs: " + this.mJVMs + ", J2EE vendor: " + this.mServerVendor + " ]";
    }
}

