/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.JumpInstruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LookupSwitchInstruction
extends JumpInstruction {
    private List _matches = new LinkedList();
    private List _offsets = new LinkedList();
    private List _targets = new LinkedList();

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public void setDefaultTarget(Instruction instruction) {
        this.setTarget(instruction);
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public void setDefaultOffset(int n) {
        this.setOffset(n);
    }

    public void setCases(int[] nArray, Instruction[] instructionArray) {
        int n;
        this._matches.clear();
        this._targets.clear();
        this._offsets.clear();
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                this._matches.add(new Integer(nArray[n]));
                ++n;
            }
        }
        if (instructionArray != null) {
            n = 0;
            while (n < instructionArray.length) {
                this._targets.add(instructionArray[n]);
                ++n;
            }
        }
    }

    public void setCases(int[] nArray, int[] nArray2) {
        int n;
        this._matches.clear();
        this._targets.clear();
        this._offsets.clear();
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                this._matches.add(new Integer(nArray[n]));
                ++n;
            }
        }
        if (nArray2 != null) {
            n = 0;
            while (n < nArray2.length) {
                this._offsets.add(new Integer(nArray2[n]));
                ++n;
            }
        }
    }

    public int[] getMatches() {
        int[] nArray = new int[this._matches.size()];
        Iterator iterator = this._matches.iterator();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    public Instruction[] getTargets() {
        return this._targets.toArray(new Instruction[this._targets.size()]);
    }

    public int[] getOffsets() {
        Object object;
        if (this._targets.size() > 0) {
            this._offsets.clear();
            object = this._targets.iterator();
            while (object.hasNext()) {
                this._offsets.add(new Integer(((Instruction)object.next()).getByteIndex() - this.getByteIndex()));
            }
        }
        object = new int[this._offsets.size()];
        Iterator iterator = this._offsets.iterator();
        int n = 0;
        while (n < ((Object)object).length) {
            object[n] = (Integer)iterator.next();
            ++n;
        }
        return object;
    }

    public void addCase(int n, Instruction instruction) {
        this._matches.add(new Integer(n));
        this._targets.add(instruction);
    }

    public int getLength() {
        int n = 1;
        int n2 = this.getByteIndex() + 1;
        while (n2 % 4 != 0) {
            ++n2;
            ++n;
        }
        n += 8;
        return n += 8 * this._matches.size();
    }

    public int getStackChange() {
        return -1;
    }

    public void readData(DataInput dataInput) throws IOException {
        int n = this.getByteIndex() + 1;
        while (n % 4 != 0) {
            dataInput.readByte();
            ++n;
        }
        this.setOffset(dataInput.readInt());
        this._matches.clear();
        this._offsets.clear();
        this._targets.clear();
        n = 0;
        int n2 = dataInput.readInt();
        while (n < n2) {
            this._matches.add(new Integer(dataInput.readInt()));
            this._offsets.add(new Integer(dataInput.readInt()));
            ++n;
        }
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        int n = this.getByteIndex() + 1;
        while (n % 4 != 0) {
            dataOutput.writeByte(0);
            ++n;
        }
        dataOutput.writeInt(this.getOffset());
        dataOutput.writeInt(this._matches.size());
        int[] nArray = this.getMatches();
        int[] nArray2 = this.getOffsets();
        int n2 = 0;
        while (n2 < nArray.length) {
            dataOutput.writeInt(nArray[n2]);
            dataOutput.writeInt(nArray2[n2]);
            ++n2;
        }
    }

    private Instruction findJumpPoint(int n, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() != n) continue;
            return instruction;
        }
        return null;
    }

    public void setMarkers(List list) {
        super.setMarkers(list);
        this._targets.clear();
        int n = this.getByteIndex();
        Iterator iterator = this._offsets.iterator();
        while (iterator.hasNext()) {
            int n2 = n + ((Number)iterator.next()).intValue();
            this._targets.add(this.findJumpPoint(n2, list));
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLookupSwitchInstruction(this);
        bCVisitor.exitLookupSwitchInstruction(this);
    }

    protected LookupSwitchInstruction(Code code) {
        super(code, 171);
    }
}

