/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.jboss.logging.Log4jServiceMBean;
import org.jboss.logging.Logger;
import org.jboss.logging.XLevel;
import org.jboss.logging.util.CategoryStream;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Strings;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.ThrowableListener;
import org.jboss.util.stream.Streams;

public class Log4jService
extends ServiceMBeanSupport
implements Log4jServiceMBean {
    public static final String DEFAULT_URL = System.getProperty((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".configURL", "resource:log4j.xml");
    public static final boolean CATCH_SYSTEM_OUT = Log4jService.getBoolean((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".catchSystemOut", true);
    public static final boolean CATCH_SYSTEM_ERR = Log4jService.getBoolean((class$org$jboss$logging$Log4jService == null ? (class$org$jboss$logging$Log4jService = Log4jService.class$("org.jboss.logging.Log4jService")) : class$org$jboss$logging$Log4jService).getName() + ".catchSystemErr", true);
    private URL configURL;
    private int refreshPeriod;
    private ThrowableListenerLoggingAdapter throwableAdapter;
    private PrintStream out;
    private PrintStream err;
    private Timer timer = new Timer(true);
    private URLWatchTimerTask timerTask;
    static /* synthetic */ Class class$org$jboss$logging$Log4jService;

    private static boolean getBoolean(String name, boolean defaultValue) {
        String value = System.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return new Boolean(value);
    }

    public Log4jService() throws MalformedURLException {
        this(DEFAULT_URL, 60);
    }

    public Log4jService(URL url) {
        this(url, 60);
    }

    public Log4jService(String url) throws MalformedURLException {
        this(Strings.toURL(url), 60);
    }

    public Log4jService(String url, int refreshPeriod) throws MalformedURLException {
        this(Strings.toURL(url), refreshPeriod);
    }

    public Log4jService(URL url, int refreshPeriod) {
        this.configURL = url;
        this.refreshPeriod = refreshPeriod;
    }

    public int getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setRefreshPeriod(int refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
    }

    public URL getConfigurationURL() {
        return this.configURL;
    }

    public void setConfigurationURL(URL url) {
        this.configURL = url;
    }

    public void setLoggerPriority(String name, String priority) {
        Category c = Category.getInstance(name);
        Priority p = XLevel.toPriority(priority);
        c.setPriority(p);
        this.log.info("Priority set to " + p + " for " + name);
    }

    public String getLoggerPriority(String name) {
        Category c = Category.getInstance(name);
        Level p = c.getPriority();
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public void reconfigure() throws IOException {
        if (this.timerTask == null) {
            throw new IllegalStateException("Service stopped or not started");
        }
        this.timerTask.reconfigure();
    }

    public void reconfigure(String url) throws IOException, MalformedURLException {
        this.setConfigurationURL(Strings.toURL(url));
        this.reconfigure();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name == null ? Log4jServiceMBean.OBJECT_NAME : name;
    }

    protected void startService() throws Exception {
        this.timerTask = new URLWatchTimerTask();
        this.timerTask.run();
        this.timer.schedule((TimerTask)this.timerTask, 1000 * this.refreshPeriod, (long)(1000 * this.refreshPeriod));
        Category category = Category.getRoot();
        this.throwableAdapter = new ThrowableListenerLoggingAdapter();
        ThrowableHandler.addThrowableListener(this.throwableAdapter);
        this.log.debug("Added ThrowableListener: " + this.throwableAdapter);
    }

    private void installSystemAdapters() {
        Category category;
        if (CATCH_SYSTEM_OUT) {
            category = Category.getInstance("STDOUT");
            this.out = System.out;
            System.setOut(new CategoryStream(category, Priority.INFO, this.out));
            this.log.debug("Installed System.out adapter");
        }
        if (CATCH_SYSTEM_ERR) {
            category = Category.getInstance("STDERR");
            this.err = System.err;
            System.setErr(new CategoryStream(category, Priority.ERROR, this.err));
            this.log.debug("Installed System.err adapter");
        }
    }

    private void uninstallSystemAdapters() {
        if (this.out != null) {
            System.out.flush();
            System.setOut(this.out);
            this.log.debug("Removed System.out adapter");
            this.out = null;
        }
        if (this.err != null) {
            System.err.flush();
            System.setErr(this.err);
            this.log.debug("Removed System.err adapter");
            this.err = null;
        }
    }

    protected void stopService() throws Exception {
        this.timerTask.cancel();
        this.timerTask = null;
        ThrowableHandler.removeThrowableListener(this.throwableAdapter);
        this.throwableAdapter = null;
        this.uninstallSystemAdapters();
        this.uninstallSystemAdapters();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class URLWatchTimerTask
    extends TimerTask {
        private Logger log = Logger.getLogger(class$org$jboss$logging$Log4jService$URLWatchTimerTask == null ? (class$org$jboss$logging$Log4jService$URLWatchTimerTask = URLWatchTimerTask.class$("org.jboss.logging.Log4jService$URLWatchTimerTask")) : class$org$jboss$logging$Log4jService$URLWatchTimerTask);
        private long lastConfigured = -1L;
        static /* synthetic */ Class class$org$jboss$logging$Log4jService$URLWatchTimerTask;

        private URLWatchTimerTask() {
        }

        public void run() {
            this.log.trace("Checking if configuration changed");
            boolean trace = this.log.isTraceEnabled();
            try {
                URLConnection conn = Log4jService.this.configURL.openConnection();
                if (trace) {
                    this.log.trace("connection: " + conn);
                }
                long lastModified = conn.getLastModified();
                if (trace) {
                    this.log.trace("last configured: " + this.lastConfigured);
                    this.log.trace("last modified: " + lastModified);
                }
                if (this.lastConfigured < lastModified) {
                    this.reconfigure(conn);
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to check URL: " + Log4jService.this.configURL, e);
            }
        }

        public void reconfigure() throws IOException {
            URLConnection conn = Log4jService.this.configURL.openConnection();
            this.reconfigure(conn);
        }

        private void reconfigure(URLConnection conn) {
            this.log.info("Configuring from URL: " + Log4jService.this.configURL);
            boolean xml = false;
            boolean trace = this.log.isTraceEnabled();
            String contentType = conn.getContentType();
            if (trace) {
                this.log.trace("content type: " + contentType);
            }
            if (contentType == null) {
                String filename = Log4jService.this.configURL.getFile().toLowerCase();
                if (trace) {
                    this.log.trace("filename: " + filename);
                }
                xml = filename.endsWith(".xml");
            } else {
                xml = contentType.equalsIgnoreCase("text/xml");
            }
            if (trace) {
                this.log.trace("reconfiguring; xml=" + xml);
            }
            if (trace) {
                try {
                    InputStream is = conn.getInputStream();
                    Streams.copy(is, System.out);
                }
                catch (Exception e) {
                    this.log.error("Failed to dump config", e);
                }
            }
            Log4jService.this.uninstallSystemAdapters();
            if (xml) {
                DOMConfigurator.configure(Log4jService.this.configURL);
            } else {
                PropertyConfigurator.configure(Log4jService.this.configURL);
            }
            Log4jService.this.installSystemAdapters();
            this.lastConfigured = System.currentTimeMillis();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class ThrowableListenerLoggingAdapter
    implements ThrowableListener {
        private Logger log = Logger.getLogger(class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter == null ? (class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter = ThrowableListenerLoggingAdapter.class$("org.jboss.logging.Log4jService$ThrowableListenerLoggingAdapter")) : class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter);
        static /* synthetic */ Class class$org$jboss$logging$Log4jService$ThrowableListenerLoggingAdapter;

        private ThrowableListenerLoggingAdapter() {
        }

        public void onThrowable(int type, Throwable t) {
            switch (type) {
                default: {
                    this.log.error("unhandled throwable", t);
                    break;
                }
                case 2: {
                    this.log.warn("unhandled throwable", t);
                    break;
                }
                case 0: {
                    this.log.trace("unhandled throwable, status is unknown", t);
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

