/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.ImRAccess;
import org.jacorb.util.Debug;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;

public class ImRAccessImpl
implements ImRAccess {
    private Registration reg = null;
    private ImRInfo info = null;

    public void connect(ORB oRB) throws INTERNAL {
        try {
            this.reg = RegistrationHelper.narrow(oRB.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        if (this.reg == null || this.reg._non_existent()) {
            Debug.output(1, "ERROR: No connection to ImplementationRepository");
            throw new INTERNAL("Unable to resolve reference to ImR");
        }
    }

    public String getImRHost() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.host;
    }

    public int getImRPort() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.port;
    }

    public void registerPOA(String string, String string2, String string3, int n) throws INTERNAL {
        try {
            this.reg.register_poa(string, string2, string3, n);
        }
        catch (DuplicatePOAName duplicatePOAName) {
            throw new INTERNAL("A server with the same combination of ImplName/POA-Name (" + string + ") is already registered and listed as active at the imr!");
        }
        catch (IllegalPOAName illegalPOAName) {
            throw new INTERNAL("The ImR replied that the POA name >>" + illegalPOAName.name + "<< is illegal!");
        }
        catch (UnknownServerName unknownServerName) {
            throw new INTERNAL("The ImR replied that the server name >>" + unknownServerName.name + "<< is unknown!");
        }
    }

    public void setServerDown(String string) throws INTERNAL {
        try {
            this.reg.set_server_down(string);
        }
        catch (UnknownServerName unknownServerName) {
            throw new INTERNAL("The ImR replied that a server with name " + string + " is unknown");
        }
    }
}

