/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.util.Hashtable;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.HostInfoHelper;
import org.jacorb.imr.HostNameHelper;
import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.ImRInfoHelper;
import org.jacorb.imr.LogicalServerNameHelper;
import org.jacorb.imr.POANameHelper;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.RegistrationOperations;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.DuplicatePOANameHelper;
import org.jacorb.imr.RegistrationPackage.IllegalHostName;
import org.jacorb.imr.RegistrationPackage.IllegalHostNameHelper;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.RegistrationPackage.IllegalPOANameHelper;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRef;
import org.jacorb.imr.RegistrationPackage.InvalidSSDRefHelper;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.imr.UnknownServerNameHelper;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class RegistrationPOA
extends Servant
implements InvokeHandler,
RegistrationOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:org/jacorb/imr/Registration:1.0", "IDL:omg.org/CORBA/Object:1.0"};

    public Registration _this() {
        return RegistrationHelper.narrow(this._this_object());
    }

    public Registration _this(ORB oRB) {
        return RegistrationHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                outputStream = responseHandler.createReply();
                ImRInfoHelper.write(outputStream, this.get_imr_info());
                break;
            }
            case 1: {
                try {
                    String string2 = POANameHelper.read(inputStream);
                    String string3 = LogicalServerNameHelper.read(inputStream);
                    String string4 = HostNameHelper.read(inputStream);
                    int n2 = inputStream.read_ulong();
                    outputStream = responseHandler.createReply();
                    this.register_poa(string2, string3, string4, n2);
                }
                catch (IllegalPOAName illegalPOAName) {
                    outputStream = responseHandler.createExceptionReply();
                    IllegalPOANameHelper.write(outputStream, illegalPOAName);
                }
                catch (DuplicatePOAName duplicatePOAName) {
                    outputStream = responseHandler.createExceptionReply();
                    DuplicatePOANameHelper.write(outputStream, duplicatePOAName);
                }
                catch (UnknownServerName unknownServerName) {
                    outputStream = responseHandler.createExceptionReply();
                    UnknownServerNameHelper.write(outputStream, unknownServerName);
                }
                break;
            }
            case 2: {
                try {
                    String string5 = LogicalServerNameHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.set_server_down(string5);
                }
                catch (UnknownServerName unknownServerName) {
                    outputStream = responseHandler.createExceptionReply();
                    UnknownServerNameHelper.write(outputStream, unknownServerName);
                }
                break;
            }
            case 3: {
                try {
                    HostInfo hostInfo = HostInfoHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.register_host(hostInfo);
                    break;
                }
                catch (InvalidSSDRef invalidSSDRef) {
                    outputStream = responseHandler.createExceptionReply();
                    InvalidSSDRefHelper.write(outputStream, invalidSSDRef);
                    break;
                }
                catch (IllegalHostName illegalHostName) {
                    outputStream = responseHandler.createExceptionReply();
                    IllegalHostNameHelper.write(outputStream, illegalHostName);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    public abstract ImRInfo get_imr_info();

    public abstract void register_poa(String var1, String var2, String var3, int var4) throws IllegalPOAName, DuplicatePOAName, UnknownServerName;

    public abstract void set_server_down(String var1) throws UnknownServerName;

    public abstract void register_host(HostInfo var1) throws InvalidSSDRef, IllegalHostName;

    static {
        m_opsHash.put("get_imr_info", new Integer(0));
        m_opsHash.put("register_poa", new Integer(1));
        m_opsHash.put("set_server_down", new Integer(2));
        m_opsHash.put("register_host", new Integer(3));
    }
}

