/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.Value;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IRInterface;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.IRValueMember;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ValueDef;
import org.omg.CORBA.ValueDefHelper;

public class IRValue
extends IRContainer
implements Value {
    private Value baseValue = null;
    private boolean lookedUpBaseValue = false;
    private Value[] abstractBaseValues = null;
    private IRInterface[] interfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;
    private IRValueMember[] allMembers = null;

    public IRValue() {
    }

    public IRValue(IRObject iRObject) {
        super(iRObject);
    }

    public String[] allowedToAdd() {
        String[] stringArray = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName(), IRValueMember.nodeTypeName()};
        return stringArray;
    }

    public String description() {
        String string = super.description();
        Value value = this.getBaseValue();
        string = value != null ? string + "\nBase-Value:\t " + ((IRValue)value).getAbsoluteName() : string + "\nBase-Value:\t:none";
        Interface[] interfaceArray = this.getInterfaces();
        if (interfaceArray.length > 0) {
            string = string + "\nImplemented-Interfaces:\t ";
            int n = 0;
            while (n < interfaceArray.length) {
                string = string + ((TypeSystemNode)((Object)interfaceArray[n])).getAbsoluteName();
                if (n != interfaceArray.length - 1) {
                    string = string + ", ";
                }
                ++n;
            }
        } else {
            string = string + "\nImplemented-Interfaces:\t:none";
        }
        Value[] valueArray = this.getAbstractBaseValues();
        if (valueArray.length > 0) {
            string = string + "\nAbstract-Base-Values:\t ";
            int n = 0;
            while (n < valueArray.length) {
                string = string + ((TypeSystemNode)((Object)valueArray[n])).getAbsoluteName();
                if (n != valueArray.length - 1) {
                    string = string + ", ";
                }
                ++n;
            }
        } else {
            string = string + "\nAbstract-Base-Values:\t:none";
        }
        return string;
    }

    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int n;
            ModelParticipant[] modelParticipantArray;
            int n2;
            Object[] objectArray;
            Vector<Object> vector = new Vector<Object>();
            Interface[] interfaceArray = this.getInterfaces();
            int n3 = 0;
            while (n3 < interfaceArray.length) {
                objectArray = interfaceArray[n3].getAllFields();
                n2 = 0;
                while (n2 < objectArray.length) {
                    vector.addElement(objectArray[n2]);
                    ++n2;
                }
                ++n3;
            }
            objectArray = this.getAbstractBaseValues();
            n2 = 0;
            while (n2 < objectArray.length) {
                modelParticipantArray = objectArray[n2].getAllFields();
                n = 0;
                while (n < modelParticipantArray.length) {
                    if (modelParticipantArray[n] instanceof IRAttribute) {
                        vector.addElement(modelParticipantArray[n]);
                    }
                    ++n;
                }
                ++n2;
            }
            modelParticipantArray = this.contents();
            n = 0;
            while (n < modelParticipantArray.length) {
                if (modelParticipantArray[n] instanceof IRAttribute) {
                    vector.addElement(modelParticipantArray[n]);
                }
                ++n;
            }
            this.allFields = new IRAttribute[vector.size()];
            int n4 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allFields[n4] = (IRAttribute)enumeration.nextElement();
                ++n4;
            }
        }
        return this.allFields;
    }

    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int n;
            ModelParticipant[] modelParticipantArray;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getInterfaces();
            int n2 = 0;
            while (n2 < interfaceArray.length) {
                modelParticipantArray = interfaceArray[n2].getAllOperations();
                n = 0;
                while (n < modelParticipantArray.length) {
                    vector.addElement(modelParticipantArray[n]);
                    ++n;
                }
                ++n2;
            }
            modelParticipantArray = this.contents();
            n = 0;
            while (n < modelParticipantArray.length) {
                if (modelParticipantArray[n] instanceof IROperation) {
                    vector.addElement(modelParticipantArray[n]);
                }
                ++n;
            }
            this.allOperations = new IROperation[vector.size()];
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allOperations[n3] = (IROperation)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allOperations;
    }

    public Value getBaseValue() {
        if (!this.lookedUpBaseValue) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            ValueDef valueDef2 = valueDef.base_value();
            if (valueDef2 != null) {
                this.baseValue = (Value)((Object)RemoteTypeSystem.createTypeSystemNode(valueDef2));
            }
            this.lookedUpBaseValue = true;
        }
        return this.baseValue;
    }

    public Value[] getAbstractBaseValues() {
        if (this.abstractBaseValues == null) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            ValueDef[] valueDefArray = valueDef.abstract_base_values();
            this.abstractBaseValues = new Value[valueDefArray.length];
            int n = 0;
            while (n < valueDefArray.length) {
                this.abstractBaseValues[n] = (Value)((Object)RemoteTypeSystem.createTypeSystemNode(valueDefArray[n]));
                ++n;
            }
        }
        return this.abstractBaseValues;
    }

    public TypeSystemNode[] getAllMembers() {
        if (this.allMembers == null) {
            int n;
            ModelParticipant[] modelParticipantArray;
            int n2;
            Object[] objectArray;
            Vector<Object> vector = new Vector<Object>();
            Value value = this.getBaseValue();
            if (value != null) {
                objectArray = value.getAllMembers();
                n2 = 0;
                while (n2 < objectArray.length) {
                    vector.addElement(objectArray[n2]);
                    ++n2;
                }
            }
            objectArray = this.getAbstractBaseValues();
            n2 = 0;
            while (n2 < objectArray.length) {
                modelParticipantArray = objectArray[n2].getAllMembers();
                n = 0;
                while (n < modelParticipantArray.length) {
                    vector.addElement(modelParticipantArray[n]);
                    ++n;
                }
                ++n2;
            }
            modelParticipantArray = this.contents();
            n = 0;
            while (n < modelParticipantArray.length) {
                if (modelParticipantArray[n] instanceof IRValueMember) {
                    vector.addElement(modelParticipantArray[n]);
                }
                ++n;
            }
            this.allMembers = new IRValueMember[vector.size()];
            int n3 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allMembers[n3] = (IRValueMember)enumeration.nextElement();
                ++n3;
            }
        }
        return this.allMembers;
    }

    public Interface[] getInterfaces() {
        if (this.interfaces == null) {
            ValueDef valueDef = ValueDefHelper.narrow(this.irObject);
            InterfaceDef[] interfaceDefArray = valueDef.supported_interfaces();
            this.interfaces = new IRInterface[interfaceDefArray.length];
            int n = 0;
            while (n < interfaceDefArray.length) {
                IRInterface iRInterface;
                this.interfaces[n] = iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(interfaceDefArray[n]);
                ++n;
            }
        }
        return this.interfaces;
    }

    public static String nodeTypeName() {
        return "value";
    }

    protected void setIRObject(IRObject iRObject) {
        super.setIRObject(iRObject);
    }
}

