/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.EncapsInfo;
import org.jacorb.orb.TypeCode;
import org.jacorb.orb.connection.CodeSet;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.jacorb.util.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;

public class CDROutputStream
extends org.omg.CORBA_2_3.portable.OutputStream {
    static int instances = 0;
    private int index = 0;
    private int pos = 0;
    private int deferred_writes = 0;
    private byte[] buffer = null;
    private boolean closed = false;
    private boolean released = false;
    private int codeSet = CodeSet.getTCSDefault();
    private int codeSetW = CodeSet.getTCSWDefault();
    private boolean use_BOM = false;
    private BufferManager bufMgr = null;
    private int resize_factor = 1;
    private int encaps_start = -1;
    private Stack encaps_stack = new Stack();
    private Hashtable recursiveTCMap = new Hashtable();
    private Map valueMap = new HashMap();
    private Map repIdMap = new HashMap();
    private Map codebaseMap = new HashMap();
    private List deferredArrayQueue = new Vector();
    private static final String null_ior_str = "IOR:00000000000000010000000000000000";
    private static final IOR null_ior = new IOR("", new TaggedProfile[0]);
    private ORB orb = null;
    public int giop_minor = 2;
    static /* synthetic */ Class class$java$lang$String;

    public CDROutputStream() {
        this.bufMgr = BufferManager.getInstance();
        this.buffer = this.bufMgr.getPreferredMemoryBuffer();
        this.use_BOM = Environment.isPropertyOn("jacorb.use_bom");
        ++instances;
    }

    public CDROutputStream(ORB oRB) {
        this.orb = oRB;
        this.bufMgr = BufferManager.getInstance();
        this.buffer = this.bufMgr.getPreferredNetworkBuffer();
        this.use_BOM = Environment.isPropertyOn("jacorb.use_bom");
        ++instances;
    }

    public CDROutputStream(byte[] byArray) {
        this.bufMgr = BufferManager.getInstance();
        this.buffer = byArray;
    }

    public ORB orb() {
        if (this.orb == null) {
            this.orb = ORB.init();
        }
        return this.orb;
    }

    public void write(OutputStream outputStream, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        int n6 = 0;
        DeferredWriteFrame deferredWriteFrame = null;
        if (this.deferredArrayQueue.size() > 0) {
            deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
            while (deferredWriteFrame.write_pos < n && n6 < this.deferredArrayQueue.size()) {
                n5 += deferredWriteFrame.length;
                deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
            }
            if (deferredWriteFrame.write_pos < n && n6 >= this.deferredArrayQueue.size()) {
                n5 += deferredWriteFrame.length;
                deferredWriteFrame = null;
            }
        }
        while (n3 < n + n2) {
            if (deferredWriteFrame != null && n3 == deferredWriteFrame.write_pos) {
                Debug.myAssert(deferredWriteFrame.length <= n + n2 - n3, "Deferred array does not fit!!!");
                outputStream.write(deferredWriteFrame.buf, deferredWriteFrame.start, deferredWriteFrame.length);
                n3 += deferredWriteFrame.length;
                deferredWriteFrame = null;
                if (n6 < this.deferredArrayQueue.size()) {
                    deferredWriteFrame = (DeferredWriteFrame)this.deferredArrayQueue.get(n6++);
                    if (deferredWriteFrame.write_pos > n + n2) {
                        deferredWriteFrame = null;
                    }
                }
            }
            if (n3 >= n + n2) continue;
            int n7 = Math.min(n + n2, deferredWriteFrame != null ? deferredWriteFrame.write_pos : n + n2);
            outputStream.write(this.buffer, n4 - n5, n7 -= n3);
            n4 += n7;
            n3 += n7;
        }
    }

    public void setCodeSet(int n, int n2) {
        this.codeSet = n;
        this.codeSetW = n2;
    }

    public void setGIOPMinor(int n) {
        this.giop_minor = n;
    }

    public int getGIOPMinor() {
        return this.giop_minor;
    }

    public void close() {
        if (this.closed) {
            throw new Error("Stream already closed!");
        }
        this.closed = true;
    }

    public void release() {
        if (this.released) {
            return;
        }
        if (this.bufMgr != null) {
            this.bufMgr.returnBuffer(this.buffer);
        }
        this.deferredArrayQueue.clear();
        this.deferred_writes = 0;
        this.released = true;
    }

    private final void check(int n, int n2) {
        int n3 = n2 - this.index % n2;
        this.check(n + n3);
        if (n3 != n2) {
            this.buffer[this.pos] = 0;
            this.buffer[this.pos + 1] = 0;
            this.buffer[this.pos + 2] = 0;
            this.buffer[this.pos + 3] = 0;
            this.buffer[this.pos + 4] = 0;
            this.buffer[this.pos + 5] = 0;
            this.buffer[this.pos + 6] = 0;
            this.buffer[this.pos + 7] = 0;
            this.index += n3;
            this.pos += n3;
        }
    }

    private final void check(int n) {
        if (this.pos + n + 2 > this.buffer.length) {
            byte[] byArray;
            if (this.bufMgr == null) {
                int n2 = this.buffer.length;
                while (this.pos + n + 2 > n2) {
                    n2 <<= 1;
                }
                byArray = new byte[n2];
                System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
            } else {
                byArray = this.bufMgr.getBuffer(this.pos + n + 2);
                System.arraycopy(this.buffer, 0, byArray, 0, this.pos);
                this.bufMgr.returnBuffer(this.buffer);
            }
            this.buffer = byArray;
        }
    }

    private static final void _write4int(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public final void beginEncapsulation() {
        this.check(8, 4);
        this.pos += 4;
        this.index += 4;
        this.encaps_stack.push(new EncapsInfo(this.index, this.encaps_start));
        this.encaps_start = this.pos;
        this.beginEncapsulatedArray();
    }

    public final void beginEncapsulatedArray() {
        this.resetIndex();
        this.buffer[this.pos++] = 0;
        ++this.index;
    }

    public final void endEncapsulation() throws IOException {
        if (this.encaps_start == -1) {
            throw new IOException("too many end-of-encapsulations");
        }
        int n = this.pos - this.encaps_start;
        this.buffer[this.encaps_start - 4] = (byte)(n >>> 24 & 0xFF);
        this.buffer[this.encaps_start - 3] = (byte)(n >>> 16 & 0xFF);
        this.buffer[this.encaps_start - 2] = (byte)(n >>> 8 & 0xFF);
        this.buffer[this.encaps_start - 1] = (byte)(n & 0xFF);
        EncapsInfo encapsInfo = (EncapsInfo)this.encaps_stack.pop();
        this.encaps_start = encapsInfo.start;
        this.index = encapsInfo.index + n;
    }

    public byte[] getBufferCopy() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.write(byteArrayOutputStream, 0, this.size());
        }
        catch (IOException iOException) {
            Debug.output(1, iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    private void resetIndex() {
        this.index = 0;
    }

    public int size() {
        return this.pos + this.deferred_writes;
    }

    public void reset() {
        this.deferredArrayQueue.clear();
        this.pos = 0;
        this.deferred_writes = 0;
        this.index = 0;
    }

    public void finalize() {
        this.release();
    }

    public final void skip(int n) {
        this.pos += n;
        this.index += n;
    }

    public final void reduceSize(int n) {
        this.pos -= n;
    }

    public final void increaseSize(int n) {
        this.pos += n;
        this.check(n);
    }

    public void setBuffer(byte[] byArray) {
        this.bufMgr.returnBuffer(this.buffer);
        this.buffer = byArray;
        this.reset();
    }

    public void setBufferWithoutReset(byte[] byArray, int n) {
        this.release();
        this.buffer = byArray;
        this.pos = n;
    }

    public InputStream create_input_stream() {
        byte[] byArray = (byte[])this.buffer.clone();
        return new CDRInputStream(this.orb, byArray);
    }

    public final void write_any(Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public final void write_boolean(boolean bl) {
        this.check(1);
        this.buffer[this.pos++] = bl ? (byte)1 : 0;
        ++this.index;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray != null) {
            this.check(n2);
            int n3 = n;
            while (n3 < n + n2) {
                this.buffer[this.pos++] = blArray[n3] ? (byte)1 : 0;
                ++n3;
            }
            this.index += n2;
        }
    }

    public final void write_char(char c) {
        this.check(1);
        if (this.codeSet == 65537) {
            if ((c & 0xFF00) != 0) {
                throw new MARSHAL("char (" + c + ") out of range for ISO8859_1");
            }
            ++this.index;
        } else {
            throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
        }
        this.buffer[this.pos++] = (byte)c;
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Null References");
        }
        this.check(n2);
        if (this.codeSet != 65537) {
            throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
        }
        int n3 = n;
        while (n3 < n + n2) {
            if ((cArray[n3] & 0xFF00) != 0) {
                throw new MARSHAL("char (" + cArray[n3] + ") out of range for ISO8859_1");
            }
            this.buffer[this.pos++] = (byte)cArray[n3];
            ++n3;
        }
        this.index += n2;
    }

    public final void write_string(String string) {
        if (string == null) {
            throw new MARSHAL("Null References");
        }
        if (this.codeSet != 65537) {
            throw new MARSHAL("The char type only allows single-byte codesets, but the selected one is: " + CodeSet.csName(this.codeSet));
        }
        int n = 4 + string.length() + 1;
        this.check(n, 4);
        CDROutputStream._write4int(this.buffer, this.pos, n - 4);
        this.pos += 4;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if ((c & 0xFF00) != 0) {
                throw new MARSHAL("char (" + this.buffer[this.pos - 1] + ") out of range for ISO8859_1");
            }
            this.buffer[this.pos++] = (byte)c;
            ++n2;
        }
        this.buffer[this.pos++] = 0;
        this.index += n;
    }

    public final void write_wchar(char c) {
        this.write_wchar(c, this.use_BOM, true);
    }

    private final void write_wchar(char c, boolean bl, boolean bl2) {
        this.check(3);
        switch (this.codeSetW) {
            case 0x5010001: {
                if (c <= '\u007f') {
                    if (this.giop_minor == 2 && bl2) {
                        this.write_octet((byte)1);
                    }
                    this.buffer[this.pos++] = (byte)c;
                    break;
                }
                if (c > '\u07ff') {
                    if (this.giop_minor == 2 && bl2) {
                        this.write_octet((byte)3);
                    }
                    this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                    this.index += 3;
                    break;
                }
                if (this.giop_minor == 2 && bl2) {
                    this.write_octet((byte)2);
                }
                this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                this.index += 2;
                break;
            }
            case 65801: {
                if (this.giop_minor == 2) {
                    if (bl2) {
                        this.write_octet((byte)2);
                    }
                    if (bl) {
                        this.buffer[this.pos++] = -2;
                        this.buffer[this.pos++] = -1;
                        this.index += 2;
                    }
                    this.buffer[this.pos++] = (byte)(c >> 8 & 0xFF);
                    this.buffer[this.pos++] = (byte)(c & 0xFF);
                    this.index += 2;
                    break;
                }
                this.write_short((short)c);
                break;
            }
            default: {
                throw new Error("Bad codeset: " + this.codeSet);
            }
        }
    }

    public final void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new MARSHAL("Null References");
        }
        this.check(n2 * 3);
        int n3 = n;
        while (n3 < n + n2) {
            this.write_wchar(cArray[n3]);
            ++n3;
        }
    }

    public final void write_wstring(String string) {
        if (string == null) {
            throw new MARSHAL("Null References");
        }
        this.check(4 + string.length() * 3 + 3, 4);
        int n = this.pos;
        this.pos += 4;
        this.index += 4;
        if (this.giop_minor == 2 && this.use_BOM) {
            this.buffer[this.pos++] = -2;
            this.buffer[this.pos++] = -1;
            this.index += 2;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            this.write_wchar(string.charAt(n2), false, false);
            ++n2;
        }
        if (this.giop_minor < 2) {
            this.write_wchar('\u0000', false, false);
        }
        int n3 = 0;
        if (this.giop_minor == 2) {
            n3 = this.pos - n - 4;
        } else if (this.codeSetW == 0x5010001) {
            n3 = this.pos - n - 4;
        } else if (this.codeSetW == 65801) {
            n3 = string.length() + 1;
        }
        CDROutputStream._write4int(this.buffer, n, n3);
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        this.check(7 + n2 * 8, 8);
        if (dArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                long l = Double.doubleToLongBits(dArray[n3]);
                this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
                this.pos += 8;
                ++n3;
            }
            this.index += 8 * n2;
        }
    }

    public final void write_fixed(BigDecimal bigDecimal) {
        int n;
        byte[] byArray;
        String string = bigDecimal.movePointRight(bigDecimal.scale()).toString();
        if (string.length() % 2 == 0) {
            byArray = new byte[string.length() / 2 + 1];
            byArray[0] = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = Character.digit(string.charAt(n2), 10);
                n = byArray[(1 + n2) / 2] << 4;
                byArray[(1 + n2) / 2] = (byte)(n |= n3);
                ++n2;
            }
        } else {
            byArray = new byte[(string.length() + 1) / 2];
            int n4 = 0;
            while (n4 < string.length()) {
                int n5 = Character.digit(string.charAt(n4), 10);
                n = byArray[n4 / 2] << 4;
                byArray[n4 / 2] = (byte)(n |= n5);
                ++n4;
            }
        }
        n = byArray[byArray.length - 1] << 4;
        byArray[byArray.length - 1] = bigDecimal.signum() < 0 ? (byte)(n | 0xD) : (byte)(n | 0xC);
        this.check(byArray.length);
        System.arraycopy(byArray, 0, this.buffer, this.pos, byArray.length);
        this.index += byArray.length;
        this.pos += byArray.length;
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        this.check(3 + n2 * 4, 4);
        if (fArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                CDROutputStream._write4int(this.buffer, this.pos, Float.floatToIntBits(fArray[n3]));
                this.pos += 4;
                ++n3;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_long(int n) {
        this.check(7, 4);
        CDROutputStream._write4int(this.buffer, this.pos, n);
        this.pos += 4;
        this.index += 4;
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        this.check(3 + n2 * 4, 4);
        int n3 = 4 - this.index % 4;
        if (n3 != 4) {
            this.index += n3;
            this.pos += n3;
        }
        if (nArray != null) {
            int n4 = n;
            while (n4 < n + n2) {
                CDROutputStream._write4int(this.buffer, this.pos, nArray[n4]);
                this.pos += 4;
                ++n4;
            }
            this.index += 4 * n2;
        }
    }

    public final void write_longlong(long l) {
        this.check(15, 8);
        this.buffer[this.pos] = (byte)(l >>> 56 & 0xFFL);
        this.buffer[this.pos + 1] = (byte)(l >>> 48 & 0xFFL);
        this.buffer[this.pos + 2] = (byte)(l >>> 40 & 0xFFL);
        this.buffer[this.pos + 3] = (byte)(l >>> 32 & 0xFFL);
        this.buffer[this.pos + 4] = (byte)(l >>> 24 & 0xFFL);
        this.buffer[this.pos + 5] = (byte)(l >>> 16 & 0xFFL);
        this.buffer[this.pos + 6] = (byte)(l >>> 8 & 0xFFL);
        this.buffer[this.pos + 7] = (byte)(l & 0xFFL);
        this.index += 8;
        this.pos += 8;
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        this.check(7 + n2 * 8, 8);
        if (lArray != null) {
            int n3 = n;
            while (n3 < n + n2) {
                this.buffer[this.pos] = (byte)(lArray[n3] >>> 56 & 0xFFL);
                this.buffer[this.pos + 1] = (byte)(lArray[n3] >>> 48 & 0xFFL);
                this.buffer[this.pos + 2] = (byte)(lArray[n3] >>> 40 & 0xFFL);
                this.buffer[this.pos + 3] = (byte)(lArray[n3] >>> 32 & 0xFFL);
                this.buffer[this.pos + 4] = (byte)(lArray[n3] >>> 24 & 0xFFL);
                this.buffer[this.pos + 5] = (byte)(lArray[n3] >>> 16 & 0xFFL);
                this.buffer[this.pos + 6] = (byte)(lArray[n3] >>> 8 & 0xFFL);
                this.buffer[this.pos + 7] = (byte)(lArray[n3] & 0xFFL);
                this.pos += 8;
                ++n3;
            }
            this.index += 8 * n2;
        }
    }

    public void write_Object(Object object) {
        if (object == null) {
            IORHelper.write(this, null_ior);
        } else {
            if (object instanceof LocalObject) {
                throw new MARSHAL("Attempt to serialize a locality-constrained object.");
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            IORHelper.write(this, ((Delegate)objectImpl._get_delegate()).getIOR());
        }
    }

    public void write_IOR(IOR iOR) {
        if (iOR == null) {
            IORHelper.write(this, null_ior);
        } else {
            IORHelper.write(this, iOR);
        }
    }

    public final void write_octet(byte by) {
        this.check(1);
        ++this.index;
        this.buffer[this.pos++] = by;
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            if (n2 > 4000) {
                this.deferredArrayQueue.add(new DeferredWriteFrame(this.index, n, n2, byArray));
                this.index += n2;
                this.deferred_writes += n2;
            } else {
                this.check(n2);
                System.arraycopy(byArray, n, this.buffer, this.pos, n2);
                this.index += n2;
                this.pos += n2;
            }
        }
    }

    public final void write_Principal(Principal principal) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    public final void write_short(short s) {
        this.check(3, 2);
        this.buffer[this.pos] = (byte)(s >> 8 & 0xFF);
        this.buffer[this.pos + 1] = (byte)(s & 0xFF);
        this.index += 2;
        this.pos += 2;
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        this.check(2 * n2 + 3);
        int n3 = 2 - this.index % 2;
        if (n3 != 2) {
            this.index += n3;
            this.pos += n3;
        }
        if (sArray != null) {
            int n4 = n;
            while (n4 < n + n2) {
                this.buffer[this.pos] = (byte)(sArray[n4] >>> 8 & 0xFF);
                this.buffer[this.pos + 1] = (byte)(sArray[n4] & 0xFF);
                this.pos += 2;
                ++n4;
            }
            this.index += 2 * n2;
        }
    }

    public final void write_TypeCode(org.omg.CORBA.TypeCode typeCode) {
        Hashtable hashtable = new Hashtable();
        this.write_TypeCode(typeCode, hashtable);
        hashtable.clear();
    }

    private final void writeRecursiveTypeCode(org.omg.CORBA.TypeCode typeCode, Hashtable hashtable) {
        try {
            this.write_long(-1);
            int n = (Integer)hashtable.get(typeCode.id()) - this.pos - 4;
            this.write_long(n);
        }
        catch (BadKind badKind) {
            // empty catch block
        }
    }

    private final void write_TypeCode(org.omg.CORBA.TypeCode typeCode, Hashtable hashtable) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = typeCode.kind().value();
        try {
            if (typeCode instanceof TypeCode && ((TypeCode)typeCode).is_recursive() && hashtable.containsKey(typeCode.id())) {
                this.writeRecursiveTypeCode(typeCode, hashtable);
            } else {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: {
                        this.write_long(n);
                        break;
                    }
                    case 14: {
                        this.write_long(n);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.endEncapsulation();
                        break;
                    }
                    case 15: 
                    case 22: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        int n2 = typeCode.member_count();
                        this.write_long(n2);
                        int n3 = 0;
                        while (n3 < n2) {
                            this.write_string(typeCode.member_name(n3));
                            this.write_TypeCode(typeCode.member_type(n3), hashtable);
                            ++n3;
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 17: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                        } else {
                            this.write_long(n);
                            hashtable.put(typeCode.id(), new Integer(this.pos));
                            this.recursiveTCMap.put(typeCode.id(), typeCode);
                            this.beginEncapsulation();
                            this.write_string(typeCode.id());
                            this.write_string(typeCode.name());
                            int n4 = typeCode.member_count();
                            this.write_long(n4);
                            int n5 = 0;
                            while (n5 < n4) {
                                this.write_string(typeCode.member_name(n5));
                                ++n5;
                            }
                            this.endEncapsulation();
                            break;
                        }
                    }
                    case 16: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.discriminator_type());
                        this.write_long(typeCode.default_index());
                        int n6 = typeCode.member_count();
                        this.write_long(n6);
                        int n7 = 0;
                        while (n7 < n6) {
                            if (n7 == typeCode.default_index()) {
                                this.write_octet((byte)0);
                            } else {
                                typeCode.member_label(n7).write_value(this);
                            }
                            this.write_string(typeCode.member_name(n7));
                            this.write_TypeCode(typeCode.member_type(n7), hashtable);
                            ++n7;
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 18: 
                    case 27: {
                        this.write_long(n);
                        this.write_long(typeCode.length());
                        break;
                    }
                    case 28: {
                        this.write_long(n);
                        this.write_ushort(typeCode.fixed_digits());
                        this.write_short(typeCode.fixed_scale());
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.write_long(n);
                        this.beginEncapsulation();
                        this.write_TypeCode(typeCode.content_type(), hashtable);
                        this.write_long(typeCode.length());
                        this.endEncapsulation();
                        break;
                    }
                    case 21: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.content_type(), hashtable);
                        this.endEncapsulation();
                        break;
                    }
                    case 29: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_short(typeCode.type_modifier());
                        org.omg.CORBA.TypeCode typeCode2 = typeCode.concrete_base_type();
                        if (typeCode2 != null) {
                            this.write_TypeCode(typeCode2, hashtable);
                        } else {
                            this.write_long(0);
                        }
                        int n8 = typeCode.member_count();
                        this.write_long(n8);
                        int n9 = 0;
                        while (n9 < n8) {
                            Debug.output(3, "value member name " + typeCode.member_name(n9));
                            this.write_string(typeCode.member_name(n9));
                            this.write_TypeCode(typeCode.member_type(n9), hashtable);
                            this.write_short(typeCode.member_visibility(n9));
                            ++n9;
                        }
                        this.endEncapsulation();
                        break;
                    }
                    case 30: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.write_TypeCode(typeCode.content_type(), hashtable);
                        this.endEncapsulation();
                        break;
                    }
                    case 32: {
                        if (hashtable.containsKey(typeCode.id())) {
                            this.writeRecursiveTypeCode(typeCode, hashtable);
                            break;
                        }
                        this.write_long(n);
                        hashtable.put(typeCode.id(), new Integer(this.pos));
                        this.recursiveTCMap.put(typeCode.id(), typeCode);
                        this.beginEncapsulation();
                        this.write_string(typeCode.id());
                        this.write_string(typeCode.name());
                        this.endEncapsulation();
                        break;
                    }
                    default: {
                        throw new MARSHAL("Cannot handle TypeCode with kind: " + n);
                    }
                }
            }
        }
        catch (BadKind badKind) {
            badKind.printStackTrace();
        }
        catch (Bounds bounds) {
            bounds.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_value(org.omg.CORBA.TypeCode typeCode, InputStream inputStream) {
        if (typeCode == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        int n = ((TypeCode)typeCode)._kind();
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 8: {
                this.write_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                this.write_char(inputStream.read_char());
                break;
            }
            case 26: {
                this.write_wchar(inputStream.read_wchar());
                break;
            }
            case 10: {
                this.write_octet(inputStream.read_octet());
                break;
            }
            case 2: {
                this.write_short(inputStream.read_short());
                break;
            }
            case 4: {
                this.write_ushort(inputStream.read_ushort());
                break;
            }
            case 3: {
                this.write_long(inputStream.read_long());
                break;
            }
            case 5: {
                this.write_ulong(inputStream.read_ulong());
                break;
            }
            case 6: {
                this.write_float(inputStream.read_float());
                break;
            }
            case 7: {
                this.write_double(inputStream.read_double());
                break;
            }
            case 23: {
                this.write_longlong(inputStream.read_longlong());
                break;
            }
            case 24: {
                this.write_ulonglong(inputStream.read_ulonglong());
                break;
            }
            case 11: {
                this.write_any(inputStream.read_any());
                break;
            }
            case 12: {
                this.write_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                this.write_Object(inputStream.read_Object());
                break;
            }
            case 18: {
                this.write_string(inputStream.read_string());
                break;
            }
            case 27: {
                this.write_wstring(inputStream.read_wstring());
                break;
            }
            case 20: {
                try {
                    int n2 = typeCode.length();
                    int n3 = ((TypeCode)typeCode.content_type())._kind();
                    if (n3 == 10) {
                        this.check(n2);
                        inputStream.read_octet_array(this.buffer, this.pos, n2);
                        this.index += n2;
                        this.pos += n2;
                        break;
                    }
                    int n4 = 0;
                    while (n4 < n2) {
                        this.write_value(typeCode.content_type(), inputStream);
                        ++n4;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 19: {
                try {
                    int n5 = inputStream.read_long();
                    this.write_long(n5);
                    int n6 = ((TypeCode)typeCode.content_type())._kind();
                    org.omg.CORBA.TypeCode typeCode2 = typeCode.content_type();
                    int n7 = 0;
                    while (n7 < n5) {
                        this.write_value(typeCode2, inputStream);
                        ++n7;
                    }
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                }
                break;
            }
            case 22: {
                this.write_string(inputStream.read_string());
            }
            case 15: {
                try {
                    int n8 = 0;
                    while (n8 < typeCode.member_count()) {
                        this.write_value(typeCode.member_type(n8), inputStream);
                        ++n8;
                    }
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 17: {
                this.write_long(inputStream.read_long());
                break;
            }
            case 16: {
                try {
                    TypeCode typeCode3 = (TypeCode)typeCode.discriminator_type();
                    typeCode3 = typeCode3.originalType();
                    int n9 = typeCode.default_index();
                    int n10 = -1;
                    block35 : switch (typeCode3._kind()) {
                        case 2: {
                            short s = inputStream.read_short();
                            this.write_short(s);
                            int n11 = 0;
                            while (n11 < typeCode.member_count()) {
                                if (n11 != n9 && s == typeCode.member_label(n11).extract_short()) {
                                    n10 = n11;
                                    break block35;
                                }
                                ++n11;
                            }
                            break;
                        }
                        case 4: {
                            short s = inputStream.read_ushort();
                            this.write_ushort(s);
                            int n12 = 0;
                            while (n12 < typeCode.member_count()) {
                                if (n12 != n9 && s == typeCode.member_label(n12).extract_ushort()) {
                                    n10 = n12;
                                    break block35;
                                }
                                ++n12;
                            }
                            break;
                        }
                        case 3: {
                            int n13 = inputStream.read_long();
                            this.write_long(n13);
                            int n14 = 0;
                            while (n14 < typeCode.member_count()) {
                                if (n14 != n9 && n13 == typeCode.member_label(n14).extract_long()) {
                                    n10 = n14;
                                    break block35;
                                }
                                ++n14;
                            }
                            break;
                        }
                        case 5: {
                            int n15 = inputStream.read_ulong();
                            this.write_ulong(n15);
                            int n16 = 0;
                            while (n16 < typeCode.member_count()) {
                                if (n16 != n9 && n15 == typeCode.member_label(n16).extract_ulong()) {
                                    n10 = n16;
                                    break block35;
                                }
                                ++n16;
                            }
                            break;
                        }
                        case 23: {
                            long l = inputStream.read_longlong();
                            this.write_longlong(l);
                            int n17 = 0;
                            while (n17 < typeCode.member_count()) {
                                if (n17 != n9 && l == typeCode.member_label(n17).extract_longlong()) {
                                    n10 = n17;
                                    break block35;
                                }
                                ++n17;
                            }
                            break;
                        }
                        case 24: {
                            long l = inputStream.read_ulonglong();
                            this.write_ulonglong(l);
                            int n18 = 0;
                            while (n18 < typeCode.member_count()) {
                                if (n18 != n9 && l == typeCode.member_label(n18).extract_ulonglong()) {
                                    n10 = n18;
                                    break block35;
                                }
                                ++n18;
                            }
                            break;
                        }
                        case 8: {
                            boolean bl = inputStream.read_boolean();
                            this.write_boolean(bl);
                            int n19 = 0;
                            while (n19 < typeCode.member_count()) {
                                if (n19 != n9 && bl == typeCode.member_label(n19).extract_boolean()) {
                                    n10 = n19;
                                    break block35;
                                }
                                ++n19;
                            }
                            break;
                        }
                        case 17: {
                            int n20 = inputStream.read_long();
                            this.write_long(n20);
                            int n21 = 0;
                            while (n21 < typeCode.member_count()) {
                                int n22;
                                if (n21 != n9 && n20 == (n22 = typeCode.member_label(n21).create_input_stream().read_long())) {
                                    n10 = n21;
                                    break block35;
                                }
                                ++n21;
                            }
                            break;
                        }
                        case 9: {
                            char c = inputStream.read_char();
                            this.write_char(c);
                            int n23 = 0;
                            while (n23 < typeCode.member_count()) {
                                if (n23 != n9 && c == typeCode.member_label(n23).extract_char()) {
                                    n10 = n23;
                                    break block35;
                                }
                                ++n23;
                            }
                            break;
                        }
                        default: {
                            throw new MARSHAL("Invalid union discriminator type: " + typeCode3);
                        }
                    }
                    if (n10 != -1) {
                        this.write_value(typeCode.member_type(n10), inputStream);
                        break;
                    }
                    if (n9 == -1) break;
                    this.write_value(typeCode.member_type(n9), inputStream);
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 21: {
                try {
                    this.write_value(typeCode.content_type(), inputStream);
                }
                catch (BadKind badKind) {}
                break;
            }
            case -1: {
                try {
                    org.omg.CORBA.TypeCode typeCode4 = (org.omg.CORBA.TypeCode)this.recursiveTCMap.get(typeCode.id());
                    if (typeCode4 == null) {
                        throw new MARSHAL("Recursive TypeCode not found for " + typeCode.id());
                    }
                    this.write_value(typeCode4, inputStream);
                }
                catch (BadKind badKind) {
                    badKind.printStackTrace();
                }
                break;
            }
            default: {
                throw new MARSHAL("Cannot handle TypeCode with kind " + n);
            }
        }
    }

    public void write_value(Serializable serializable) {
        if (!this.write_special_value(serializable)) {
            this.write_value_internal(serializable, RepositoryID.repId(serializable.getClass()));
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        if (!this.write_special_value(serializable)) {
            this.valueMap.put(serializable, new Integer(this.pos));
            if (serializable instanceof IDLEntity || serializable instanceof String) {
                this.write_long(0x7FFFFF00);
            } else {
                this.write_long(2147483394);
                this.write_repository_id(RepositoryID.repId(serializable.getClass()));
            }
            boxedValueHelper.write_value(this, serializable);
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        if (!this.write_special_value(serializable)) {
            Class<?> clazz2 = serializable.getClass();
            String string = RepositoryID.repId(clazz2);
            if (clazz2 == clazz && !string.startsWith("RMI:")) {
                this.write_value_internal(serializable, null);
            } else if (clazz.isInstance(serializable)) {
                this.write_value_internal(serializable, string);
            } else {
                throw new BAD_PARAM();
            }
        }
    }

    public void write_value(Serializable serializable, String string) {
        if (!this.write_special_value(serializable)) {
            this.write_value_internal(serializable, string);
        }
    }

    private boolean write_special_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return true;
        }
        Integer n = (Integer)this.valueMap.get(serializable);
        if (n != null) {
            this.write_long(-1);
            this.write_long(n - this.pos);
            return true;
        }
        return false;
    }

    private void write_repository_id(String string) {
        Integer n = (Integer)this.repIdMap.get(string);
        if (n == null) {
            int n2 = 4 - this.index % 4;
            if (n2 != 4) {
                this.index += n2;
                this.pos += n2;
            }
            this.repIdMap.put(string, new Integer(this.pos));
            this.write_string(string);
        } else {
            this.write_long(-1);
            this.write_long(n - this.pos);
        }
    }

    private void write_codebase(String string) {
        Integer n = (Integer)this.codebaseMap.get(string);
        if (n == null) {
            int n2 = 4 - this.index % 4;
            if (n2 != 4) {
                this.index += n2;
                this.pos += n2;
            }
            this.codebaseMap.put(string, new Integer(this.pos));
            this.write_string(string);
        } else {
            this.write_long(-1);
            this.write_long(n - this.pos);
        }
    }

    private void write_value_header(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray.length > 1) {
                this.write_long(2147483398);
                this.write_long(stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    this.write_repository_id(stringArray[n]);
                    ++n;
                }
            } else {
                this.write_long(2147483394);
                this.write_repository_id(stringArray[0]);
            }
        } else {
            this.write_long(0x7FFFFF00);
        }
    }

    private void write_value_header(String[] stringArray, String string) {
        if (string != null) {
            if (stringArray != null) {
                if (stringArray.length > 1) {
                    this.write_long(0x7FFFFF07);
                    this.write_codebase(string);
                    this.write_long(stringArray.length);
                    int n = 0;
                    while (n < stringArray.length) {
                        this.write_repository_id(stringArray[n]);
                        ++n;
                    }
                } else {
                    this.write_long(2147483395);
                    this.write_codebase(string);
                    this.write_repository_id(stringArray[0]);
                }
            } else {
                this.write_long(2147483393);
                this.write_codebase(string);
            }
        } else {
            this.write_value_header(stringArray);
        }
    }

    private void write_value_internal(Serializable serializable, String string) {
        this.valueMap.put(serializable, new Integer(this.pos));
        if (serializable.getClass() == (class$java$lang$String == null ? (class$java$lang$String = CDROutputStream.class$("java.lang.String")) : class$java$lang$String)) {
            String[] stringArray;
            if (string == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string;
            }
            String[] stringArray3 = stringArray;
            this.write_value_header(stringArray3);
            this.write_wstring((String)((java.lang.Object)serializable));
        } else if (serializable instanceof StreamableValue) {
            this.write_value_header(((StreamableValue)serializable)._truncatable_ids());
            ((StreamableValue)serializable)._write(this);
        } else {
            String[] stringArray;
            if (string == null) {
                stringArray = null;
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = string;
            }
            String[] stringArray5 = stringArray;
            String string2 = ValueHandler.getCodebase(serializable.getClass());
            this.write_value_header(stringArray5, string2);
            ValueHandler.writeValue(this, serializable);
        }
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DeferredWriteFrame {
        public int write_pos = 0;
        public int start = 0;
        public int length = 0;
        public byte[] buf = null;

        public DeferredWriteFrame(int n, int n2, int n3, byte[] byArray) {
            this.write_pos = n;
            this.start = n2;
            this.length = n3;
            this.buf = byArray;
        }
    }
}

