/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.connection;

import java.io.IOException;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.connection.Messages;
import org.jacorb.orb.connection.ServiceContextTransportingInputStream;
import org.jacorb.util.Debug;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.GIOP.ReplyHeader_1_0;
import org.omg.GIOP.ReplyHeader_1_0Helper;
import org.omg.GIOP.ReplyHeader_1_2;
import org.omg.GIOP.ReplyHeader_1_2Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableServer.ForwardRequest;

public class ReplyInputStream
extends ServiceContextTransportingInputStream {
    public ReplyHeader_1_2 rep_hdr = null;

    public ReplyInputStream(ORB oRB, byte[] byArray) {
        super(oRB, byArray);
        if (Messages.getMsgType(byArray) != 1) {
            throw new Error("Error: not a reply!");
        }
        switch (this.giop_minor) {
            case 0: 
            case 1: {
                ReplyHeader_1_0 replyHeader_1_0 = ReplyHeader_1_0Helper.read(this);
                this.rep_hdr = new ReplyHeader_1_2(replyHeader_1_0.request_id, ReplyStatusType_1_2.from_int(replyHeader_1_0.reply_status.value()), replyHeader_1_0.service_context);
                break;
            }
            case 2: {
                this.rep_hdr = ReplyHeader_1_2Helper.read(this);
                this.skipHeaderPadding();
                break;
            }
            default: {
                throw new Error("Unknown GIOP minor version: " + this.giop_minor);
            }
        }
    }

    public synchronized void checkExceptions() throws ApplicationException, ForwardRequest {
        switch (this.rep_hdr.reply_status.value()) {
            case 0: {
                break;
            }
            case 1: {
                this.mark(0);
                String string = this.read_string();
                try {
                    this.reset();
                }
                catch (IOException iOException) {
                    Debug.output(1, iOException);
                }
                throw new ApplicationException(string, this);
            }
            case 2: {
                throw SystemExceptionHelper.read(this);
            }
            case 3: 
            case 4: {
                throw new ForwardRequest(this.read_Object());
            }
            case 5: {
                throw new NO_IMPLEMENT("WARNING: Received reply with status NEEDS_ADRESSING_MODE, but this isn't implemented yet");
            }
            default: {
                throw new Error("Received unexpected reply status: " + this.rep_hdr.reply_status.value());
            }
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

