/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.orb.ORB;
import org.jacorb.orb.connection.BiDirPolicy;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.AOMListener;
import org.jacorb.poa.EventListener;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.POAConstants;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.POAManager;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.POAMonitorLightImpl;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.policy.IdAssignmentPolicy;
import org.jacorb.poa.policy.IdUniquenessPolicy;
import org.jacorb.poa.policy.ImplicitActivationPolicy;
import org.jacorb.poa.policy.LifespanPolicy;
import org.jacorb.poa.policy.RequestProcessingPolicy;
import org.jacorb.poa.policy.ServantRetentionPolicy;
import org.jacorb.poa.policy.ThreadPolicy;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.IdUtil;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.LogWriter;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Debug;
import org.jacorb.util.Environment;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;
import org.omg.PortableServer._POALocalBase;

public class POA
extends _POALocalBase {
    private ORB orb;
    private LogTrace logTrace;
    private POAListener poaListener;
    private POAMonitor monitor;
    private POAManager poaManager;
    private POA parent;
    private String name;
    private String qualifiedName;
    private Hashtable childs = new Hashtable();
    Servant defaultServant;
    ServantManager servantManager;
    private AdapterActivator adapterActivator;
    private AOM aom;
    private RequestController requestController;
    private byte[] poaId;
    private byte[] watermark;
    private long objectIdCount;
    protected org.omg.PortableServer.ThreadPolicy threadPolicy;
    protected org.omg.PortableServer.LifespanPolicy lifespanPolicy;
    protected org.omg.PortableServer.IdUniquenessPolicy idUniquenessPolicy;
    protected org.omg.PortableServer.IdAssignmentPolicy idAssignmentPolicy;
    protected org.omg.PortableServer.ServantRetentionPolicy servantRetentionPolicy;
    protected org.omg.PortableServer.RequestProcessingPolicy requestProcessingPolicy;
    protected org.omg.PortableServer.ImplicitActivationPolicy implicitActivationPolicy;
    protected BidirectionalPolicy bidirectionalPolicy;
    private Hashtable all_policies = null;
    private Hashtable createdReferences;
    private boolean etherealize;
    private int shutdownState = 0;
    private java.lang.Object poaCreationLog = new java.lang.Object();
    private java.lang.Object poaDestructionLog = new java.lang.Object();
    private java.lang.Object unknownAdapterLog = new java.lang.Object();
    private boolean unknownAdapterCalled;

    private POA() {
    }

    private POA(ORB oRB, String string, POA pOA, POAManager pOAManager, Policy[] policyArray) {
        BiDirPolicy biDirPolicy;
        this.orb = oRB;
        this.name = string;
        this.parent = pOA;
        this.poaManager = pOAManager;
        this.all_policies = new Hashtable();
        this.createdReferences = new Hashtable();
        if (policyArray != null) {
            int n = 0;
            while (n < policyArray.length) {
                this.all_policies.put(new Integer(policyArray[n].policy_type()), policyArray[n]);
                switch (policyArray[n].policy_type()) {
                    case 16: {
                        this.threadPolicy = (org.omg.PortableServer.ThreadPolicy)policyArray[n];
                        break;
                    }
                    case 17: {
                        this.lifespanPolicy = (org.omg.PortableServer.LifespanPolicy)policyArray[n];
                        break;
                    }
                    case 18: {
                        this.idUniquenessPolicy = (org.omg.PortableServer.IdUniquenessPolicy)policyArray[n];
                        break;
                    }
                    case 19: {
                        this.idAssignmentPolicy = (org.omg.PortableServer.IdAssignmentPolicy)policyArray[n];
                        break;
                    }
                    case 21: {
                        this.servantRetentionPolicy = (org.omg.PortableServer.ServantRetentionPolicy)policyArray[n];
                        break;
                    }
                    case 22: {
                        this.requestProcessingPolicy = (org.omg.PortableServer.RequestProcessingPolicy)policyArray[n];
                        break;
                    }
                    case 20: {
                        this.implicitActivationPolicy = (org.omg.PortableServer.ImplicitActivationPolicy)policyArray[n];
                        break;
                    }
                    case 37: {
                        this.bidirectionalPolicy = (BidirectionalPolicy)policyArray[n];
                    }
                }
                ++n;
            }
        }
        if (this.bidirectionalPolicy != null && (biDirPolicy = (BiDirPolicy)this.bidirectionalPolicy).useBiDirGIOP()) {
            oRB.turnOnBiDirGIOP();
        }
        this.watermark = this.generateWatermark();
        this.logTrace = new LogWriter("POA " + this.name, this.isSystemId());
        this.aom = this.isRetain() ? new AOM(this.isUniqueId(), this.isSingleThreadModel(), this.logTrace) : null;
        this.requestController = new RequestController(this, this.orb, this.aom, this.logTrace);
        this.poaManager.registerPOA(this);
        this.monitor = new POAMonitorLightImpl();
        this.monitor.init(this, this.aom, this.requestController.getRequestQueue(), this.requestController.getPoolManager(), "POA " + this.name, this.isSystemId(), this.logTrace);
        this.monitor.openMonitor();
        if (this.poaListener != null) {
            this.poaListener.poaCreated(this);
        }
        if (this.logTrace.test(1)) {
            this.logTrace.printLog("ready");
        }
    }

    public void _addPOAEventListener(EventListener eventListener) {
        if (eventListener instanceof POAListener) {
            this.addPOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.addAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().addRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().addRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public POA _getChildPOA(String var1_1) throws ParentIsHolding {
        block13: {
            block15: {
                block14: {
                    this.checkDestructionApparent();
                    var2_2 = (POA)this.childs.get(var1_1);
                    if (var2_2 != null && !var2_2.isDestructionApparent()) break block13;
                    if (this.adapterActivator == null) {
                        throw new OBJECT_NOT_EXIST("no adapter activator exists for " + var1_1);
                    }
                    if (this.isHolding()) {
                        throw new ParentIsHolding();
                    }
                    if (this.isDiscarding()) {
                        throw new TRANSIENT("a parent poa is in discarding state");
                    }
                    if (this.isInactive()) {
                        throw new OBJ_ADAPTER("a parent poa is in inactive state");
                    }
                    var3_3 = false;
                    if (!this.isSingleThreadModel()) break block14;
                    var4_4 = this.unknownAdapterLog;
                    synchronized (var4_4) {
                        if (true) ** GOTO lbl26
                    }
                }
                var3_3 = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(var1_1));
                break block15;
                {
                    do {
                        try {
                            this.unknownAdapterLog.wait();
                        }
                        catch (InterruptedException var5_5) {
                            // empty catch block
                        }
lbl26:
                        // 3 sources

                    } while (this.unknownAdapterCalled);
                    this.unknownAdapterCalled = true;
                    try {
                        var3_3 = this.the_activator().unknown_adapter(this, POAUtil.unmaskStr(var1_1));
                        var7_6 = null;
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                    }
                    catch (Throwable var6_8) {
                        var7_7 = null;
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                        throw var6_8;
                    }
                }
            }
            if (!var3_3) {
                throw new OBJECT_NOT_EXIST("poa activation is failed");
            }
            var2_2 = (POA)this.childs.get(var1_1);
            if (var2_2 == null) {
                throw new POAInternalError("error: unknown_adapter returns true, but the child poa doesn't extist");
            }
        }
        return var2_2;
    }

    public String _getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.parent == null ? "" : (this.parent.the_parent() == null ? this.name : this.parent._getQualifiedName() + "/" + this.name);
        }
        return this.qualifiedName;
    }

    public void _invoke(ServerRequest serverRequest) throws WrongAdapter {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            this.checkDestructionApparent();
            if (serverRequest.remainingPOAName() == null) {
                if (!this.previouslyGeneratedObjectKey(serverRequest.objectKey())) {
                    if (this.logTrace.test(0)) {
                        this.logTrace.printLog(serverRequest, "_invoke: object key not previously generated!,  operation: " + serverRequest.operation());
                    }
                    throw new WrongAdapter();
                }
                if (this.isSystemId() && !this.previouslyGeneratedObjectId(serverRequest.objectId())) {
                    if (this.logTrace.test(0)) {
                        this.logTrace.printLog(serverRequest.objectId(), "_invoke: oid not previously generated!, operation: " + serverRequest.operation());
                    }
                    throw new WrongAdapter();
                }
            }
            try {
                this.requestController.queueRequest(serverRequest);
            }
            catch (ResourceLimitReachedException resourceLimitReachedException) {
                throw new TRANSIENT("resource limit reached");
            }
        }
    }

    public static POA _POA_init(ORB oRB) {
        POAManager pOAManager = new POAManager(oRB);
        Policy[] policyArray = null;
        policyArray = new Policy[]{new ImplicitActivationPolicy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)};
        POA pOA = new POA(oRB, "RootPOA", null, pOAManager, policyArray);
        return pOA;
    }

    public void _removePOAEventListener(EventListener eventListener) {
        if (eventListener instanceof POAListener) {
            this.removePOAListener((POAListener)eventListener);
        }
        if (eventListener instanceof AOMListener && this.aom != null) {
            this.aom.removeAOMListener((AOMListener)eventListener);
        }
        if (eventListener instanceof RequestQueueListener) {
            this.requestController.getRequestQueue().removeRequestQueueListener((RequestQueueListener)eventListener);
        }
        if (eventListener instanceof RPPoolManagerListener) {
            this.requestController.getPoolManager().removeRPPoolManagerListener((RPPoolManagerListener)eventListener);
        }
    }

    public byte[] activate_object(Servant servant) throws ServantAlreadyActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() || !this.isSystemId()) {
            throw new WrongPolicy();
        }
        byte[] byArray = this.generateObjectId();
        try {
            this.aom.add(byArray, servant);
            this.orb.set_delegate(servant);
        }
        catch (ObjectAlreadyActive objectAlreadyActive) {
            throw new POAInternalError("error: object already active (activate_object)");
        }
        return byArray;
    }

    public void activate_object_with_id(byte[] byArray, Servant servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "activate_object_with_id: oid not previously generated!");
            }
            throw new BAD_PARAM();
        }
        this.aom.add(byArray, servant);
        this.orb.set_delegate(servant);
    }

    protected synchronized void addPOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.add(this.poaListener, pOAListener);
    }

    protected void changeToActive() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.ACTIVE);
        }
        this.monitor.changeState("changed to active...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.monitor.changeState("active");
    }

    protected void changeToDiscarding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.DISCARDING);
        }
        this.monitor.changeState("changed to discarding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        this.monitor.changeState("discarding");
    }

    protected void changeToHolding() {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.HOLDING);
        }
        this.monitor.changeState("changed to holding ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.waitForCompletion();
        this.monitor.changeState("holding");
    }

    protected void changeToInactive(boolean bl) {
        if (this.poaListener != null) {
            this.poaListener.poaStateChanged(this, POAConstants.INACTIVE);
        }
        this.monitor.changeState("changed to inactive ...");
        this.requestController.resetPreviousCompletionCall();
        this.requestController.continueToWork();
        this.requestController.waitForCompletion();
        if (this.etherealize && this.isRetain() && this.useServantManager()) {
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("etherialize all servants ...");
            }
            this.aom.removeAll((ServantActivator)this.servantManager, this, true);
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("... done");
            }
            if (this.monitor != null) {
                this.monitor.changeState("inactive (etherialization completed)");
            }
        } else if (this.monitor != null) {
            this.monitor.changeState("inactive (no etherialization)");
        }
    }

    public org.omg.PortableServer.IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue idAssignmentPolicyValue) {
        this.checkDestructionApparent();
        return new IdAssignmentPolicy(idAssignmentPolicyValue);
    }

    public org.omg.PortableServer.IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue idUniquenessPolicyValue) {
        this.checkDestructionApparent();
        return new IdUniquenessPolicy(idUniquenessPolicyValue);
    }

    public org.omg.PortableServer.ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue implicitActivationPolicyValue) {
        this.checkDestructionApparent();
        return new ImplicitActivationPolicy(implicitActivationPolicyValue);
    }

    public org.omg.PortableServer.LifespanPolicy create_lifespan_policy(LifespanPolicyValue lifespanPolicyValue) {
        this.checkDestructionApparent();
        return new LifespanPolicy(lifespanPolicyValue);
    }

    public org.omg.PortableServer.POA create_POA(String string, org.omg.PortableServer.POAManager pOAManager, Policy[] policyArray) throws AdapterAlreadyExists, InvalidPolicy {
        POA pOA;
        this.checkDestructionApparent();
        String string2 = POAUtil.maskStr(string);
        if (pOAManager != null && !(pOAManager instanceof POAManager)) {
            throw new ApplicationError("error: the POAManager is incompatible with type \"jacorb.poa.POAManager\"!");
        }
        Policy[] policyArray2 = null;
        if (policyArray != null) {
            short s = this.verifyPolicyList(policyArray);
            if (s != -1) {
                throw new InvalidPolicy(s);
            }
            policyArray2 = new Policy[policyArray.length];
            int n = 0;
            while (n < policyArray.length) {
                policyArray2[n] = policyArray[n].copy();
                ++n;
            }
        }
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            LocalObject localObject;
            pOA = (POA)this.childs.get(string2);
            if (pOA != null && !pOA.isDestructionApparent()) {
                throw new AdapterAlreadyExists();
            }
            if (pOA != null) {
                while ((localObject = (POA)this.childs.get(string2)) != null) {
                    try {
                        this.poaCreationLog.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (pOA == localObject) continue;
                    throw new AdapterAlreadyExists();
                }
            }
            if (this.isShutdownInProgress()) {
                throw new BAD_INV_ORDER();
            }
            localObject = pOAManager == null ? new POAManager(this.orb) : (POAManager)pOAManager;
            pOA = new POA(this.orb, string2, this, (POAManager)localObject, policyArray2);
            if (this.poaListener != null) {
                this.poaListener.poaCreated(pOA);
            }
            this.childs.put(string2, pOA);
        }
        return pOA;
    }

    public Object create_reference(String string) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isSystemId()) {
            throw new WrongPolicy();
        }
        return this.getReference(this.generateObjectId(), string, false);
    }

    public Object create_reference_with_id(byte[] byArray, String string) throws WrongPolicy {
        this.checkDestructionApparent();
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "create_reference_with_id: oid not previously generated!");
            }
            throw new BAD_PARAM();
        }
        return this.getReference(byArray, string, false);
    }

    public org.omg.PortableServer.RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue requestProcessingPolicyValue) {
        this.checkDestructionApparent();
        return new RequestProcessingPolicy(requestProcessingPolicyValue);
    }

    public org.omg.PortableServer.ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue servantRetentionPolicyValue) {
        this.checkDestructionApparent();
        return new ServantRetentionPolicy(servantRetentionPolicyValue);
    }

    public org.omg.PortableServer.ThreadPolicy create_thread_policy(ThreadPolicyValue threadPolicyValue) {
        this.checkDestructionApparent();
        return new ThreadPolicy(threadPolicyValue);
    }

    public void deactivate_object(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        if (!this.aom.contains(byArray)) {
            throw new ObjectNotActive();
        }
        final byte[] byArray2 = byArray;
        final ServantActivator servantActivator = this.useServantManager() ? (ServantActivator)this.servantManager : null;
        final ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        final POA pOA = this;
        Thread thread = new Thread(){

            public void run() {
                POA.this.aom.remove(byArray2, POA.this.requestController, servantActivator, pOA, false);
                POA.this.createdReferences.remove(byteArrayKey);
            }
        };
        thread.start();
    }

    public void destroy(boolean bl, boolean bl2) {
        java.lang.Object object;
        if (bl2 && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        this.makeShutdownInProgress(bl);
        Enumeration enumeration = this.childs.elements();
        while (enumeration.hasMoreElements()) {
            object = (POA)enumeration.nextElement();
            ((POA)object).destroy(this.etherealize, bl2);
        }
        object = new Thread(){

            public void run() {
                POA.this.requestController.waitForShutdown();
                POA.this.makeDestructionApparent();
                POA.this.makeDestructionComplete();
            }
        };
        ((Thread)object).start();
        if (bl2) {
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private byte[] extractWatermark(byte[] byArray) {
        if (byArray.length < this.watermark.length) {
            return new byte[0];
        }
        return IdUtil.extract(byArray, byArray.length - this.watermark.length, this.watermark.length);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public org.omg.PortableServer.POA find_POA(String var1_1, boolean var2_2) throws AdapterNonExistent {
        block9: {
            block10: {
                block11: {
                    this.checkDestructionApparent();
                    var3_3 = POAUtil.maskStr(var1_1);
                    var4_4 = (POA)this.childs.get(var3_3);
                    if (var4_4 != null && !var4_4.isDestructionApparent()) break block9;
                    var5_5 = false;
                    if (!var2_2 || this.the_activator() == null) break block10;
                    if (!this.isSingleThreadModel()) break block11;
                    var6_6 = this.unknownAdapterLog;
                    synchronized (var6_6) {
                        if (true) ** GOTO lbl20
                    }
                }
                var5_5 = this.the_activator().unknown_adapter(this, var1_1);
                break block10;
                {
                    do {
                        try {
                            this.unknownAdapterLog.wait();
                        }
                        catch (InterruptedException var7_7) {
                            // empty catch block
                        }
lbl20:
                        // 3 sources

                    } while (this.unknownAdapterCalled);
                    this.unknownAdapterCalled = true;
                    try {
                        var5_5 = this.the_activator().unknown_adapter(this, var1_1);
                        var9_8 = null;
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                    }
                    catch (Throwable var8_10) {
                        var9_9 = null;
                        this.unknownAdapterCalled = false;
                        this.unknownAdapterLog.notifyAll();
                        throw var8_10;
                    }
                }
            }
            if (!var5_5) {
                throw new AdapterNonExistent();
            }
            var4_4 = (POA)this.childs.get(var3_3);
            if (var4_4 == null) {
                throw new POAInternalError("error: unknown_adapter returns true, but the child poa does'n extist");
            }
        }
        return var4_4;
    }

    private byte[] generateObjectId() {
        if (this.isPersistent()) {
            return IdUtil.concat(IdUtil.createId(4), this.watermark);
        }
        return IdUtil.concat(IdUtil.toId(this.objectIdCount++), this.watermark);
    }

    private byte[] generateWatermark() {
        if (this.watermark == null) {
            this.watermark = this.isPersistent() ? IdUtil.toId(new String(this.getPOAId()).hashCode()) : IdUtil.createId(4);
        }
        return this.watermark;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        if (this.defaultServant == null) {
            throw new NoServant();
        }
        return this.defaultServant;
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        return this.servantManager;
    }

    protected POAMonitor getMonitor() {
        return this.monitor;
    }

    protected ORB getORB() {
        return this.orb;
    }

    public byte[] getPOAId() {
        if (this.poaId == null) {
            byte[] byArray = POAUtil.maskId(Environment.implName() != null ? Environment.implName() : Environment.serverId());
            int n = byArray.length;
            byte[] byArray2 = this._getQualifiedName().getBytes();
            int n2 = byArray2.length;
            if (n2 == 0) {
                this.poaId = byArray;
            } else {
                this.poaId = new byte[n + n2 + 1];
                int n3 = 0;
                System.arraycopy(byArray, 0, this.poaId, n3, n);
                this.poaId[n3 += n] = POAConstants.OBJECT_KEY_SEP_BYTE;
                System.arraycopy(byArray2, 0, this.poaId, ++n3, n2);
            }
        }
        return this.poaId;
    }

    protected Object getReference(byte[] byArray, String string, boolean bl) {
        byte[] byArray2 = POAUtil.maskId(byArray);
        int n = this.getPOAId().length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2 + 1];
        int n3 = 0;
        System.arraycopy(this.getPOAId(), 0, byArray3, n3, n);
        byArray3[n3 += n] = POAConstants.OBJECT_KEY_SEP_BYTE;
        System.arraycopy(byArray2, 0, byArray3, ++n3, n2);
        ByteArrayKey byteArrayKey = new ByteArrayKey(byArray);
        Object object = (Object)this.createdReferences.get(byteArrayKey);
        if (object == null) {
            object = this.orb.getReference(this, byArray3, string, !this.isPersistent());
            if (bl) {
                this.createdReferences.put(byteArrayKey, object);
            }
            if (this.poaListener != null) {
                this.poaListener.referenceCreated(object);
            }
        }
        return object;
    }

    protected RequestController getRequestController() {
        return this.requestController;
    }

    protected State getState() {
        return this.poaManager.get_state();
    }

    public Object id_to_reference(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        servant = this.aom.getServant(byArray);
        if (servant == null) {
            throw new ObjectNotActive();
        }
        return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
    }

    public Servant id_to_servant(byte[] byArray) throws ObjectNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected boolean isActive() {
        return this.poaManager.get_state().value() == 1;
    }

    protected void checkDestructionApparent() {
        if (this.isDestructionApparent()) {
            throw new OBJECT_NOT_EXIST("POA destroyed");
        }
    }

    protected boolean isDestructionApparent() {
        return this.shutdownState >= 2;
    }

    protected boolean isDestructionComplete() {
        return this.shutdownState >= 3;
    }

    protected boolean isDiscarding() {
        return this.poaManager.get_state().value() == 2;
    }

    protected boolean isHolding() {
        return this.poaManager.get_state().value() == 0;
    }

    protected boolean isImplicitActivation() {
        return this.implicitActivationPolicy != null && this.implicitActivationPolicy.value() == ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION;
    }

    protected boolean isInactive() {
        return this.poaManager.get_state().value() == 3;
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    private boolean isInInvocationContext(Servant servant) {
        try {
            if (this.orb.getPOACurrent().get_POA() == this && (servant == null || this.orb.getPOACurrent().getServant() == servant)) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected boolean isMultipleId() {
        return this.idUniquenessPolicy != null && this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.MULTIPLE_ID;
    }

    public boolean isPersistent() {
        return this.lifespanPolicy != null && this.lifespanPolicy.value() == LifespanPolicyValue.PERSISTENT;
    }

    public boolean isRetain() {
        return this.servantRetentionPolicy == null || this.servantRetentionPolicy.value() == ServantRetentionPolicyValue.RETAIN;
    }

    protected boolean isShutdownInProgress() {
        return this.shutdownState >= 1;
    }

    protected boolean isSingleThreadModel() {
        return this.threadPolicy != null && this.threadPolicy.value() == ThreadPolicyValue.SINGLE_THREAD_MODEL;
    }

    public boolean isSystemId() {
        return this.idAssignmentPolicy == null || this.idAssignmentPolicy.value() == IdAssignmentPolicyValue.SYSTEM_ID;
    }

    protected boolean isUniqueId() {
        return this.idUniquenessPolicy == null || this.idUniquenessPolicy.value() == IdUniquenessPolicyValue.UNIQUE_ID;
    }

    protected boolean isUseDefaultServant() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT;
    }

    public boolean isUseServantManager() {
        return this.requestProcessingPolicy != null && this.requestProcessingPolicy.value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER;
    }

    private void makeDestructionApparent() {
        java.lang.Object object = this.poaDestructionLog;
        synchronized (object) {
            if (this.shutdownState < 2) {
                this.poaManager.unregisterPOA(this);
                this.shutdownState = 2;
                if (this.poaListener != null) {
                    this.poaListener.poaStateChanged(this, POAConstants.DESTROYED);
                }
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("destruction is apparent");
                }
                this.monitor.changeState("destruction is apparent ...");
            }
        }
    }

    private void makeDestructionComplete() {
        if (this.shutdownState < 3) {
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("clear up the queue ...");
            }
            this.requestController.clearUpQueue(new OBJECT_NOT_EXIST("adapter destroyed"));
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("... done");
            }
            if (this.etherealize && this.isRetain() && this.useServantManager()) {
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("etherialize all servants ...");
                }
                this.aom.removeAll((ServantActivator)this.servantManager, this, true);
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("... done");
                }
            }
            if (!this.isSingleThreadModel()) {
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("remove all processors from the pool ...");
                }
                this.requestController.clearUpPool();
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("... done");
                }
            }
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("stop the request controller ...");
            }
            this.requestController.end();
            if (this.logTrace.test(3)) {
                this.logTrace.printLog("... done");
            }
            this.shutdownState = 3;
            if (this.parent != null) {
                this.parent.unregisterChild(this.name);
            }
            if (this.logTrace.test(1)) {
                this.logTrace.printLog("destroyed");
            }
            this.monitor.changeState("destroyed");
            this.createdReferences.clear();
            this.all_policies.clear();
        }
    }

    private void makeShutdownInProgress(boolean bl) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            if (this.shutdownState < 1) {
                this.etherealize = bl;
                this.shutdownState = 1;
                if (this.logTrace.test(3)) {
                    this.logTrace.printLog("shutdown is in progress");
                }
                this.monitor.changeState("shutdown is in progress ...");
            }
        }
    }

    public boolean previouslyGeneratedObjectId(byte[] byArray) {
        return IdUtil.equals(this.watermark, this.extractWatermark(byArray));
    }

    public boolean previouslyGeneratedObjectKey(byte[] byArray) {
        return IdUtil.equals(byArray, this.getPOAId(), this.getPOAId().length);
    }

    public byte[] reference_to_id(Object object) throws WrongAdapter, WrongPolicy {
        this.checkDestructionApparent();
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "reference_to_id: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        return byArray;
    }

    public Servant reference_to_servant(Object object) throws ObjectNotActive, WrongAdapter, WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isRetain() && !this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        byte[] byArray = POAUtil.extractOID(object);
        if (this.isSystemId() && !this.previouslyGeneratedObjectId(byArray)) {
            if (this.logTrace.test(0)) {
                this.logTrace.printLog(byArray, "reference_to_servant: oid not previously generated!");
            }
            throw new WrongAdapter();
        }
        Servant servant = null;
        if (this.isRetain() && (servant = this.aom.getServant(byArray)) != null) {
            return servant;
        }
        if (this.useDefaultServant()) {
            return this.defaultServant;
        }
        throw new ObjectNotActive();
    }

    protected synchronized void removePOAListener(POAListener pOAListener) {
        this.poaListener = EventMulticaster.remove(this.poaListener, pOAListener);
    }

    public byte[] servant_to_id(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        if (!(this.isUseDefaultServant() || this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation())) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return byArray;
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_id)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                return byArray;
            }
        }
        if (this.isUseDefaultServant() && servant == this.defaultServant && this.isInInvocationContext(servant)) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_id)");
            }
            return byArray;
        }
        throw new ServantNotActive();
    }

    public Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy {
        this.checkDestructionApparent();
        boolean bl = this.isInInvocationContext(servant);
        if (!(this.isRetain() && this.isUniqueId() || this.isRetain() && this.isImplicitActivation() || bl)) {
            throw new WrongPolicy();
        }
        byte[] byArray = null;
        if (bl) {
            try {
                byArray = this.orb.getPOACurrent().get_object_id();
            }
            catch (NoContext noContext) {
                throw new POAInternalError("error: not in invocation context (servant_to_reference)");
            }
            return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
        }
        if (this.isRetain()) {
            if (this.isUniqueId() && (byArray = this.aom.getObjectId(servant)) != null) {
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
            }
            if (this.isImplicitActivation() && (this.isMultipleId() || !this.aom.contains(servant))) {
                byArray = this.generateObjectId();
                try {
                    this.aom.add(byArray, servant);
                }
                catch (ObjectAlreadyActive objectAlreadyActive) {
                    throw new POAInternalError("error: object already active (servant_to_reference)");
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    byArray = this.aom.getObjectId(servant);
                }
                this.orb.set_delegate(servant);
                return this.getReference(byArray, servant._all_interfaces(this, byArray)[0], true);
            }
        }
        throw new ServantNotActive();
    }

    public void set_servant(Servant servant) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseDefaultServant()) {
            throw new WrongPolicy();
        }
        this.defaultServant = servant;
        if (this.defaultServant != null) {
            this.orb.set_delegate(this.defaultServant);
        }
    }

    public void set_servant_manager(ServantManager servantManager) throws WrongPolicy {
        this.checkDestructionApparent();
        if (!this.isUseServantManager()) {
            throw new WrongPolicy();
        }
        if (this.servantManager != null) {
            throw new BAD_INV_ORDER();
        }
        if (this.isRetain() && !(servantManager instanceof ServantActivator)) {
            throw new WrongPolicy();
        }
        if (!this.isRetain() && !(servantManager instanceof ServantLocator)) {
            throw new WrongPolicy();
        }
        this.servantManager = servantManager;
    }

    protected void setMonitor(POAMonitor pOAMonitor) {
        this.monitor = pOAMonitor;
    }

    public AdapterActivator the_activator() {
        this.checkDestructionApparent();
        return this.adapterActivator;
    }

    public void the_activator(AdapterActivator adapterActivator) {
        this.checkDestructionApparent();
        this.adapterActivator = adapterActivator;
    }

    public String the_name() {
        this.checkDestructionApparent();
        return POAUtil.unmaskStr(this.name);
    }

    public org.omg.PortableServer.POA the_parent() {
        this.checkDestructionApparent();
        return this.parent;
    }

    public org.omg.PortableServer.POA[] the_children() {
        org.omg.PortableServer.POA[] pOAArray;
        this.checkDestructionApparent();
        int n = 0;
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            pOAArray = new org.omg.PortableServer.POA[this.childs.size()];
            Enumeration enumeration = this.childs.elements();
            while (enumeration.hasMoreElements()) {
                pOAArray[n] = (org.omg.PortableServer.POA)enumeration.nextElement();
                ++n;
            }
        }
        return pOAArray;
    }

    public org.omg.PortableServer.POAManager the_POAManager() {
        this.checkDestructionApparent();
        return this.poaManager;
    }

    protected void unregisterChild(String string) {
        java.lang.Object object = this.poaCreationLog;
        synchronized (object) {
            this.childs.remove(string);
            this.poaCreationLog.notifyAll();
        }
    }

    public boolean useDefaultServant() {
        return this.isUseDefaultServant() && this.defaultServant != null;
    }

    protected boolean useServantManager() {
        return this.isUseServantManager() && this.servantManager != null;
    }

    private short verifyPolicyList(Policy[] policyArray) {
        short s = 0;
        while (s < policyArray.length) {
            switch (policyArray[s].policy_type()) {
                case 16: {
                    break;
                }
                case 17: {
                    if (((org.omg.PortableServer.LifespanPolicy)policyArray[s]).value() != LifespanPolicyValue.PERSISTENT || Environment.implName() != null) break;
                    Debug.output(0, "error: cannot create a persistent poa! (implname property is not used)");
                    return s;
                }
                case 18: {
                    break;
                }
                case 19: {
                    break;
                }
                case 21: {
                    if (((org.omg.PortableServer.ServantRetentionPolicy)policyArray[s]).value() != ServantRetentionPolicyValue.NON_RETAIN) break;
                    Policy policy = POAUtil.getPolicy(policyArray, 22);
                    if (policy != null) {
                        if (((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_DEFAULT_SERVANT || ((org.omg.PortableServer.RequestProcessingPolicy)policy).value() == RequestProcessingPolicyValue.USE_SERVANT_MANAGER) break;
                        return s;
                    }
                    return s;
                }
                case 22: {
                    Policy policy;
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() == RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY) {
                        policy = POAUtil.getPolicy(policyArray, 21);
                        if (policy == null || ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() == ServantRetentionPolicyValue.RETAIN) break;
                        return s;
                    }
                    if (((org.omg.PortableServer.RequestProcessingPolicy)policyArray[s]).value() != RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) break;
                    policy = POAUtil.getPolicy(policyArray, 18);
                    Policy policy2 = POAUtil.getPolicy(policyArray, 21);
                    if (policy == null && policy2 == null) {
                        return s;
                    }
                    if (!(policy != null && policy2 == null ? ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID : (policy == null && policy2 != null ? ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN : policy != null && policy2 != null && ((org.omg.PortableServer.IdUniquenessPolicy)policy).value() != IdUniquenessPolicyValue.MULTIPLE_ID && ((org.omg.PortableServer.ServantRetentionPolicy)policy2).value() != ServantRetentionPolicyValue.NON_RETAIN))) break;
                    return s;
                }
                case 20: {
                    if (((org.omg.PortableServer.ImplicitActivationPolicy)policyArray[s]).value() != ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION) break;
                    Policy policy = POAUtil.getPolicy(policyArray, 21);
                    if (policy != null && ((org.omg.PortableServer.ServantRetentionPolicy)policy).value() != ServantRetentionPolicyValue.RETAIN) {
                        return s;
                    }
                    policy = POAUtil.getPolicy(policyArray, 19);
                    if (policy == null || ((org.omg.PortableServer.IdAssignmentPolicy)policy).value() == IdAssignmentPolicyValue.SYSTEM_ID) break;
                    return s;
                }
            }
            s = (short)(s + 1);
        }
        return -1;
    }

    public Policy getPolicy(int n) {
        return (Policy)this.all_policies.get(new Integer(n));
    }
}

