/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.RequestQueue;
import org.jacorb.poa.except.CompletionRequestedException;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.except.ShutdownInProgressException;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.LogTrace;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Environment;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;

public class RequestController
extends Thread {
    private POA poa;
    private ORB orb;
    private RequestQueue requestQueue;
    private AOM aom;
    private RPPoolManager poolManager;
    private static RPPoolManager singletonPoolManager;
    private LogTrace logTrace;
    private Hashtable activeRequestTable;
    private Vector deactivationList = new Vector();
    private boolean terminate;
    private boolean waitForCompletionCalled;
    private boolean waitForShutdownCalled;
    private Object queueLog = new Object();
    private String priorityProp = Environment.getProperty("jacorb.poa.thread_priority");
    private int threadPriority = 10;

    private RequestController() {
    }

    RequestController(POA pOA, ORB oRB, AOM aOM, LogTrace logTrace) {
        this.poa = pOA;
        this.aom = aOM;
        this.orb = oRB;
        this.logTrace = logTrace;
        this.requestQueue = new RequestQueue(this, this.logTrace);
        this.activeRequestTable = this.poa.isSingleThreadModel() ? new Hashtable(1) : new Hashtable(Environment.threadPoolMax());
        this.getPoolManager();
        if (this.priorityProp != null) {
            this.threadPriority = Integer.parseInt(this.priorityProp);
        }
        if (this.threadPriority < 1) {
            this.threadPriority = 1;
        } else if (this.threadPriority > 1) {
            this.threadPriority = 10;
        }
        this.setPriority(this.threadPriority);
        this.setDaemon(true);
        this.start();
    }

    void clearUpPool() {
        this.getPoolManager().destroy();
    }

    void clearUpQueue(SystemException systemException) {
        ServerRequest serverRequest;
        while ((serverRequest = this.requestQueue.removeLast()) != null) {
            this.rejectRequest(serverRequest, systemException);
        }
    }

    void continueToWork() {
        Object object = this.queueLog;
        synchronized (object) {
            this.queueLog.notifyAll();
        }
    }

    synchronized void end() {
        this.terminate = true;
        this.continueToWork();
    }

    synchronized void freeObject(byte[] byArray) {
        this.deactivationList.removeElement(POAUtil.oid_to_bak(byArray));
    }

    AOM getAOM() {
        return this.aom;
    }

    LogTrace getLogTrace() {
        return this.logTrace;
    }

    ORB getORB() {
        return this.orb;
    }

    POA getPOA() {
        return this.poa;
    }

    RPPoolManager getPoolManager() {
        if (this.poolManager == null) {
            if (this.poa.isSingleThreadModel()) {
                if (singletonPoolManager == null) {
                    singletonPoolManager = new RPPoolManager(this.orb.getPOACurrent(), 1, 1);
                }
                this.poolManager = singletonPoolManager;
            } else {
                this.poolManager = new RPPoolManager(this.orb.getPOACurrent(), Environment.threadPoolMin(), Environment.threadPoolMax());
            }
        }
        return this.poolManager;
    }

    RequestQueue getRequestQueue() {
        return this.requestQueue;
    }

    private void processRequest(ServerRequest serverRequest) throws ShutdownInProgressException, CompletionRequestedException {
        Servant servant = null;
        ServantManager servantManager = null;
        boolean bl = false;
        RequestController requestController = this;
        synchronized (requestController) {
            if (this.waitForCompletionCalled) {
                if (this.logTrace.test(2)) {
                    this.logTrace.printLog(serverRequest, "cannot process request, because waitForCompletion was called");
                }
                throw new CompletionRequestedException();
            }
            if (this.waitForShutdownCalled) {
                if (this.logTrace.test(2)) {
                    this.logTrace.printLog(serverRequest, "cannot process request, because the poa goes shutdown");
                }
                throw new ShutdownInProgressException();
            }
            if (this.deactivationList.contains(POAUtil.oid_to_bak(serverRequest.objectId()))) {
                if (!this.poa.isUseServantManager() && !this.poa.isUseDefaultServant()) {
                    if (this.logTrace.test(0)) {
                        this.logTrace.printLog(serverRequest, "cannot process request, because object is already in the deactivation process");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
                bl = true;
            }
            if (!bl && this.poa.isRetain()) {
                servant = this.aom.getServant(serverRequest.objectId());
            }
            if (servant == null) {
                if (this.poa.isUseDefaultServant()) {
                    servant = this.poa.defaultServant;
                    if (servant == null) {
                        if (this.logTrace.test(0)) {
                            this.logTrace.printLog(serverRequest, "cannot process request, because default servant is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else if (this.poa.isUseServantManager()) {
                    servantManager = this.poa.servantManager;
                    if (servantManager == null) {
                        if (this.logTrace.test(0)) {
                            this.logTrace.printLog(serverRequest, "cannot process request, because servant manager is not set");
                        }
                        throw new OBJ_ADAPTER();
                    }
                } else {
                    if (this.logTrace.test(2)) {
                        this.logTrace.printLog(serverRequest, "cannot process request, because object doesn't exist");
                    }
                    throw new OBJECT_NOT_EXIST();
                }
            }
            this.activeRequestTable.put(serverRequest, POAUtil.oid_to_bak(serverRequest.objectId()));
        }
        if (this.logTrace.test(3)) {
            this.logTrace.printLog(serverRequest, "trying to get a RequestProcessor");
        }
        RequestProcessor requestProcessor = this.getPoolManager().getProcessor();
        requestProcessor.init(this, serverRequest, servant, servantManager);
        requestProcessor.begin();
    }

    void queueRequest(ServerRequest serverRequest) throws ResourceLimitReachedException {
        this.requestQueue.add(serverRequest);
    }

    void rejectRequest(ServerRequest serverRequest, SystemException systemException) {
        if (systemException != null) {
            serverRequest.setSystemException(systemException);
        }
        this.orb.getBasicAdapter().return_result(serverRequest);
        if (this.logTrace.test(2)) {
            this.logTrace.printLog(serverRequest, " request rejected with exception: " + systemException);
        }
    }

    synchronized void resetPreviousCompletionCall() {
        if (this.logTrace.test(6)) {
            this.logTrace.printLog("reset a previous completion call");
        }
        this.waitForCompletionCalled = false;
        this.notifyAll();
    }

    void returnResult(ServerRequest serverRequest) {
        this.orb.getBasicAdapter().return_result(serverRequest);
        RequestController requestController = this;
        synchronized (requestController) {
            this.activeRequestTable.remove(serverRequest);
            this.notifyAll();
        }
    }

    public void run() {
        OBJ_ADAPTER oBJ_ADAPTER = new OBJ_ADAPTER("connection closed: adapter inactive");
        TRANSIENT tRANSIENT = new TRANSIENT();
        while (!this.terminate) {
            ServerRequest serverRequest;
            State state = this.poa.getState();
            if (POAUtil.isActive(state)) {
                serverRequest = this.requestQueue.getFirst();
                if (serverRequest != null) {
                    if (serverRequest.remainingPOAName() != null) {
                        this.orb.getBasicAdapter().deliverRequest(serverRequest, this.poa);
                        this.requestQueue.removeFirst();
                        continue;
                    }
                    try {
                        this.processRequest(serverRequest);
                        this.requestQueue.removeFirst();
                    }
                    catch (CompletionRequestedException completionRequestedException) {
                    }
                    catch (ShutdownInProgressException shutdownInProgressException) {
                        this.waitForQueue();
                    }
                    catch (OBJ_ADAPTER oBJ_ADAPTER2) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(serverRequest, oBJ_ADAPTER2);
                    }
                    catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                        this.requestQueue.removeFirst();
                        this.rejectRequest(serverRequest, oBJECT_NOT_EXIST);
                    }
                    continue;
                }
            } else if (!this.waitForShutdownCalled && (POAUtil.isDiscarding(state) || POAUtil.isInactive(state)) && (serverRequest = this.requestQueue.removeLast()) != null) {
                if (POAUtil.isDiscarding(state)) {
                    this.rejectRequest(serverRequest, tRANSIENT);
                    continue;
                }
                this.rejectRequest(serverRequest, oBJ_ADAPTER);
                continue;
            }
            this.waitForQueue();
        }
    }

    synchronized void waitForCompletion() {
        this.waitForCompletionCalled = true;
        while (this.waitForCompletionCalled && !this.activeRequestTable.isEmpty()) {
            try {
                if (this.logTrace.test(6)) {
                    this.logTrace.printLog("somebody waits for completion and there are active processors");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void waitForObjectCompletion(byte[] byArray) {
        ByteArrayKey byteArrayKey = POAUtil.oid_to_bak(byArray);
        while (this.activeRequestTable.contains(byteArrayKey)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.logTrace.test(6)) {
            this.logTrace.printLog(byArray, "all active processors for this object have finished");
        }
        this.deactivationList.addElement(byteArrayKey);
    }

    private void waitForQueue() {
        Object object = this.queueLog;
        synchronized (object) {
            if ((this.requestQueue.isEmpty() || this.poa.isHolding() || this.waitForShutdownCalled) && !this.terminate) {
                try {
                    if (this.logTrace.test(6)) {
                        this.logTrace.printLog("the RequestController goes to sleep");
                    }
                    this.queueLog.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    synchronized void waitForShutdown() {
        this.waitForShutdownCalled = true;
        while (this.waitForShutdownCalled && !this.activeRequestTable.isEmpty()) {
            try {
                if (this.logTrace.test(6)) {
                    this.logTrace.printLog("somebody waits for shutdown and there are active processors");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

