/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.jacorb.trading.test.OutputForwarder;
import org.omg.CORBA.ORB;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkHelper;
import org.omg.CosTrading.LinkPackage.DefaultFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.DuplicateLinkName;
import org.omg.CosTrading.LinkPackage.IllegalLinkName;
import org.omg.CosTrading.LinkPackage.LimitingFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupHelper;

public class ExceptionTest {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: ExceptionTest <ior-file>");
            System.exit(0);
        }
        int n = 0;
        int n2 = 0;
        try {
            Link link;
            Runtime runtime = Runtime.getRuntime();
            new OutputForwarder(runtime.exec("ts " + stringArray[0] + " -d db"), "Trader");
            System.out.println("Press any key when Trader is ready");
            System.in.read();
            ORB oRB = ORB.init(stringArray, null);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(stringArray[0])));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            Lookup lookup = LookupHelper.narrow(oRB.string_to_object(string));
            if (lookup == null) {
                System.out.println("No lookup!");
                System.exit(1);
            }
            if ((link = LinkHelper.narrow(lookup.link_if())) == null) {
                System.out.println("No link!");
                System.exit(1);
            }
            System.out.println("********** Testing exceptions **********");
            try {
                System.out.println("\nExpecting IllegalLinkName");
                link.add_link("", lookup, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception exception) {
                System.out.println("Caught " + exception.toString());
                if (exception instanceof IllegalLinkName) {
                    System.out.println("Test passed");
                    ++n;
                }
                System.out.println("Test failed");
                ++n2;
            }
            try {
                link.add_link("link", lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                System.out.println("\nExpecting DuplicateLinkName");
                link.add_link("link", lookup, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception exception) {
                System.out.println("Caught " + exception.toString());
                if (exception instanceof DuplicateLinkName) {
                    System.out.println("Test passed");
                    ++n;
                }
                System.out.println("Test failed");
                ++n2;
            }
            try {
                System.out.println("\nExpecting InvalidLookupRef");
                link.add_link("link2", null, FollowOption.if_no_local, FollowOption.if_no_local);
            }
            catch (Exception exception) {
                System.out.println("Caught " + exception.toString());
                if (exception instanceof InvalidLookupRef) {
                    System.out.println("Test passed");
                    ++n;
                }
                System.out.println("Test failed");
                ++n2;
            }
            try {
                System.out.println("\nExpecting DefaultFollowTooPermissive");
                link.add_link("link3", lookup, FollowOption.if_no_local, FollowOption.local_only);
            }
            catch (Exception exception) {
                System.out.println("Caught " + exception.toString());
                if (exception instanceof DefaultFollowTooPermissive) {
                    System.out.println("Test passed");
                    ++n;
                }
                System.out.println("Test failed");
                ++n2;
            }
            try {
                System.out.println("\nExpecting LimitingFollowTooPermissive");
                link.add_link("link4", lookup, FollowOption.if_no_local, FollowOption.always);
            }
            catch (Exception exception) {
                System.out.println("Caught " + exception.toString());
                if (exception instanceof LimitingFollowTooPermissive) {
                    System.out.println("Test passed");
                    ++n;
                }
                System.out.println("Test failed");
                ++n2;
            }
            try {
                link.add_link("link5", lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                link.modify_link("link5", FollowOption.local_only, FollowOption.local_only);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\n********** Testing link modification **********");
            LinkInfo linkInfo = link.describe_link("link5");
            if (linkInfo.def_pass_on_follow_rule.value() == FollowOption.local_only.value() && linkInfo.limiting_follow_rule.value() == FollowOption.local_only.value()) {
                System.out.println("Test passed");
                ++n;
            } else {
                System.out.println("Test failed");
                ++n2;
            }
            System.out.println("\n********** Testing link removing **********");
            try {
                link.add_link("link6", lookup, FollowOption.if_no_local, FollowOption.if_no_local);
                link.remove_link("link");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String[] stringArray2 = link.list_links();
            boolean bl = false;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray2[n3].equals("link")) {
                    bl = true;
                }
                ++n3;
            }
            if (!bl) {
                System.out.println("Test passed");
                ++n;
            } else {
                System.out.println("Test failed");
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("\n********** Testing finished **********");
        System.out.println("Total tests: " + (n + n2));
        System.out.println("Correct results: " + n);
        System.out.println("Incorrect results: " + n2);
        System.exit(0);
    }
}

