/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil.multiplexor;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.mq.il.uil.multiplexor.DemuxInputStream;

public class StreamDemux {
    short frameSize = (short)512;
    HashMap openStreams = new HashMap();
    InputStream in;
    DataInputStream objectIn;
    boolean pumpingData = false;
    byte[] inputBuffer = new byte[this.frameSize];

    public StreamDemux(InputStream in) throws IOException {
        this.in = in;
        this.objectIn = new DataInputStream(in);
    }

    public void setFrameSize(short newFrameSize) throws IOException {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            if (this.openStreams.size() > 0) {
                throw new IOException("Cannot change the frame size while there are open streams.");
            }
            this.frameSize = newFrameSize;
            this.inputBuffer = new byte[this.frameSize];
        }
    }

    public short getFrameSize() {
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            short s = this.frameSize;
            return s;
        }
    }

    public InputStream getStream(short id) throws IOException {
        InputStream s;
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            s = (InputStream)this.openStreams.get(new Short(id));
            if (s != null) {
                InputStream inputStream = s;
                return inputStream;
            }
            s = new DemuxInputStream(this, id);
            this.openStreams.put(new Short(id), s);
        }
        return s;
    }

    public int available(DemuxInputStream s) throws IOException {
        return this.objectIn.available();
    }

    public boolean pumpData(DemuxInputStream dest) throws IOException {
        StreamDemux streamDemux = this;
        synchronized (streamDemux) {
            if (this.pumpingData) {
                boolean bl = false;
                return bl;
            }
            this.pumpingData = true;
        }
        short nextFrameSize = this.frameSize;
        block26: while (true) {
            DemuxInputStream s;
            HashMap hashMap;
            short streamId;
            if ((streamId = this.objectIn.readShort()) == 0) {
                switch (this.objectIn.readByte()) {
                    case 0: {
                        this.getStream(this.objectIn.readShort());
                        break;
                    }
                    case 1: {
                        hashMap = this.openStreams;
                        synchronized (hashMap) {
                            s = (DemuxInputStream)this.openStreams.get(new Short(this.objectIn.readShort()));
                        }
                        if (s == null) break;
                        this.closeStream(s.streamId);
                        s.atEOF = true;
                        if (s == dest) continue block26;
                        Object object = s.bufferMutex;
                        synchronized (object) {
                            s.bufferMutex.notify();
                            break;
                        }
                    }
                    case 2: {
                        nextFrameSize = this.objectIn.readShort();
                    }
                }
                continue;
            }
            this.objectIn.readFully(this.inputBuffer, 0, nextFrameSize);
            hashMap = this.openStreams;
            synchronized (hashMap) {
                s = (DemuxInputStream)this.openStreams.get(new Short(streamId));
            }
            if (s == null) continue;
            s.loadBuffer(this.inputBuffer, nextFrameSize);
            if (s == dest) break;
            nextFrameSize = this.frameSize;
        }
        StreamDemux streamDemux2 = this;
        synchronized (streamDemux2) {
            this.pumpingData = false;
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            Iterator iter = this.openStreams.values().iterator();
            while (iter.hasNext() && !this.pumpingData) {
                DemuxInputStream s = (DemuxInputStream)iter.next();
                Object object = s.bufferMutex;
                synchronized (object) {
                    s.bufferMutex.notify();
                }
            }
        }
        return true;
    }

    void closeStream(short id) throws IOException {
        if (id == 0) {
            throw new IOException("Stream id 0 is reserved for internal use.");
        }
        HashMap hashMap = this.openStreams;
        synchronized (hashMap) {
            this.openStreams.remove(new Short(id));
        }
    }
}

